/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.aspects.aj;

import com.jcabi.aspects.Loggable;
import com.jcabi.aspects.aj.Mnemos;
import com.jcabi.aspects.aj.NamedThreads;
import com.jcabi.log.Logger;
import com.jcabi.log.VerboseRunnable;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.aspectj.runtime.internal.CFlowCounter;

@Aspect
public final class MethodLogger {
    private final transient Set<Marker> running = new ConcurrentSkipListSet<Marker>();
    private final transient ScheduledExecutorService monitor = Executors.newSingleThreadScheduledExecutor(new NamedThreads("loggable", "watching of @Loggable annotated methods"));
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ MethodLogger ajc$perSingletonInstance;
    public static final /* synthetic */ CFlowCounter ajc$cflowCounter$0;

    public MethodLogger() {
        this.monitor.scheduleWithFixedDelay((Runnable)new VerboseRunnable(new Runnable(){

            @Override
            public void run() {
                for (Marker marker : MethodLogger.this.running) {
                    marker.monitor();
                }
            }
        }), 1L, 1L, TimeUnit.SECONDS);
    }

    @Around(value="(execution(public * (@com.jcabi.aspects.Loggable *).*(..)) || initialization((@com.jcabi.aspects.Loggable *).new(..))) && !execution(String *.toString()) && !execution(int *.hashCode()) && !execution(boolean *.canEqual(Object)) && !execution(boolean *.equals(Object)) && !cflow(call(com.jcabi.aspects.aj.MethodLogger.new()))")
    public Object wrapClass(ProceedingJoinPoint point) throws Throwable {
        Method method = ((MethodSignature)MethodSignature.class.cast(point.getSignature())).getMethod();
        Object output = method.isAnnotationPresent(Loggable.class) ? point.proceed() : this.wrap(point, method, method.getDeclaringClass().getAnnotation(Loggable.class));
        return output;
    }

    @Around(value="(execution(* *(..)) || initialization(*.new(..))) && @annotation(com.jcabi.aspects.Loggable)")
    public Object wrapMethod(ProceedingJoinPoint point) throws Throwable {
        Method method = ((MethodSignature)MethodSignature.class.cast(point.getSignature())).getMethod();
        return this.wrap(point, method, method.getAnnotation(Loggable.class));
    }

    private Object wrap(ProceedingJoinPoint point, Method method, Loggable annotation) throws Throwable {
        if (Thread.interrupted()) {
            throw new IllegalStateException(String.format("thread '%s' in group '%s' interrupted", Thread.currentThread().getName(), Thread.currentThread().getThreadGroup().getName()));
        }
        long start = System.nanoTime();
        Marker marker = new Marker(point, annotation);
        this.running.add(marker);
        try {
            boolean over;
            Class<?> type = method.getDeclaringClass();
            int level = annotation.value();
            int limit = annotation.limit();
            if (annotation.prepend()) {
                MethodLogger.log(level, type, Mnemos.toText(point, annotation.trim(), annotation.skipArgs()) + ": entered");
            }
            Object result = point.proceed();
            long nano = System.nanoTime() - start;
            boolean bl = over = nano > annotation.unit().toNanos(limit);
            if (MethodLogger.enabled(level, type) || over) {
                StringBuilder msg = new StringBuilder();
                msg.append(Mnemos.toText(point, annotation.trim(), annotation.skipArgs())).append(':');
                if (!method.getReturnType().equals(Void.TYPE)) {
                    msg.append(' ').append(Mnemos.toText(result, annotation.trim(), annotation.skipResult()));
                }
                msg.append(Logger.format((String)" in %[nano]s", (Object[])new Object[]{nano}));
                if (over) {
                    level = 3;
                    msg.append(" (too slow!)");
                }
                MethodLogger.log(level, type, msg.toString());
            }
            Object object = result;
            return object;
        }
        catch (Throwable ex) {
            if (!MethodLogger.contains(annotation.ignore(), ex) && !ex.getClass().isAnnotationPresent(Loggable.Quiet.class)) {
                StackTraceElement trace = ex.getStackTrace()[0];
                MethodLogger.log(4, method.getDeclaringClass(), Logger.format((String)"%s: thrown %s out of %s#%s[%d] in %[nano]s", (Object[])new Object[]{Mnemos.toText(point, annotation.trim(), annotation.skipArgs()), Mnemos.toText(ex), trace.getClassName(), trace.getMethodName(), trace.getLineNumber(), System.nanoTime() - start}));
            }
            throw ex;
        }
        finally {
            this.running.remove(marker);
        }
    }

    private static void log(int level, Class<?> log, String message) {
        if (level == 0) {
            Logger.trace(log, (String)message, (Object[])new Object[0]);
        } else if (level == 1) {
            Logger.debug(log, (String)message, (Object[])new Object[0]);
        } else if (level == 2) {
            Logger.info(log, (String)message, (Object[])new Object[0]);
        } else if (level == 3) {
            Logger.warn(log, (String)message, (Object[])new Object[0]);
        } else if (level == 4) {
            Logger.error(log, (String)message, (Object[])new Object[0]);
        }
    }

    private static boolean enabled(int level, Class<?> log) {
        boolean enabled = level == 0 ? Logger.isTraceEnabled(log) : (level == 1 ? Logger.isDebugEnabled(log) : (level == 2 ? Logger.isInfoEnabled(log) : (level == 3 ? Logger.isWarnEnabled(log) : true)));
        return enabled;
    }

    private static boolean contains(Class<? extends Throwable>[] array, Throwable exp) {
        boolean contains = false;
        Class<? extends Throwable>[] classArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Throwable> type = classArray[n2];
            if (MethodLogger.instanceOf(exp.getClass(), type)) {
                contains = true;
                break;
            }
            ++n2;
        }
        return contains;
    }

    private static boolean instanceOf(Class<?> child, Class<?> parent) {
        boolean instance;
        boolean bl = instance = child.equals(parent) || child.getSuperclass() != null && MethodLogger.instanceOf(child.getSuperclass(), parent);
        if (!instance) {
            Class<?>[] classArray = child.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> iface = classArray[n2];
                instance = MethodLogger.instanceOf(iface, parent);
                if (instance) break;
                ++n2;
            }
        }
        return instance;
    }

    private static String textualize(StackTraceElement[] trace) {
        StringBuilder text = new StringBuilder();
        int pos = 0;
        while (pos < trace.length) {
            if (text.length() > 0) {
                text.append(", ");
            }
            text.append(String.format("%s#%s[%d]", trace[pos].getClassName(), trace[pos].getMethodName(), trace[pos].getLineNumber()));
            ++pos;
        }
        return text.toString();
    }

    public static MethodLogger aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.jcabi.aspects.aj.MethodLogger", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        MethodLogger.ajc$cflowCounter$0 = new CFlowCounter();
        try {
            MethodLogger.ajc$perSingletonInstance = new MethodLogger();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    private static final class Marker
    implements Comparable<Marker> {
        private final transient long started = System.currentTimeMillis();
        private final transient AtomicInteger logged = new AtomicInteger();
        private final transient Thread thread = Thread.currentThread();
        private final transient ProceedingJoinPoint point;
        private final transient Loggable annotation;

        protected Marker(ProceedingJoinPoint pnt, Loggable annt) {
            this.point = pnt;
            this.annotation = annt;
        }

        public void monitor() {
            TimeUnit unit = this.annotation.unit();
            long threshold = this.annotation.limit();
            long age = unit.convert(System.currentTimeMillis() - this.started, TimeUnit.MILLISECONDS);
            int cycle = (int)((age - threshold) / threshold);
            if (cycle > this.logged.get()) {
                Method method = ((MethodSignature)MethodSignature.class.cast(this.point.getSignature())).getMethod();
                Logger.warn(method.getDeclaringClass(), (String)"%s: takes more than %[ms]s, %[ms]s already, thread=%s/%s", (Object[])new Object[]{Mnemos.toText(this.point, true, this.annotation.skipArgs()), TimeUnit.MILLISECONDS.convert(threshold, unit), TimeUnit.MILLISECONDS.convert(age, unit), this.thread.getName(), this.thread.getState()});
                Logger.debug(method.getDeclaringClass(), (String)"%s: thread %s/%s stacktrace: %s", (Object[])new Object[]{Mnemos.toText(this.point, true, this.annotation.skipArgs()), this.thread.getName(), this.thread.getState(), MethodLogger.textualize(this.thread.getStackTrace())});
                this.logged.set(cycle);
            }
        }

        public int hashCode() {
            return this.point.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || ((Marker)Marker.class.cast((Object)obj)).point.equals(this.point);
        }

        @Override
        public int compareTo(Marker marker) {
            int cmp = 0;
            if (this.started < marker.started) {
                cmp = 1;
            } else if (this.started > marker.started) {
                cmp = -1;
            }
            return cmp;
        }
    }
}

