/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase09package;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.AndroidSigner;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.Sign;
import com.jayway.maven.plugins.android.phase09package.ApkBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.dependency.utils.resolvers.DefaultArtifactsResolver;
import org.codehaus.plexus.util.AbstractScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApkMojo
extends AbstractAndroidMojo {
    private Sign sign;
    private String signDebug;
    private File nativeLibrariesDirectory;
    private File nativeLibrariesOutputDirectory;
    private String nativeLibrariesDependenciesHardwareArchitectureDefault;
    private String nativeLibrariesDependenciesHardwareArchitectureOverride;
    private static final Pattern PATTERN_JAR_EXT = Pattern.compile("^.+\\.jar$", 2);

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.generateApk) {
            return;
        }
        this.generateIntermediateAp_();
        File outputFile = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".apk");
        boolean signWithDebugKeyStore = this.getAndroidSigner().isSignWithDebugKeyStore();
        if (this.getAndroidSigner().shouldCreateBothSignedAndUnsignedApk()) {
            this.getLog().info((CharSequence)("Creating debug key signed apk file " + outputFile));
            this.createApkFile(outputFile, true);
            File unsignedOutputFile = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + "-unsigned" + ".apk");
            this.getLog().info((CharSequence)("Creating additional unsigned apk file " + unsignedOutputFile));
            this.createApkFile(unsignedOutputFile, false);
            this.projectHelper.attachArtifact(this.project, unsignedOutputFile, "unsigned");
        } else {
            this.createApkFile(outputFile, signWithDebugKeyStore);
        }
        this.project.getArtifact().setFile(outputFile);
    }

    void createApkFile(File outputFile, boolean signWithDebugKeyStore) throws MojoExecutionException {
        File dexFile = new File(this.project.getBuild().getDirectory(), "classes.dex");
        File zipArchive = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".ap_");
        ArrayList<File> sourceFolders = new ArrayList<File>();
        ArrayList<File> jarFiles = new ArrayList<File>();
        ArrayList<File> nativeFolders = new ArrayList<File>();
        boolean useInternalAPKBuilder = true;
        try {
            this.initializeAPKBuilder();
        }
        catch (MojoExecutionException e) {
            useInternalAPKBuilder = false;
        }
        if (useInternalAPKBuilder) {
            this.doAPKWithAPKBuilder(outputFile, dexFile, zipArchive, sourceFolders, jarFiles, nativeFolders, false, signWithDebugKeyStore, false);
        } else {
            this.doAPKWithCommand(outputFile, dexFile, zipArchive, sourceFolders, jarFiles, nativeFolders, signWithDebugKeyStore);
        }
    }

    private void doAPKWithAPKBuilder(File outputFile, File dexFile, File zipArchive, ArrayList<File> sourceFolders, ArrayList<File> jarFiles, ArrayList<File> nativeFolders, boolean verbose, boolean signWithDebugKeyStore, boolean debug) throws MojoExecutionException {
        sourceFolders.add(new File(this.project.getBuild().getDirectory(), "classes"));
        this.processNativeLibraries(nativeFolders);
        for (Artifact artifact : this.getRelevantCompileArtifacts()) {
            jarFiles.add(artifact.getFile());
        }
        ApkBuilder builder = new ApkBuilder(outputFile, zipArchive, dexFile, signWithDebugKeyStore, verbose ? System.out : null);
        if (debug) {
            builder.setDebugMode(debug);
        }
        for (File sourceFolder : sourceFolders) {
            builder.addSourceFolder(sourceFolder);
        }
        for (File jarFile : jarFiles) {
            if (jarFile.isDirectory()) {
                String[] filenames;
                for (String filename : filenames = jarFile.list(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return PATTERN_JAR_EXT.matcher(name).matches();
                    }
                })) {
                    builder.addResourcesFromJar(new File(jarFile, filename));
                }
                continue;
            }
            builder.addResourcesFromJar(jarFile);
        }
        for (File nativeFolder : nativeFolders) {
            builder.addNativeLibraries(nativeFolder, null);
        }
        builder.sealApk();
    }

    private void doAPKWithCommand(File outputFile, File dexFile, File zipArchive, ArrayList<File> sourceFolders, ArrayList<File> jarFiles, ArrayList<File> nativeFolders, boolean signWithDebugKeyStore) throws MojoExecutionException {
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(outputFile.getAbsolutePath());
        if (!signWithDebugKeyStore) {
            commands.add("-u");
        }
        commands.add("-z");
        commands.add(new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".ap_").getAbsolutePath());
        commands.add("-f");
        commands.add(new File(this.project.getBuild().getDirectory(), "classes.dex").getAbsolutePath());
        commands.add("-rf");
        commands.add(new File(this.project.getBuild().getDirectory(), "classes").getAbsolutePath());
        if (nativeFolders != null && !nativeFolders.isEmpty()) {
            for (File lib : nativeFolders) {
                commands.add("-nf");
                commands.add(lib.getAbsolutePath());
            }
        }
        for (Artifact artifact : this.getRelevantCompileArtifacts()) {
            commands.add("-rj");
            commands.add(artifact.getFile().getAbsolutePath());
        }
        this.getLog().info((CharSequence)(this.getAndroidSdk().getPathForTool("apkbuilder") + " " + ((Object)commands).toString()));
        try {
            executor.executeCommand(this.getAndroidSdk().getPathForTool("apkbuilder"), commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }

    private void initializeAPKBuilder() throws MojoExecutionException {
        File file = this.getAndroidSdk().getSDKLibJar();
        ApkBuilder.initialize(this.getLog(), file);
    }

    private void processNativeLibraries(List<File> natives) throws MojoExecutionException {
        boolean hasValidNativeLibrariesDirectory;
        Set<Artifact> artifacts = this.getNativeDependenciesArtifacts();
        boolean bl = hasValidNativeLibrariesDirectory = this.nativeLibrariesDirectory != null && this.nativeLibrariesDirectory.exists();
        if (artifacts.isEmpty() && hasValidNativeLibrariesDirectory) {
            this.getLog().debug((CharSequence)("No native library dependencies detected, will point directly to " + this.nativeLibrariesDirectory));
            natives.add(this.nativeLibrariesDirectory);
        } else if (!artifacts.isEmpty() || hasValidNativeLibrariesDirectory) {
            File destinationDirectory = new File(this.nativeLibrariesOutputDirectory.getAbsolutePath());
            destinationDirectory.mkdirs();
            natives.add(destinationDirectory);
            if (hasValidNativeLibrariesDirectory) {
                this.getLog().debug((CharSequence)("Copying existing native libraries from " + this.nativeLibrariesDirectory));
                try {
                    FileUtils.copyDirectory((File)this.nativeLibrariesDirectory, (File)destinationDirectory, (FileFilter)new FileFilter(){

                        public boolean accept(File pathname) {
                            return pathname.getName().endsWith(".so");
                        }
                    });
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
            if (!artifacts.isEmpty()) {
                DefaultArtifactsResolver artifactsResolver = new DefaultArtifactsResolver(this.artifactResolver, this.localRepository, this.remoteRepositories, true);
                Set resolvedArtifacts = artifactsResolver.resolve(artifacts, this.getLog());
                for (Artifact resolvedArtifact : resolvedArtifacts) {
                    File artifactFile = resolvedArtifact.getFile();
                    try {
                        String artifactId = resolvedArtifact.getArtifactId();
                        String filename = artifactId.startsWith("lib") ? artifactId + ".so" : "lib" + artifactId + ".so";
                        File finalDestinationDirectory = this.getFinalDestinationDirectoryFor(resolvedArtifact, destinationDirectory);
                        File file = new File(finalDestinationDirectory, filename);
                        this.getLog().debug((CharSequence)("Copying native dependency " + artifactId + " (" + resolvedArtifact.getGroupId() + ") to " + file));
                        FileUtils.copyFile((File)artifactFile, (File)file);
                    }
                    catch (Exception e) {
                        throw new MojoExecutionException("Could not copy native dependency.", e);
                    }
                }
            }
        }
    }

    private File getFinalDestinationDirectoryFor(Artifact resolvedArtifact, File destinationDirectory) {
        String hardwareArchitecture = this.getHardwareArchitectureFor(resolvedArtifact);
        File finalDestinationDirectory = new File(destinationDirectory, hardwareArchitecture + "/");
        finalDestinationDirectory.mkdirs();
        return finalDestinationDirectory;
    }

    private String getHardwareArchitectureFor(Artifact resolvedArtifact) {
        if (StringUtils.isNotBlank((String)this.nativeLibrariesDependenciesHardwareArchitectureOverride)) {
            return this.nativeLibrariesDependenciesHardwareArchitectureOverride;
        }
        String classifier = resolvedArtifact.getClassifier();
        if (StringUtils.isNotBlank((String)classifier)) {
            return classifier;
        }
        return this.nativeLibrariesDependenciesHardwareArchitectureDefault;
    }

    private Set<Artifact> getNativeDependenciesArtifacts() {
        HashSet<Artifact> filteredArtifacts = new HashSet<Artifact>();
        Set allArtifacts = this.project.getDependencyArtifacts();
        for (Artifact artifact : allArtifacts) {
            if (!"so".equals(artifact.getType()) || !"compile".equals(artifact.getScope()) && !"runtime".equals(artifact.getScope())) continue;
            filteredArtifacts.add(artifact);
        }
        return filteredArtifacts;
    }

    private void generateIntermediateAp_() throws MojoExecutionException {
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        File[] overlayDirectories = this.resourceOverlayDirectories == null || this.resourceOverlayDirectories.length == 0 ? new File[]{this.resourceOverlayDirectory} : this.resourceOverlayDirectories;
        if (!this.combinedRes.exists() && !this.combinedRes.mkdirs()) {
            throw new MojoExecutionException("Could not create directory for combined resources at " + this.combinedRes.getAbsolutePath());
        }
        if (this.extractedDependenciesRes.exists()) {
            try {
                this.getLog().info((CharSequence)"Copying dependency resource files to combined resource directory.");
                FileUtils.copyDirectory((File)this.extractedDependenciesRes, (File)this.combinedRes);
            }
            catch (IOException e) {
                throw new MojoExecutionException("", (Exception)e);
            }
        }
        if (this.resourceDirectory.exists()) {
            try {
                this.getLog().info((CharSequence)"Copying local resource files to combined resource directory.");
                FileUtils.copyDirectory((File)this.resourceDirectory, (File)this.combinedRes, (FileFilter)new FileFilter(){

                    public boolean accept(File file) {
                        for (String pattern : AbstractScanner.DEFAULTEXCLUDES) {
                            if (!AbstractScanner.match((String)pattern, (String)file.getAbsolutePath())) continue;
                            ApkMojo.this.getLog().debug((CharSequence)("Excluding " + file.getName() + " from resource copy : matching " + pattern));
                            return false;
                        }
                        return true;
                    }
                });
            }
            catch (IOException e) {
                throw new MojoExecutionException("", (Exception)e);
            }
        }
        if (this.extractedDependenciesAssets.exists()) {
            try {
                this.getLog().info((CharSequence)"Copying dependency assets files to combined assets directory.");
                FileUtils.copyDirectory((File)this.extractedDependenciesAssets, (File)this.combinedAssets, (FileFilter)new FileFilter(){

                    public boolean accept(File file) {
                        for (String pattern : AbstractScanner.DEFAULTEXCLUDES) {
                            if (!AbstractScanner.match((String)pattern, (String)file.getAbsolutePath())) continue;
                            ApkMojo.this.getLog().debug((CharSequence)("Excluding " + file.getName() + " from asset copy : matching " + pattern));
                            return false;
                        }
                        return true;
                    }
                });
            }
            catch (IOException e) {
                throw new MojoExecutionException("", (Exception)e);
            }
        }
        if (this.assetsDirectory.exists()) {
            try {
                this.getLog().info((CharSequence)"Copying local assets files to combined assets directory.");
                FileUtils.copyDirectory((File)this.assetsDirectory, (File)this.combinedAssets, (FileFilter)new FileFilter(){

                    public boolean accept(File file) {
                        for (String pattern : AbstractScanner.DEFAULTEXCLUDES) {
                            if (!AbstractScanner.match((String)pattern, (String)file.getAbsolutePath())) continue;
                            ApkMojo.this.getLog().debug((CharSequence)("Excluding " + file.getName() + " from asset copy : matching " + pattern));
                            return false;
                        }
                        return true;
                    }
                });
            }
            catch (IOException e) {
                throw new MojoExecutionException("", (Exception)e);
            }
        }
        File androidJar = this.getAndroidSdk().getAndroidJar();
        File outputFile = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".ap_");
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("package");
        commands.add("-f");
        commands.add("-M");
        commands.add(this.androidManifestFile.getAbsolutePath());
        for (File resOverlayDir : overlayDirectories) {
            if (resOverlayDir == null || !resOverlayDir.exists()) continue;
            commands.add("-S");
            commands.add(resOverlayDir.getAbsolutePath());
        }
        if (this.combinedRes.exists()) {
            commands.add("-S");
            commands.add(this.combinedRes.getAbsolutePath());
        }
        if (this.combinedAssets.exists()) {
            commands.add("-A");
            commands.add(this.combinedAssets.getAbsolutePath());
        }
        commands.add("-I");
        commands.add(androidJar.getAbsolutePath());
        commands.add("-F");
        commands.add(outputFile.getAbsolutePath());
        if (StringUtils.isNotBlank((String)this.configurations)) {
            commands.add("-c");
            commands.add(this.configurations);
        }
        this.getLog().info((CharSequence)(this.getAndroidSdk().getPathForTool("aapt") + " " + ((Object)commands).toString()));
        try {
            executor.executeCommand(this.getAndroidSdk().getPathForTool("aapt"), commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }

    protected AndroidSigner getAndroidSigner() {
        if (this.sign == null) {
            return new AndroidSigner(this.signDebug);
        }
        return new AndroidSigner(this.sign.getDebug());
    }
}

