/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android;

import com.jayway.maven.plugins.android.InvalidSdkException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidSdk {
    private final File path;
    private final String platform;
    private static final String PARAMETER_MESSAGE = "Please provide a proper Android SDK directory path as configuration parameter <sdk><path>...</path></sdk> in the plugin <configuration/>. As an alternative, you may add the parameter to commandline: -Dandroid.sdk.path=... or set environment variable ANDROID_HOME.";
    public static HashMap<String, String> installedPlatforms2ApiLevels;
    public static HashMap<String, String> installedApiLevels2Platforms;
    private static final String SOURCE_PROPERTIES_FILENAME = "source.properties";
    private static final String PLATFORM_VERSION_PROPERTY = "Platform.Version";
    private static final String API_LEVEL_PROPERTY = "AndroidVersion.ApiLevel";
    private static final String PLATFORMS_FOLDER_NAME = "platforms";
    private static final Set<String> commonToolsIn11And15;

    public AndroidSdk(File path, String platformOrApiLevel) {
        this.path = path;
        this.initPlatformAndApiLevels();
        if (platformOrApiLevel == null) {
            this.platform = platformOrApiLevel;
        } else {
            if (!installedApiLevels2Platforms.containsKey(platformOrApiLevel) && !installedPlatforms2ApiLevels.containsKey(platformOrApiLevel)) {
                throw new InvalidSdkException("Invalid SDK: Platform/API level " + platformOrApiLevel + " not available.");
            }
            if (installedApiLevels2Platforms.containsKey(platformOrApiLevel)) {
                this.platform = platformOrApiLevel;
            } else if (installedPlatforms2ApiLevels.containsKey(platformOrApiLevel)) {
                this.platform = installedPlatforms2ApiLevels.get(platformOrApiLevel);
            } else {
                throw new InvalidSdkException("Invalid SDK: Platform/API level " + platformOrApiLevel + " not available.");
            }
        }
    }

    public Layout getLayout() {
        this.assertPathIsDirectory(this.path);
        File platforms = new File(this.path, PLATFORMS_FOLDER_NAME);
        if (platforms.exists() && platforms.isDirectory()) {
            return Layout.LAYOUT_1_5;
        }
        File androidJar = new File(this.path, "android.jar");
        if (androidJar.exists() && androidJar.isFile()) {
            return Layout.LAYOUT_1_1;
        }
        throw new InvalidSdkException("Android SDK could not be identified from path \"" + this.path + "\". " + PARAMETER_MESSAGE);
    }

    private void assertPathIsDirectory(File path) {
        if (path == null) {
            throw new InvalidSdkException(PARAMETER_MESSAGE);
        }
        if (!path.isDirectory()) {
            throw new InvalidSdkException("Path \"" + path + "\" is not a directory. " + PARAMETER_MESSAGE);
        }
    }

    public String getPathForTool(String tool) {
        if (this.getLayout() == Layout.LAYOUT_1_1) {
            return this.path + "/tools/" + tool;
        }
        if (this.getLayout() == Layout.LAYOUT_1_5) {
            if (commonToolsIn11And15.contains(tool)) {
                return this.path + "/tools/" + tool;
            }
            return this.getPlatform() + "/tools/" + tool;
        }
        throw new InvalidSdkException("Unsupported layout \"" + (Object)((Object)this.getLayout()) + "\"! " + PARAMETER_MESSAGE);
    }

    public String getEmulatorPath() {
        return this.getPathForTool("emulator");
    }

    public String getAdbPath() {
        return this.getPathForTool("adb");
    }

    public String getZipalignPath() {
        return this.getPathForTool("zipalign");
    }

    public String getPathForFrameworkAidl() {
        if (this.getLayout() == Layout.LAYOUT_1_1) {
            return this.path + "/tools/lib/framework.aidl";
        }
        if (this.getLayout() == Layout.LAYOUT_1_5) {
            return this.getPlatform() + "/framework.aidl";
        }
        throw new InvalidSdkException("Unsupported layout \"" + (Object)((Object)this.getLayout()) + "\"! " + PARAMETER_MESSAGE);
    }

    public File getAndroidJar() throws MojoExecutionException {
        if (this.getLayout() == Layout.LAYOUT_1_1) {
            return new File(this.path + "/android.jar");
        }
        if (this.getLayout() == Layout.LAYOUT_1_5) {
            return new File(this.getPlatform() + "/android.jar");
        }
        throw new MojoExecutionException("Invalid Layout \"" + (Object)((Object)this.getLayout()) + "\"! " + PARAMETER_MESSAGE);
    }

    public File getPlatform() {
        this.assertPathIsDirectory(this.path);
        if (this.getLayout() == Layout.LAYOUT_1_1) {
            return this.path;
        }
        File platformsDirectory = new File(this.path, PLATFORMS_FOLDER_NAME);
        this.assertPathIsDirectory(platformsDirectory);
        if (this.platform == null) {
            Object[] platformDirectories = platformsDirectory.listFiles();
            Arrays.sort(platformDirectories);
            return platformDirectories[platformDirectories.length - 1];
        }
        File platformDirectory = new File(platformsDirectory, "android-" + this.platform);
        this.assertPathIsDirectory(platformDirectory);
        return platformDirectory;
    }

    private void initPlatformAndApiLevels() throws InvalidSdkException {
        installedApiLevels2Platforms = new HashMap();
        installedPlatforms2ApiLevels = new HashMap();
        ArrayList<File> sourcePropertyFiles = this.getSourcePropertyFiles();
        for (File file : sourcePropertyFiles) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException e) {
                throw new InvalidSdkException("Error reading " + file.getAbsoluteFile());
            }
            if (!properties.containsKey(PLATFORM_VERSION_PROPERTY) || !properties.containsKey(API_LEVEL_PROPERTY)) continue;
            String platform = properties.getProperty(PLATFORM_VERSION_PROPERTY);
            String apiLevel = properties.getProperty(API_LEVEL_PROPERTY);
            installedApiLevels2Platforms.put(apiLevel, platform);
            installedPlatforms2ApiLevels.put(platform, apiLevel);
        }
    }

    private ArrayList<File> getSourcePropertyFiles() {
        File[] platformDirectories;
        ArrayList<File> sourcePropertyFiles = new ArrayList<File>();
        File platformsDirectory = new File(this.path, PLATFORMS_FOLDER_NAME);
        this.assertPathIsDirectory(platformsDirectory);
        for (File file : platformDirectories = platformsDirectory.listFiles()) {
            if (!file.isDirectory() || !file.getName().startsWith("android-")) continue;
            sourcePropertyFiles.add(new File(file, SOURCE_PROPERTIES_FILENAME));
        }
        return sourcePropertyFiles;
    }

    static {
        commonToolsIn11And15 = new HashSet<String>(){
            {
                this.add("adb");
                this.add("android");
                this.add("apkbuilder");
                this.add("ddms");
                this.add("dmtracedump");
                this.add("draw9patch");
                this.add("emulator");
                this.add("hierarchyviewer");
                this.add("hprof-conv");
                this.add("mksdcard");
                this.add("sqlite3");
                this.add("traceview");
                this.add("zipalign");
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Layout {
        LAYOUT_1_1,
        LAYOUT_1_5;

    }
}

