/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.plexus.util.SelectorUtils;

public class MetaInf {
    private List<String> includes;
    private List<String> excludes;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaInf that = (MetaInf)obj;
        if (this.includes == null ? that.includes != null : !this.includes.equals(that.includes)) {
            return false;
        }
        return !(this.excludes == null ? that.excludes != null : !this.excludes.equals(that.excludes));
    }

    public MetaInf exclude(String ... excludes) {
        this.getExcludes().addAll(Arrays.asList(excludes));
        return this;
    }

    public List<String> getExcludes() {
        if (this.excludes == null) {
            this.excludes = new ArrayList<String>();
        }
        return this.excludes;
    }

    public List<String> getIncludes() {
        if (this.includes == null) {
            this.includes = new ArrayList<String>();
        }
        return this.includes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.excludes == null ? 0 : this.excludes.hashCode());
        result = 31 * result + (this.includes == null ? 0 : this.includes.hashCode());
        return result;
    }

    public MetaInf include(String ... includes) {
        this.getIncludes().addAll(Arrays.asList(includes));
        return this;
    }

    public boolean isIncluded(String name) {
        boolean included;
        boolean bl = included = this.includes == null;
        if (this.includes != null) {
            for (String x : this.includes) {
                if (!SelectorUtils.matchPath((String)("META-INF/" + x), (String)name)) continue;
                included = true;
                break;
            }
        }
        if (included && this.excludes != null) {
            for (String x : this.excludes) {
                if (!SelectorUtils.matchPath((String)("META-INF/" + x), (String)name)) continue;
                included = false;
                break;
            }
        }
        return included;
    }
}

