/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.standalonemojos;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.DeviceCallback;
import com.jayway.maven.plugins.android.configuration.Run;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RunMojo
extends AbstractAndroidMojo {
    private Run run;
    protected boolean debug;
    private boolean parsedDebug;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            LauncherInfo launcherInfo = this.getLauncherActivity();
            this.parseConfiguration();
            this.launch(launcherInfo);
        }
        catch (Exception ex) {
            throw new MojoFailureException("Unable to run launcher Activity", (Throwable)ex);
        }
    }

    private void parseConfiguration() {
        this.parsedDebug = this.run != null ? this.run.isDebug() : this.debug;
    }

    private LauncherInfo getLauncherActivity() throws ParserConfigurationException, SAXException, IOException, XPathExpressionException, ActivityNotFoundException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(this.androidManifestFile);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        XPathExpression xPathExpression = xPath.compile("//manifest/application/activity/intent-filter[action[@name=\"android.intent.action.MAIN\"] and category[@name=\"android.intent.category.LAUNCHER\"]]/..");
        Object result = xPathExpression.evaluate(document, XPathConstants.NODESET);
        if (result instanceof NodeList) {
            NodeList activities = (NodeList)result;
            if (activities.getLength() > 0) {
                LauncherInfo launcherInfo = new LauncherInfo();
                launcherInfo.activity = activities.item(0).getAttributes().getNamedItem("android:name").getNodeValue();
                launcherInfo.packageName = document.getDocumentElement().getAttribute("package").toString();
                return launcherInfo;
            }
            throw new ActivityNotFoundException();
        }
        throw new ActivityNotFoundException();
    }

    private void launch(final LauncherInfo info) throws MojoExecutionException, MojoFailureException {
        final String command = String.format("am start %s-n %s/%s", this.parsedDebug ? "-D " : "", info.packageName, info.activity);
        this.doWithDevices(new DeviceCallback(){

            @Override
            public void doWithDevice(IDevice device) throws MojoExecutionException, MojoFailureException {
                try {
                    RunMojo.this.getLog().info((CharSequence)("Attempting to start " + info.packageName + info.activity + " on device " + device.getSerialNumber() + " (avdName = " + device.getAvdName() + ")"));
                    device.executeShellCommand(command, (IShellOutputReceiver)new NullOutputReceiver());
                }
                catch (IOException ex) {
                    throw new MojoFailureException("Input/Output error", (Throwable)ex);
                }
                catch (TimeoutException ex) {
                    throw new MojoFailureException("Command timeout", (Throwable)ex);
                }
                catch (AdbCommandRejectedException ex) {
                    throw new MojoFailureException("ADB rejected the command", (Throwable)ex);
                }
                catch (ShellCommandUnresponsiveException ex) {
                    throw new MojoFailureException("Unresponsive command", (Throwable)ex);
                }
            }
        });
    }

    private static class LauncherInfo {
        public String packageName;
        public String activity;

        private LauncherInfo() {
        }
    }

    private static class ActivityNotFoundException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ActivityNotFoundException() {
            super("Unable to determine Launcher activity");
        }
    }
}

