package com.hp.hpl.jena.sparql.vocabulary ;

/* CVS $Id: $ */
 
import com.hp.hpl.jena.rdf.model.*;
 
/**
 * Vocabulary definitions from test-manifest-1_1.ttl 
 * @author Auto-generated by schemagen on 20 Apr 2011 11:38 
 */
public class TestManifest_11 {
    /** <p>The RDF model that holds the vocabulary terms</p> */
    private static Model m_model = ModelFactory.createDefaultModel();
    
    /** <p>The namespace of the vocabulary as a string</p> */
    public static final String NS = "http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#";
    
    /** <p>The namespace of the vocabulary as a string</p>
     *  @see #NS */
    public static String getURI() {return NS;}
    
    /** <p>The namespace of the vocabulary as a resource</p> */
    public static final Resource NAMESPACE = m_model.createResource( NS );
    
    /** <p>A type of test specifically for syntax testing for SPARQL 1.1.</p> */
    public static final Resource NegativeSyntaxTest11 = m_model.createResource( "http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#NegativeSyntaxTest11" );
    
    /** <p>A type of test specifically for syntax testing of SPARQL Update. Syntax tests 
     *  are not required to have an associated result, only an action. Negative syntax 
     *  tests are tests of which the result should be a parser error.</p>
     */
    public static final Resource NegativeUpdateSyntaxTest11 = m_model.createResource( "http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#NegativeUpdateSyntaxTest11" );
    
    /** <p>A type of test specifically for syntax testing for SPARQL 1.1.</p> */
    public static final Resource PositiveSyntaxTest11 = m_model.createResource( "http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#PositiveSyntaxTest11" );
    
    /** <p>A type of test specifically for syntax testing of SPARQL Update. Syntax tests 
     *  are not required to have an associated result, only an action.</p>
     */
    public static final Resource PositiveUpdateSyntaxTest11 = m_model.createResource( "http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#PositiveUpdateSyntaxTest11" );
    
    /** <p>A type of test specifically for query evaluation testing. Query evaluation 
     *  tests are required to have an associated input dataset, a query, and an expected 
     *  output dataset.</p>
     */
    public static final Resource UpdateEvaluationTest = m_model.createResource( "http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#UpdateEvaluationTest" );
    
}
