/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.client;

import com.hortonworks.registries.schemaregistry.client.AbstractUrlSelector;
import java.util.PriorityQueue;

public class FailoverUrlSelector
extends AbstractUrlSelector {
    private final PriorityQueue<UrlTimeEntry> failedUrls = new PriorityQueue();
    private String current = this.urls[0];

    public FailoverUrlSelector(String clusterUrl) {
        super(clusterUrl);
    }

    @Override
    public String select() {
        return this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void urlWithError(String url, Exception e) {
        if (this.failedError(e)) {
            PriorityQueue<UrlTimeEntry> priorityQueue = this.failedUrls;
            synchronized (priorityQueue) {
                this.failedUrls.add(new UrlTimeEntry(url, System.currentTimeMillis()));
                if (this.failedUrls.size() == this.urls.length) {
                    this.current = ((UrlTimeEntry)this.failedUrls.remove()).url;
                } else if (this.current.equals(url)) {
                    for (String s : this.urls) {
                        if (this.failedUrls.contains(new UrlTimeEntry(s, System.currentTimeMillis()))) continue;
                        this.current = s;
                        break;
                    }
                }
            }
        }
    }

    protected boolean failedError(Exception ex) {
        return true;
    }

    private static class UrlTimeEntry
    implements Comparable<UrlTimeEntry> {
        final String url;
        private final long time;

        public UrlTimeEntry(String url, long time) {
            this.url = url;
            this.time = time;
        }

        @Override
        public int compareTo(UrlTimeEntry other) {
            int x = 0;
            x = this.time == other.time ? 0 : (this.time < other.time ? -1 : 1);
            return x;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UrlTimeEntry urlTimeEntry = (UrlTimeEntry)o;
            return this.url != null ? this.url.equals(urlTimeEntry.url) : urlTimeEntry.url == null;
        }

        public int hashCode() {
            return this.url != null ? this.url.hashCode() : 0;
        }
    }
}

