package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.SGQDAOHelper.SGQEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class PlaceDAOAbstract<E extends Place> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Place.class;
    }

    @Override
    public SGQEntityEnum getTopiaEntityEnum() {
        return SGQEntityEnum.Place;
    }

    @Override
    public void delete(E entity) throws TopiaException {
        {
            List<Presentation> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from presentation main, inventoryplaces_presentation secondary " +
                    "where main.topiaid=secondary.presentation" +
                    " and secondary.inventoryPlaces='" + entity.getTopiaId() + "'")
                    .addEntity("main", com.herbocailleau.sgq.SGQDAOHelper.getImplementationClass(Presentation.class)).list();

            for (Presentation item : list) {
                item.removeInventoryPlaces(entity);
            }
        }

        super.delete(entity);
    }

    public E findByNaturalId(String code) throws TopiaException {
        return findByProperties(Place.PROPERTY_CODE, code);
    }

    public boolean existByNaturalId(String code) throws TopiaException {
        return existByProperties(Place.PROPERTY_CODE, code);
    }

    /**
     * @deprecated since 2.6.10, prefer use {@link #createByNaturalId}
     * @param code 
     * @return 
     * @throws TopiaException
     */
    @Deprecated
    public E create(String code) throws TopiaException {
        return create(Place.PROPERTY_CODE, code);
    }

    public E createByNaturalId(String code) throws TopiaException {
        return create(Place.PROPERTY_CODE, code);
    }

    public E createByNotNull(String code) throws TopiaException {
        return create(Place.PROPERTY_CODE, code);
    }

    public E findByCode(String v) throws TopiaException {
        E result = findByProperty(Place.PROPERTY_CODE, v);
        return result;
    }

    public List<E> findAllByCode(String v) throws TopiaException {
        List<E> result = findAllByProperty(Place.PROPERTY_CODE, v);
        return result;
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Place.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Place.PROPERTY_NAME, v);
        return result;
    }

    public E findByZone(Zone v) throws TopiaException {
        E result = findByProperty(Place.PROPERTY_ZONE, v);
        return result;
    }

    public List<E> findAllByZone(Zone v) throws TopiaException {
        List<E> result = findAllByProperty(Place.PROPERTY_ZONE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Presentation.class) {
            PresentationDAO dao = (PresentationDAO)
                getContext().getDAO(Presentation.class);
            tmp = dao.findAllContainsInventoryPlaces(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Presentation.class, entity);
        if (!list.isEmpty()) {
            result.put(Presentation.class, list);
        }

        return result;
    }

} //PlaceDAOAbstract<E extends Place>
