/*
 * #%L
 * SGQ :: Business
 * $Id: InventoryImportModel.java 381 2013-05-31 14:45:54Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1/sgq-business/src/main/java/com/herbocailleau/sgq/business/services/csv/InventoryImportModel.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business.services.csv;

import static org.nuiton.i18n.I18n._;

import java.text.ParseException;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.csv.ValueParser;
import org.nuiton.util.csv.ext.AbstractImportModel;

import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.entities.PresentationCode;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.Zone;

/**
 * Zone, Emplacement, Code présentation, Code produit, Nom produit, Lot, DLUO, Valeur relevée
 * 
 * @author echatellier
 */
public class InventoryImportModel extends AbstractImportModel<InventoryBean> {

    public InventoryImportModel(final Map<Integer, Batch> batchCache,
            final Map<String, Place> places, final Map<String, Product> products) {
        super(';');

        newMandatoryColumn("Zone", InventoryBean.PROPERTY_ZONE, new ValueParser<Zone>() {
            @Override
            public Zone parse(String value) throws ParseException {
                Zone result = null;
                if (StringUtils.isNotEmpty(value)) {
                    result = Zone.valueOf(value);
                }
                return result;
            }
        });
        newMandatoryColumn("Emplacement", InventoryBean.PROPERTY_PLACE, new ValueParser<Place>() {
            @Override
            public Place parse(String value) throws ParseException {
                Place result = null;
                if (StringUtils.isNotEmpty(value)) {
                    result = places.get(value);
                }
                return result;
            }
        });
        newMandatoryColumn("Code présentation", InventoryBean.PROPERTY_PRESENTATION_CODE, new ValueParser<PresentationCode>() {
            @Override
            public PresentationCode parse(String value) throws ParseException {
                // can be empty
                PresentationCode result = null;
                if (StringUtils.isNotBlank(value)) {
                    result = PresentationCode.getPresentationCodeFor(value.trim().charAt(0));
                }
                return result;
            }
        });
        newMandatoryColumn("Code produit", InventoryBean.PROPERTY_PRODUCT, new ValueParser<Product>() {
            @Override
            public Product parse(String value) throws ParseException {
                Product result = products.get(value);
                return result;
            }
        });
        newIgnoredColumn("Nom produit");
        newMandatoryColumn("Lot", InventoryBean.PROPERTY_BATCH, new ValueParser<Batch>() {
            @Override
            public Batch parse(String value) throws ParseException {
                // can be empty
                Batch result = null;
                if (StringUtils.isNotBlank(value)) {
                    Integer number = Integer.valueOf(value.trim());
                    result = batchCache.get(number);
                    if (result == null) {
                        throw new SgqBusinessException(_("Impossible de trouver le lot %s", value));
                    }
                }
                return result;
            }
        });
        newIgnoredColumn("DLUO");
        newIgnoredColumn("Remarque");
        newMandatoryColumn("Valeur relevée", InventoryBean.PROPERTY_REAL_QUANTITY, new ValueParser<Double>() {
            @Override
            public Double parse(String value) throws ParseException {
                Double result = null;
                // can be null
                if (StringUtils.isNotBlank(value)) {
                    result = Double.valueOf(value.trim());
                }
                return result;
            }
        });
        
    }

    @Override
    public InventoryBean newEmptyInstance() {
        return new InventoryBean();
    }
}
