/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.expiration;

import com.helger.datetime.helper.PDTFactory;
import java.time.Duration;
import java.time.LocalDateTime;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface IExpirable {
    public @Nullable LocalDateTime getExpirationDateTime();

    default public boolean isExpirationDefined() {
        return this.getExpirationDateTime() != null;
    }

    default public boolean isExpiredNow() {
        return this.isExpiredAt(PDTFactory.getCurrentLocalDateTime());
    }

    default public boolean isExpiredAt(@NonNull LocalDateTime localDateTime) {
        return this.isExpirationDefined() && localDateTime.isAfter(this.getExpirationDateTime());
    }

    default public boolean isExpiredIn(@NonNull Duration duration) {
        return this.isExpiredAt(PDTFactory.getCurrentLocalDateTime().plus(duration));
    }
}

