/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.pair;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.commons.pair.IMutablePair;
import com.helger.commons.pair.IPair;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public final class Pair<DATA1TYPE, DATA2TYPE>
implements IMutablePair<DATA1TYPE, DATA2TYPE>,
ICloneable<Pair<DATA1TYPE, DATA2TYPE>> {
    private DATA1TYPE m_aFirst;
    private DATA2TYPE m_aSecond;

    public Pair() {
        this(null, null);
    }

    public <T2 extends DATA1TYPE, U2 extends DATA2TYPE> Pair(@Nullable T2 T2, @Nullable U2 U2) {
        this.m_aFirst = T2;
        this.m_aSecond = U2;
    }

    public Pair(@NonNull IPair<? extends DATA1TYPE, ? extends DATA2TYPE> iPair) {
        ValueEnforcer.notNull(iPair, (String)"Pair");
        this.m_aFirst = iPair.getFirst();
        this.m_aSecond = iPair.getSecond();
    }

    @Override
    public @Nullable DATA1TYPE getFirst() {
        return this.m_aFirst;
    }

    @Override
    public @NonNull EChange setFirst(@Nullable DATA1TYPE DATA1TYPE) {
        DATA1TYPE DATA1TYPE2 = this.m_aFirst;
        if (EqualsHelper.equals(DATA1TYPE, DATA1TYPE2)) {
            return EChange.UNCHANGED;
        }
        this.m_aFirst = DATA1TYPE;
        return EChange.CHANGED;
    }

    @Override
    public @Nullable DATA2TYPE getSecond() {
        return this.m_aSecond;
    }

    @Override
    public @NonNull EChange setSecond(@Nullable DATA2TYPE DATA2TYPE) {
        DATA2TYPE DATA2TYPE2 = this.m_aSecond;
        if (EqualsHelper.equals(DATA2TYPE, DATA2TYPE2)) {
            return EChange.UNCHANGED;
        }
        this.m_aSecond = DATA2TYPE;
        return EChange.CHANGED;
    }

    public @NonNull Pair<DATA1TYPE, DATA2TYPE> getClone() {
        return new Pair<DATA1TYPE, DATA2TYPE>(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        Pair pair = (Pair)object;
        DATA1TYPE DATA1TYPE = this.m_aFirst;
        DATA2TYPE DATA2TYPE = this.m_aSecond;
        return EqualsHelper.equals(DATA1TYPE, pair.m_aFirst) && EqualsHelper.equals(DATA2TYPE, pair.m_aSecond);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aFirst).append(this.m_aSecond).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("first", this.m_aFirst).append("second", this.m_aSecond).getToString();
    }

    public static <T, U> @NonNull Pair<T, U> create(@Nullable T t, @Nullable U u) {
        return new Pair(t, u);
    }
}

