/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.map;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.UseDirectEqualsAndHashCode;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.map.LRUMap;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseDirectEqualsAndHashCode
@NotThreadSafe
public class LoggingLRUMap<KEYTYPE, VALUETYPE>
extends LRUMap<KEYTYPE, VALUETYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingLRUMap.class);
    private String m_sMapName;

    public LoggingLRUMap(@Nonnegative int n) {
        super(n);
    }

    public LoggingLRUMap(@NonNull LoggingLRUMap<KEYTYPE, VALUETYPE> loggingLRUMap) {
        super(loggingLRUMap);
        this.setMapName(loggingLRUMap.m_sMapName);
    }

    @Override
    public @NonNull LoggingLRUMap<KEYTYPE, VALUETYPE> getClone() {
        return new LoggingLRUMap<KEYTYPE, VALUETYPE>(this);
    }

    public @Nullable String getMapName() {
        return this.m_sMapName;
    }

    public final @NonNull LoggingLRUMap<KEYTYPE, VALUETYPE> setMapName(@Nullable String string) {
        this.m_sMapName = string;
        return this;
    }

    @Override
    protected void onRemoveEldestEntry(@Nonnegative int n,  @NonNull Map.Entry<KEYTYPE, VALUETYPE> entry) {
        LOGGER.warn("Map" + (String)(this.m_sMapName != null ? " '" + this.m_sMapName + "'" : "") + " is full with " + n + " \u2265 " + this.getMaxSize() + " items! Removed key (" + String.valueOf(entry.getKey()) + ") and value (" + String.valueOf(entry.getValue()) + ")");
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        LoggingLRUMap loggingLRUMap = (LoggingLRUMap)object;
        String string = this.m_sMapName;
        return EqualsHelper.equals((Object)string, (Object)loggingLRUMap.m_sMapName);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_sMapName).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("MapName", (Object)this.m_sMapName).getToString();
    }
}

