/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.hierarchy;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.state.EContinue;
import com.helger.collection.commons.ICommonsCollection;
import com.helger.collection.commons.ICommonsIterable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface IHasChildren<CHILDTYPE> {
    default public boolean hasChildren() {
        return this.getChildCount() > 0;
    }

    default public boolean hasNoChildren() {
        return !this.hasChildren();
    }

    @Nonnegative
    public int getChildCount();

    @ReturnsMutableCopy
    public @Nullable ICommonsCollection<? extends CHILDTYPE> getAllChildren();

    public @Nullable ICommonsIterable<? extends CHILDTYPE> getChildren();

    default public void forAllChildren(@NonNull Consumer<? super CHILDTYPE> consumer) {
        if (this.hasChildren()) {
            this.getChildren().forEach(consumer);
        }
    }

    default public @NonNull EContinue forAllChildrenBreakable(@NonNull Function<? super CHILDTYPE, EContinue> function) {
        if (this.hasChildren()) {
            return this.getChildren().forEachBreakable(function);
        }
        return EContinue.CONTINUE;
    }

    default public void forAllChildren(@NonNull Predicate<? super CHILDTYPE> predicate, @NonNull Consumer<? super CHILDTYPE> consumer) {
        if (this.hasChildren()) {
            this.getChildren().findAll(predicate, consumer);
        }
    }

    default public <DSTTYPE> void forAllChildrenMapped(@NonNull Predicate<? super CHILDTYPE> predicate, @NonNull Function<? super CHILDTYPE, ? extends DSTTYPE> function, @NonNull Consumer<? super DSTTYPE> consumer) {
        if (this.hasChildren()) {
            this.getChildren().findAllMapped(predicate, function, consumer);
        }
    }
}

