/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import graphql.servlet.ObjectMapperConfigurer;

public class LazyObjectMapperBuilder {
    private final ObjectMapperConfigurer configurer;
    private volatile ObjectMapper mapper;

    public LazyObjectMapperBuilder(ObjectMapperConfigurer configurer) {
        this.configurer = configurer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMapper getMapper() {
        ObjectMapper result = this.mapper;
        if (result == null) {
            LazyObjectMapperBuilder lazyObjectMapperBuilder = this;
            synchronized (lazyObjectMapperBuilder) {
                result = this.mapper;
                if (result == null) {
                    this.mapper = result = this.createObjectMapper();
                }
            }
        }
        return result;
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper().disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).registerModule((Module)new Jdk8Module());
        this.configurer.configure(mapper);
        return mapper;
    }
}

