/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FieldSet {
    private Map<Descriptors.FieldDescriptor, Object> fields;
    private static final FieldSet DEFAULT_INSTANCE = new FieldSet(Collections.<Descriptors.FieldDescriptor, Object>emptyMap());

    private FieldSet() {
        this.fields = new TreeMap<Descriptors.FieldDescriptor, Object>();
    }

    private FieldSet(Map<Descriptors.FieldDescriptor, Object> fields) {
        this.fields = fields;
    }

    public static FieldSet newFieldSet() {
        return new FieldSet();
    }

    public static FieldSet emptySet() {
        return DEFAULT_INSTANCE;
    }

    public void makeImmutable() {
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : this.fields.entrySet()) {
            if (!entry.getKey().isRepeated()) continue;
            List value = (List)entry.getValue();
            entry.setValue(Collections.unmodifiableList(value));
        }
        this.fields = Collections.unmodifiableMap(this.fields);
    }

    public void clear() {
        this.fields.clear();
    }

    public Map<Descriptors.FieldDescriptor, Object> getAllFields() {
        return Collections.unmodifiableMap(this.fields);
    }

    public Iterator<Map.Entry<Descriptors.FieldDescriptor, Object>> iterator() {
        return this.fields.entrySet().iterator();
    }

    public boolean hasField(Descriptors.FieldDescriptor field) {
        if (field.isRepeated()) {
            throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
        }
        return this.fields.containsKey(field);
    }

    public Object getField(Descriptors.FieldDescriptor field) {
        Object result = this.fields.get(field);
        if (result == null) {
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                if (field.isRepeated()) {
                    return Collections.emptyList();
                }
                return null;
            }
            return field.getDefaultValue();
        }
        return result;
    }

    public void setField(Descriptors.FieldDescriptor field, Object value) {
        if (field.isRepeated()) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
            }
            ArrayList newList = new ArrayList();
            newList.addAll(value);
            for (Object element : newList) {
                this.verifyType(field, element);
            }
            value = newList;
        } else {
            this.verifyType(field, value);
        }
        this.fields.put(field, value);
    }

    public void clearField(Descriptors.FieldDescriptor field) {
        this.fields.remove(field);
    }

    public int getRepeatedFieldCount(Descriptors.FieldDescriptor field) {
        if (!field.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedFieldCount() can only be called on repeated fields.");
        }
        return ((List)this.getField(field)).size();
    }

    public Object getRepeatedField(Descriptors.FieldDescriptor field, int index) {
        if (!field.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        return ((List)this.getField(field)).get(index);
    }

    public void setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
        if (!field.isRepeated()) {
            throw new IllegalArgumentException("setRepeatedField() can only be called on repeated fields.");
        }
        this.verifyType(field, value);
        List list = (List)this.fields.get(field);
        if (list == null) {
            throw new IndexOutOfBoundsException();
        }
        list.set(index, value);
    }

    public void addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
        if (!field.isRepeated()) {
            throw new IllegalArgumentException("setRepeatedField() can only be called on repeated fields.");
        }
        this.verifyType(field, value);
        ArrayList<Object> list = (ArrayList<Object>)this.fields.get(field);
        if (list == null) {
            list = new ArrayList<Object>();
            this.fields.put(field, list);
        }
        list.add(value);
    }

    private void verifyType(Descriptors.FieldDescriptor field, Object value) {
        boolean isValid = false;
        switch (field.getJavaType()) {
            case INT: {
                isValid = value instanceof Integer;
                break;
            }
            case LONG: {
                isValid = value instanceof Long;
                break;
            }
            case FLOAT: {
                isValid = value instanceof Float;
                break;
            }
            case DOUBLE: {
                isValid = value instanceof Double;
                break;
            }
            case BOOLEAN: {
                isValid = value instanceof Boolean;
                break;
            }
            case STRING: {
                isValid = value instanceof String;
                break;
            }
            case BYTE_STRING: {
                isValid = value instanceof ByteString;
                break;
            }
            case ENUM: {
                isValid = value instanceof Descriptors.EnumValueDescriptor && ((Descriptors.EnumValueDescriptor)value).getType() == field.getEnumType();
                break;
            }
            case MESSAGE: {
                boolean bl = isValid = value instanceof Message && ((Message)value).getDescriptorForType() == field.getMessageType();
            }
        }
        if (!isValid) {
            throw new IllegalArgumentException("Wrong object type used with protocol message reflection.  Message type \"" + field.getContainingType().getFullName() + "\", field \"" + (field.isExtension() ? field.getFullName() : field.getName()) + "\", value was type \"" + value.getClass().getName() + "\".");
        }
    }

    public boolean isInitialized() {
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : this.fields.entrySet()) {
            Descriptors.FieldDescriptor field = entry.getKey();
            if (field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
            if (field.isRepeated()) {
                for (Message element : (List)entry.getValue()) {
                    if (element.isInitialized()) continue;
                    return false;
                }
                continue;
            }
            if (((Message)entry.getValue()).isInitialized()) continue;
            return false;
        }
        return true;
    }

    public boolean isInitialized(Descriptors.Descriptor type) {
        for (Descriptors.FieldDescriptor field : type.getFields()) {
            if (!field.isRequired() || this.hasField(field)) continue;
            return false;
        }
        return this.isInitialized();
    }

    public void mergeFrom(Message other) {
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : other.getAllFields().entrySet()) {
            Object existingValue;
            Descriptors.FieldDescriptor field = entry.getKey();
            if (field.isRepeated()) {
                existingValue = (List)this.fields.get(field);
                if (existingValue == null) {
                    existingValue = new ArrayList();
                    this.fields.put(field, existingValue);
                }
                existingValue.addAll((List)entry.getValue());
                continue;
            }
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                existingValue = (Message)this.fields.get(field);
                if (existingValue == null) {
                    this.setField(field, entry.getValue());
                    continue;
                }
                this.setField(field, existingValue.newBuilderForType().mergeFrom((Message)existingValue).mergeFrom((Message)entry.getValue()).build());
                continue;
            }
            this.setField(field, entry.getValue());
        }
    }

    public void mergeFrom(FieldSet other) {
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : other.fields.entrySet()) {
            Object existingValue;
            Descriptors.FieldDescriptor field = entry.getKey();
            Object value = entry.getValue();
            if (field.isRepeated()) {
                existingValue = (List)this.fields.get(field);
                if (existingValue == null) {
                    existingValue = new ArrayList();
                    this.fields.put(field, existingValue);
                }
                existingValue.addAll((List)value);
                continue;
            }
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                existingValue = (Message)this.fields.get(field);
                if (existingValue == null) {
                    this.setField(field, value);
                    continue;
                }
                this.setField(field, existingValue.newBuilderForType().mergeFrom((Message)existingValue).mergeFrom((Message)value).build());
                continue;
            }
            this.setField(field, value);
        }
    }

    public static void mergeFrom(CodedInputStream input, UnknownFieldSet.Builder unknownFields, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
        int tag;
        while ((tag = input.readTag()) != 0 && FieldSet.mergeFieldFrom(input, unknownFields, extensionRegistry, builder, tag)) {
        }
    }

    public static boolean mergeFieldFrom(CodedInputStream input, UnknownFieldSet.Builder unknownFields, ExtensionRegistry extensionRegistry, Message.Builder builder, int tag) throws IOException {
        Object value;
        Descriptors.FieldDescriptor field;
        Descriptors.Descriptor type = builder.getDescriptorForType();
        if (type.getOptions().getMessageSetWireFormat() && tag == WireFormat.MESSAGE_SET_ITEM_TAG) {
            FieldSet.mergeMessageSetExtensionFromCodedStream(input, unknownFields, extensionRegistry, builder);
            return true;
        }
        int wireType = WireFormat.getTagWireType(tag);
        int fieldNumber = WireFormat.getTagFieldNumber(tag);
        Message defaultInstance = null;
        if (type.isExtensionNumber(fieldNumber)) {
            ExtensionRegistry.ExtensionInfo extension = extensionRegistry.findExtensionByNumber(type, fieldNumber);
            if (extension == null) {
                field = null;
            } else {
                field = extension.descriptor;
                defaultInstance = extension.defaultInstance;
            }
        } else {
            field = type.findFieldByNumber(fieldNumber);
        }
        if (field == null || wireType != WireFormat.getWireFormatForFieldType(field.getType())) {
            return unknownFields.mergeFieldFrom(tag, input);
        }
        switch (field.getType()) {
            case GROUP: {
                Message.Builder subBuilder = defaultInstance != null ? defaultInstance.newBuilderForType() : builder.newBuilderForField(field);
                if (!field.isRepeated()) {
                    subBuilder.mergeFrom((Message)builder.getField(field));
                }
                input.readGroup(field.getNumber(), subBuilder, extensionRegistry);
                value = subBuilder.build();
                break;
            }
            case MESSAGE: {
                Message.Builder subBuilder = defaultInstance != null ? defaultInstance.newBuilderForType() : builder.newBuilderForField(field);
                if (!field.isRepeated()) {
                    subBuilder.mergeFrom((Message)builder.getField(field));
                }
                input.readMessage(subBuilder, extensionRegistry);
                value = subBuilder.build();
                break;
            }
            case ENUM: {
                int rawValue = input.readEnum();
                value = field.getEnumType().findValueByNumber(rawValue);
                if (value != null) break;
                unknownFields.mergeVarintField(fieldNumber, rawValue);
                return true;
            }
            default: {
                value = input.readPrimitiveField(field.getType());
            }
        }
        if (field.isRepeated()) {
            builder.addRepeatedField(field, value);
        } else {
            builder.setField(field, value);
        }
        return true;
    }

    private static void mergeMessageSetExtensionFromCodedStream(CodedInputStream input, UnknownFieldSet.Builder unknownFields, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
        int tag;
        Descriptors.Descriptor type = builder.getDescriptorForType();
        int typeId = 0;
        ByteString rawBytes = null;
        Message.Builder subBuilder = null;
        Descriptors.FieldDescriptor field = null;
        while ((tag = input.readTag()) != 0) {
            if (tag == WireFormat.MESSAGE_SET_TYPE_ID_TAG) {
                typeId = input.readUInt32();
                if (typeId == 0) continue;
                ExtensionRegistry.ExtensionInfo extension = extensionRegistry.findExtensionByNumber(type, typeId);
                if (extension != null) {
                    field = extension.descriptor;
                    subBuilder = extension.defaultInstance.newBuilderForType();
                    Message originalMessage = (Message)builder.getField(field);
                    if (originalMessage != null) {
                        subBuilder.mergeFrom(originalMessage);
                    }
                    if (rawBytes == null) continue;
                    subBuilder.mergeFrom(CodedInputStream.newInstance(rawBytes.newInput()));
                    rawBytes = null;
                    continue;
                }
                if (rawBytes == null) continue;
                unknownFields.mergeField(typeId, UnknownFieldSet.Field.newBuilder().addLengthDelimited(rawBytes).build());
                rawBytes = null;
                continue;
            }
            if (tag == WireFormat.MESSAGE_SET_MESSAGE_TAG) {
                if (typeId == 0) {
                    rawBytes = input.readBytes();
                    continue;
                }
                if (subBuilder == null) {
                    unknownFields.mergeField(typeId, UnknownFieldSet.Field.newBuilder().addLengthDelimited(input.readBytes()).build());
                    continue;
                }
                input.readMessage(subBuilder, extensionRegistry);
                continue;
            }
            if (input.skipField(tag)) continue;
            break;
        }
        input.checkLastTagWas(WireFormat.MESSAGE_SET_ITEM_END_TAG);
        if (subBuilder != null) {
            builder.setField(field, subBuilder.build());
        }
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : this.fields.entrySet()) {
            this.writeField(entry.getKey(), entry.getValue(), output);
        }
    }

    public void writeField(Descriptors.FieldDescriptor field, Object value, CodedOutputStream output) throws IOException {
        if (field.isExtension() && field.getContainingType().getOptions().getMessageSetWireFormat()) {
            output.writeMessageSetExtension(field.getNumber(), (Message)value);
        } else if (field.isRepeated()) {
            for (Object element : (List)value) {
                output.writeField(field.getType(), field.getNumber(), element);
            }
        } else {
            output.writeField(field.getType(), field.getNumber(), value);
        }
    }

    public int getSerializedSize() {
        int size = 0;
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : this.fields.entrySet()) {
            Descriptors.FieldDescriptor field = entry.getKey();
            Object value = entry.getValue();
            if (field.isExtension() && field.getContainingType().getOptions().getMessageSetWireFormat()) {
                size += CodedOutputStream.computeMessageSetExtensionSize(field.getNumber(), (Message)value);
                continue;
            }
            if (field.isRepeated()) {
                for (Object element : (List)value) {
                    size += CodedOutputStream.computeFieldSize(field.getType(), field.getNumber(), element);
                }
                continue;
            }
            size += CodedOutputStream.computeFieldSize(field.getType(), field.getNumber(), value);
        }
        return size;
    }
}

