/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.io.PrintWriter;

public class RhinoException
extends RuntimeException {
    private String sourceName;
    private int lineNumber;
    private String lineSource;
    private int columnNumber;
    Object interpreterStackInfo;
    int[] interpreterLineData;

    RhinoException() {
    }

    RhinoException(String string) {
        super(string);
    }

    @Override
    public final String getMessage() {
        String string = this.details();
        if (this.sourceName == null || this.lineNumber <= 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" (");
        if (this.sourceName != null) {
            stringBuilder.append(this.sourceName);
        }
        if (this.lineNumber > 0) {
            stringBuilder.append('#');
            stringBuilder.append(this.lineNumber);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public String details() {
        return super.getMessage();
    }

    public final String sourceName() {
        return this.sourceName;
    }

    public final void initSourceName(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this.sourceName != null) {
            throw new IllegalStateException();
        }
        this.sourceName = string;
    }

    public final int lineNumber() {
        return this.lineNumber;
    }

    public final void initLineNumber(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (this.lineNumber > 0) {
            throw new IllegalStateException();
        }
        this.lineNumber = n;
    }

    public final int columnNumber() {
        return this.columnNumber;
    }

    public final void initColumnNumber(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (this.columnNumber > 0) {
            throw new IllegalStateException();
        }
        this.columnNumber = n;
    }

    public final String lineSource() {
        return this.lineSource;
    }

    public final void initLineSource(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this.lineSource != null) {
            throw new IllegalStateException();
        }
        this.lineSource = string;
    }

    final void recordErrorOrigin(String string, int n, String string2, int n2) {
        if (n == -1) {
            n = 0;
        }
        if (string != null) {
            this.initSourceName(string);
        }
        if (n != 0) {
            this.initLineNumber(n);
        }
        if (string2 != null) {
            this.initLineSource(string2);
        }
        if (n2 != 0) {
            this.initColumnNumber(n2);
        }
    }

    private String generateStackTrace() {
        return "<No stack trace available>";
    }

    public String getScriptStackTrace() {
        return this.getScriptStackTrace(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".js");
            }
        });
    }

    public String getScriptStackTrace(FilenameFilter filenameFilter) {
        return "<No stack trace available>";
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        if (this.interpreterStackInfo == null) {
            super.printStackTrace(printWriter);
        } else {
            printWriter.print(this.generateStackTrace());
        }
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        if (this.interpreterStackInfo == null) {
            super.printStackTrace(printStream);
        } else {
            printStream.print(this.generateStackTrace());
        }
    }
}

