/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.jsonml;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSSourceFile;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.VariableRenamingPolicy;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.JsonMLAst;
import com.google.javascript.jscomp.jsonml.JsonMLError;
import java.util.ArrayList;

public class SecureCompiler {
    private static final String COMPILATION_UNCOMPLETED_MSG = "No compilation has been completed yet.";
    private static final String COMPILATION_UNSUCCESSFUL_MSG = "The last compilation was not successful.";
    private static final String COMPILATION_ALREADY_COMPLETED_MSG = "This instance has already compiled one source.";
    private Compiler compiler = new Compiler();
    private CompilerOptions options = this.getSecureCompilerOptions();
    private JsonMLAst sourceAst;
    private Report report;

    public JsonML getJsonML() {
        Preconditions.checkState((this.report != null ? 1 : 0) != 0, (Object)COMPILATION_UNCOMPLETED_MSG);
        Preconditions.checkState((boolean)this.report.success, (Object)COMPILATION_UNSUCCESSFUL_MSG);
        return this.sourceAst.convertToJsonML();
    }

    public String getString() {
        Preconditions.checkState((this.report != null ? 1 : 0) != 0, (Object)COMPILATION_UNCOMPLETED_MSG);
        Preconditions.checkState((boolean)this.report.success, (Object)COMPILATION_UNSUCCESSFUL_MSG);
        return this.compiler.toSource();
    }

    public Report getReport() {
        Preconditions.checkState((this.report != null ? 1 : 0) != 0, (Object)COMPILATION_UNCOMPLETED_MSG);
        return this.report;
    }

    public void compile(JsonML jsonML) {
        if (this.report != null) {
            throw new IllegalStateException(COMPILATION_ALREADY_COMPLETED_MSG);
        }
        this.sourceAst = new JsonMLAst(jsonML);
        CompilerInput compilerInput = new CompilerInput(this.sourceAst, "[[jsonmlsource]]", false);
        JSModule jSModule = new JSModule("[[jsonmlmodule]]");
        jSModule.add(compilerInput);
        Result result = this.compiler.compile(new JSSourceFile[0], new JSModule[]{jSModule}, this.options);
        this.report = this.generateReport(result);
    }

    private CompilerOptions getSecureCompilerOptions() {
        CompilerOptions compilerOptions = new CompilerOptions();
        compilerOptions.variableRenaming = VariableRenamingPolicy.OFF;
        compilerOptions.inlineLocalVariables = true;
        compilerOptions.inlineLocalFunctions = true;
        compilerOptions.checkGlobalThisLevel = CheckLevel.OFF;
        compilerOptions.coalesceVariableNames = true;
        compilerOptions.deadAssignmentElimination = true;
        compilerOptions.collapseVariableDeclarations = true;
        compilerOptions.convertToDottedProperties = true;
        compilerOptions.labelRenaming = true;
        compilerOptions.removeDeadCode = true;
        compilerOptions.optimizeArgumentsArray = true;
        compilerOptions.removeUnusedVars = false;
        compilerOptions.removeUnusedLocalVars = true;
        return compilerOptions;
    }

    public void enableFoldConstant() {
        this.options.foldConstants = true;
    }

    Report generateReport(Result result) {
        if (result == null) {
            return null;
        }
        ArrayList arrayList = Lists.newArrayList();
        for (JSError jSError : result.errors) {
            arrayList.add(JsonMLError.make(jSError, this.sourceAst));
        }
        ArrayList arrayList2 = Lists.newArrayList();
        for (JSError jSError : result.warnings) {
            arrayList2.add(JsonMLError.make(jSError, this.sourceAst));
        }
        return new Report(arrayList.toArray(new JsonMLError[0]), arrayList2.toArray(new JsonMLError[0]));
    }

    public class Report {
        private final boolean success;
        private final JsonMLError[] errors;
        private final JsonMLError[] warnings;

        private Report(JsonMLError[] jsonMLErrorArray, JsonMLError[] jsonMLErrorArray2) {
            this.success = jsonMLErrorArray.length == 0;
            this.errors = jsonMLErrorArray;
            this.warnings = jsonMLErrorArray2;
        }

        public boolean isSuccessful() {
            return this.success;
        }

        public JsonMLError[] getErrors() {
            return this.errors;
        }

        public JsonMLError[] getWarnings() {
            return this.warnings;
        }
    }
}

