/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

class SourceInformationAnnotator
extends NodeTraversal.AbstractPostOrderCallback {
    private final String sourceFile;
    private final boolean doSanityChecks;

    public SourceInformationAnnotator(String string, boolean bl) {
        this.sourceFile = string;
        this.doSanityChecks = bl;
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        if (this.doSanityChecks && this.sourceFile != null) {
            Preconditions.checkState((boolean)this.sourceFile.equals(node.getProp(16)));
        }
        switch (node.getType()) {
            case 33: {
                Node node3 = node.getFirstChild().getNext();
                if (node3.getType() != 40) break;
                node.putProp(39, node3.getString());
                break;
            }
            case 105: {
                String string = NodeUtil.getNearestFunctionName(node);
                if (string == null) break;
                node.putProp(39, string);
                break;
            }
            case 38: {
                node.putProp(39, node.getString());
                break;
            }
            case 64: {
                for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNext()) {
                    if (node4.getType() != 40 || node4.isQuotedString()) continue;
                    node4.putProp(39, node4.getString());
                }
                break;
            }
        }
    }
}

