/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefinitionSite;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.OptimizeCalls;
import com.google.javascript.jscomp.SimpleDefinitionFinder;
import com.google.javascript.jscomp.UseSite;
import com.google.javascript.rhino.Node;
import java.util.Collection;

public class OptimizeReturns
implements OptimizeCalls.CallGraphCompilerPass,
CompilerPass {
    private AbstractCompiler compiler;

    OptimizeReturns(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    @Override
    @VisibleForTesting
    public void process(Node node, Node node2) {
        SimpleDefinitionFinder simpleDefinitionFinder = new SimpleDefinitionFinder(this.compiler);
        simpleDefinitionFinder.process(node, node2);
        this.process(node, node2, simpleDefinitionFinder);
    }

    @Override
    public void process(Node node, Node node2, SimpleDefinitionFinder simpleDefinitionFinder) {
        for (DefinitionSite definitionSite : simpleDefinitionFinder.getDefinitionSites().toArray(new DefinitionSite[0])) {
            if (!simpleDefinitionFinder.getDefinitionSites().contains(definitionSite)) continue;
            this.optimizeResultsIfEligible(definitionSite, simpleDefinitionFinder);
        }
    }

    private void optimizeResultsIfEligible(DefinitionSite definitionSite, SimpleDefinitionFinder simpleDefinitionFinder) {
        if (definitionSite.inExterns || this.callResultsMaybeUsed(simpleDefinitionFinder, definitionSite)) {
            return;
        }
        this.rewriteReturns(simpleDefinitionFinder, definitionSite.definition.getRValue());
    }

    private boolean callResultsMaybeUsed(SimpleDefinitionFinder simpleDefinitionFinder, DefinitionSite definitionSite) {
        DefinitionsRemover.Definition definition = definitionSite.definition;
        Node node = definition.getRValue();
        if (node == null || !NodeUtil.isFunction(node)) {
            return true;
        }
        if (!SimpleDefinitionFinder.isSimpleFunctionDeclaration(node)) {
            return true;
        }
        if (SimpleDefinitionFinder.maybeExported(this.compiler, definition)) {
            return true;
        }
        Collection<UseSite> collection = simpleDefinitionFinder.getUseSites(definition);
        for (UseSite useSite : collection) {
            Node node2 = useSite.node.getParent();
            if (OptimizeReturns.isCall(useSite)) {
                Node node3 = node2;
                Preconditions.checkState((node3.getType() == 37 ? 1 : 0) != 0);
                if (!OptimizeReturns.isValueUsed(node3)) continue;
                return true;
            }
            if (NodeUtil.isVar(node2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isValueUsed(Node node) {
        Node node2 = node.getParent();
        switch (node2.getType()) {
            case 130: {
                return false;
            }
            case 98: 
            case 100: 
            case 101: {
                return node == node2.getFirstChild() ? true : OptimizeReturns.isValueUsed(node2);
            }
            case 85: {
                return node == node2.getFirstChild() ? false : OptimizeReturns.isValueUsed(node2);
            }
            case 115: {
                if (NodeUtil.isForIn(node2)) {
                    return true;
                }
                return node2.getChildAtIndex(1) == node;
            }
        }
        return true;
    }

    private void rewriteReturns(final SimpleDefinitionFinder simpleDefinitionFinder, Node node) {
        Preconditions.checkState((boolean)NodeUtil.isFunction(node));
        NodeUtil.visitPostOrder(node.getLastChild(), new NodeUtil.Visitor(){

            @Override
            public void visit(Node node) {
                if (node.getType() == 4 && node.hasOneChild()) {
                    boolean bl = NodeUtil.mayHaveSideEffects(node.getFirstChild(), OptimizeReturns.this.compiler);
                    if (!bl) {
                        simpleDefinitionFinder.removeReferences(node.getFirstChild());
                    }
                    Node node2 = node.removeFirstChild();
                    if (bl) {
                        node.getParent().addChildBefore(new Node(130, node2).copyInformationFrom(node2), node);
                    }
                    OptimizeReturns.this.compiler.reportCodeChange();
                }
            }
        }, new NodeUtil.MatchShallowStatement());
    }

    private static boolean isCall(UseSite useSite) {
        Node node = useSite.node;
        Node node2 = node.getParent();
        return node2.getFirstChild() == node && NodeUtil.isCall(node2);
    }
}

