/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Set;

abstract class MethodCompilerPass
implements CompilerPass {
    final Set<String> externMethods = Sets.newHashSet();
    final Set<String> externMethodsWithoutSignatures = Sets.newHashSet();
    final Set<String> nonMethodProperties = Sets.newHashSet();
    final Multimap<String, Node> methodDefinitions = LinkedHashMultimap.create();
    final AbstractCompiler compiler;

    MethodCompilerPass(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    @Override
    public void process(Node node, Node node2) {
        this.externMethods.clear();
        this.externMethodsWithoutSignatures.clear();
        this.getSignatureStore().reset();
        this.methodDefinitions.clear();
        if (node != null) {
            NodeTraversal.traverse(this.compiler, node, new GetExternMethods());
        }
        ArrayList arrayList = Lists.newArrayList((Object[])new Node[]{node, node2});
        NodeTraversal.traverseRoots(this.compiler, Lists.newArrayList((Object[])new Node[]{node, node2}), new GatherSignatures());
        NodeTraversal.traverseRoots(this.compiler, arrayList, this.getActingCallback());
    }

    abstract NodeTraversal.Callback getActingCallback();

    abstract SignatureStore getSignatureStore();

    private void addPossibleSignature(String string, Node node, NodeTraversal nodeTraversal) {
        if (node.getType() == 105) {
            this.addSignature(string, node, nodeTraversal.getSourceName());
        } else {
            this.nonMethodProperties.add(string);
        }
    }

    private void addSignature(String string, Node node, String string2) {
        if (this.externMethodsWithoutSignatures.contains(string)) {
            return;
        }
        this.getSignatureStore().addSignature(string, node, string2);
        this.methodDefinitions.put((Object)string, (Object)node);
    }

    private class GatherSignatures
    extends NodeTraversal.AbstractPostOrderCallback {
        private GatherSignatures() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            switch (node.getType()) {
                case 33: 
                case 35: {
                    Node node3 = node.getFirstChild().getNext();
                    if (node3.getType() != 40) break;
                    if (node3.getString().equals("prototype")) {
                        this.processPrototypeParent(nodeTraversal, node2);
                        break;
                    }
                    if (node2.getType() != 86 || node2.getFirstChild() != node) break;
                    MethodCompilerPass.this.addPossibleSignature(node3.getString(), node.getNext(), nodeTraversal);
                    break;
                }
                case 64: {
                    for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNext()) {
                        if (node4.getType() != 40) continue;
                        Node node5 = node4.getFirstChild();
                        MethodCompilerPass.this.addPossibleSignature(node4.getString(), node5, nodeTraversal);
                    }
                    break;
                }
            }
        }

        private void processPrototypeParent(NodeTraversal nodeTraversal, Node node) {
            switch (node.getType()) {
                case 33: 
                case 35: {
                    Node node2 = node.getFirstChild().getNext();
                    Node node3 = node.getParent().getParent();
                    if (node2.getType() != 40 || node3.getType() != 86) break;
                    Node node4 = node3.getFirstChild().getNext();
                    MethodCompilerPass.this.addPossibleSignature(node2.getString(), node4, nodeTraversal);
                }
            }
        }
    }

    private class GetExternMethods
    extends NodeTraversal.AbstractPostOrderCallback {
        private GetExternMethods() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            switch (node.getType()) {
                case 33: 
                case 35: {
                    Node node3 = node.getFirstChild().getNext();
                    if (node3.getType() != 40) {
                        return;
                    }
                    String string = node3.getString();
                    if (node2.getType() == 86 && node2.getFirstChild() == node && node.getNext().getType() == 105) {
                        MethodCompilerPass.this.addSignature(string, node.getNext(), nodeTraversal.getSourceName());
                    } else {
                        MethodCompilerPass.this.getSignatureStore().removeSignature(string);
                        MethodCompilerPass.this.externMethodsWithoutSignatures.add(string);
                    }
                    MethodCompilerPass.this.externMethods.add(string);
                    break;
                }
                case 64: {
                    for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNext()) {
                        if (node4.getType() != 40) continue;
                        Node node5 = node4.getFirstChild();
                        String string = node4.getString();
                        if (node5.getType() == 105) {
                            MethodCompilerPass.this.addSignature(string, node5, nodeTraversal.getSourceName());
                        } else {
                            MethodCompilerPass.this.getSignatureStore().removeSignature(string);
                            MethodCompilerPass.this.externMethodsWithoutSignatures.add(string);
                        }
                        MethodCompilerPass.this.externMethods.add(string);
                    }
                    break;
                }
            }
        }
    }

    static interface SignatureStore {
        public void reset();

        public void addSignature(String var1, Node var2, String var3);

        public void removeSignature(String var1);
    }
}

