/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.FlowScope;
import com.google.javascript.jscomp.ReverseAbstractInterpreter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticSlot;
import com.google.javascript.rhino.jstype.UnionType;
import com.google.javascript.rhino.jstype.Visitor;

abstract class ChainableReverseAbstractInterpreter
implements ReverseAbstractInterpreter {
    protected final CodingConvention convention;
    final JSTypeRegistry typeRegistry;
    private ChainableReverseAbstractInterpreter firstLink;
    private ChainableReverseAbstractInterpreter nextLink;
    private final Visitor<JSType> restrictUndefinedVisitor = new Visitor<JSType>(){

        @Override
        public JSType caseEnumElementType(EnumElementType enumElementType) {
            JSType jSType = enumElementType.getPrimitiveType().visit(this);
            if (jSType != null && enumElementType.getPrimitiveType().equals(jSType)) {
                return enumElementType;
            }
            return jSType;
        }

        @Override
        public JSType caseAllType() {
            return ChainableReverseAbstractInterpreter.this.typeRegistry.createUnionType(JSTypeNative.OBJECT_TYPE, JSTypeNative.NUMBER_TYPE, JSTypeNative.STRING_TYPE, JSTypeNative.BOOLEAN_TYPE, JSTypeNative.NULL_TYPE);
        }

        @Override
        public JSType caseNoObjectType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }

        @Override
        public JSType caseNoType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NO_TYPE);
        }

        @Override
        public JSType caseBooleanType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.BOOLEAN_TYPE);
        }

        @Override
        public JSType caseFunctionType(FunctionType functionType) {
            return functionType;
        }

        @Override
        public JSType caseNullType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NULL_TYPE);
        }

        @Override
        public JSType caseNumberType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NUMBER_TYPE);
        }

        @Override
        public JSType caseObjectType(ObjectType objectType) {
            return objectType;
        }

        @Override
        public JSType caseStringType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.STRING_TYPE);
        }

        @Override
        public JSType caseUnionType(UnionType unionType) {
            return unionType.getRestrictedUnion(ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.VOID_TYPE));
        }

        @Override
        public JSType caseUnknownType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }

        @Override
        public JSType caseVoidType() {
            return null;
        }
    };
    private final Visitor<JSType> restrictNullVisitor = new Visitor<JSType>(){

        @Override
        public JSType caseEnumElementType(EnumElementType enumElementType) {
            JSType jSType = enumElementType.getPrimitiveType().visit(this);
            if (jSType != null && enumElementType.getPrimitiveType().equals(jSType)) {
                return enumElementType;
            }
            return jSType;
        }

        @Override
        public JSType caseAllType() {
            return ChainableReverseAbstractInterpreter.this.typeRegistry.createUnionType(JSTypeNative.OBJECT_TYPE, JSTypeNative.NUMBER_TYPE, JSTypeNative.STRING_TYPE, JSTypeNative.BOOLEAN_TYPE, JSTypeNative.VOID_TYPE);
        }

        @Override
        public JSType caseNoObjectType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }

        @Override
        public JSType caseNoType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NO_TYPE);
        }

        @Override
        public JSType caseBooleanType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.BOOLEAN_TYPE);
        }

        @Override
        public JSType caseFunctionType(FunctionType functionType) {
            return functionType;
        }

        @Override
        public JSType caseNullType() {
            return null;
        }

        @Override
        public JSType caseNumberType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NUMBER_TYPE);
        }

        @Override
        public JSType caseObjectType(ObjectType objectType) {
            return objectType;
        }

        @Override
        public JSType caseStringType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.STRING_TYPE);
        }

        @Override
        public JSType caseUnionType(UnionType unionType) {
            return unionType.getRestrictedUnion(ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NULL_TYPE));
        }

        @Override
        public JSType caseUnknownType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }

        @Override
        public JSType caseVoidType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.VOID_TYPE);
        }
    };

    ChainableReverseAbstractInterpreter(CodingConvention codingConvention, JSTypeRegistry jSTypeRegistry) {
        Preconditions.checkNotNull((Object)codingConvention);
        this.convention = codingConvention;
        this.typeRegistry = jSTypeRegistry;
        this.firstLink = this;
        this.nextLink = null;
    }

    ChainableReverseAbstractInterpreter append(ChainableReverseAbstractInterpreter chainableReverseAbstractInterpreter) {
        Preconditions.checkArgument((chainableReverseAbstractInterpreter.nextLink == null ? 1 : 0) != 0);
        this.nextLink = chainableReverseAbstractInterpreter;
        chainableReverseAbstractInterpreter.firstLink = this.firstLink;
        return chainableReverseAbstractInterpreter;
    }

    ChainableReverseAbstractInterpreter getFirst() {
        return this.firstLink;
    }

    protected FlowScope firstPreciserScopeKnowingConditionOutcome(Node node, FlowScope flowScope, boolean bl) {
        return this.firstLink.getPreciserScopeKnowingConditionOutcome(node, flowScope, bl);
    }

    protected FlowScope nextPreciserScopeKnowingConditionOutcome(Node node, FlowScope flowScope, boolean bl) {
        return this.nextLink != null ? this.nextLink.getPreciserScopeKnowingConditionOutcome(node, flowScope, bl) : flowScope;
    }

    JSType getTypeIfRefinable(Node node, FlowScope flowScope) {
        switch (node.getType()) {
            case 38: {
                StaticSlot staticSlot = flowScope.getSlot(node.getString());
                if (staticSlot != null) {
                    JSType jSType = (JSType)staticSlot.getType();
                    if (jSType == null) {
                        jSType = node.getJSType();
                    }
                    return jSType;
                }
                return null;
            }
            case 33: {
                String string = node.getQualifiedName();
                if (string == null) {
                    return null;
                }
                StaticSlot staticSlot = flowScope.getSlot(string);
                JSType jSType = null;
                if (staticSlot != null) {
                    jSType = (JSType)staticSlot.getType();
                }
                if (jSType == null) {
                    jSType = node.getJSType();
                }
                if (jSType == null) {
                    jSType = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
                }
                return jSType;
            }
        }
        return null;
    }

    protected void declareNameInScope(FlowScope flowScope, Node node, JSType jSType) {
        switch (node.getType()) {
            case 38: {
                flowScope.inferSlotType(node.getString(), jSType);
                break;
            }
            case 33: {
                String string = node.getQualifiedName();
                Preconditions.checkNotNull((Object)string);
                JSType jSType2 = node.getJSType();
                jSType2 = jSType2 == null ? this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : jSType2;
                flowScope.inferQualifiedSlot(string, jSType2, jSType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Node cannot be refined. \n" + node.toStringTree());
            }
        }
    }

    final JSType getRestrictedWithoutUndefined(JSType jSType) {
        return jSType == null ? null : jSType.visit(this.restrictUndefinedVisitor);
    }

    final JSType getRestrictedWithoutNull(JSType jSType) {
        return jSType == null ? null : jSType.visit(this.restrictNullVisitor);
    }

    JSType getRestrictedByTypeOfResult(JSType jSType, String string, boolean bl) {
        if (jSType == null) {
            if (bl) {
                JSType jSType2 = this.getNativeTypeForTypeOf(string);
                return jSType2 == null ? this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : jSType2;
            }
            return null;
        }
        return jSType.visit(new RestrictByOneTypeOfResultVisitor(string, bl));
    }

    JSType getNativeType(JSTypeNative jSTypeNative) {
        return this.typeRegistry.getNativeType(jSTypeNative);
    }

    private JSType getNativeTypeForTypeOf(String string) {
        if (string.equals("number")) {
            return this.getNativeType(JSTypeNative.NUMBER_TYPE);
        }
        if (string.equals("boolean")) {
            return this.getNativeType(JSTypeNative.BOOLEAN_TYPE);
        }
        if (string.equals("string")) {
            return this.getNativeType(JSTypeNative.STRING_TYPE);
        }
        if (string.equals("undefined")) {
            return this.getNativeType(JSTypeNative.VOID_TYPE);
        }
        if (string.equals("function")) {
            return this.getNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE);
        }
        return null;
    }

    private class RestrictByOneTypeOfResultVisitor
    extends RestrictByTypeOfResultVisitor {
        private final String value;
        private final boolean resultEqualsValue;

        RestrictByOneTypeOfResultVisitor(String string, boolean bl) {
            this.value = string;
            this.resultEqualsValue = bl;
        }

        private boolean matchesExpectation(String string) {
            return string.equals(this.value) == this.resultEqualsValue;
        }

        @Override
        protected JSType caseTopType(JSType jSType) {
            JSType jSType2;
            JSType jSType3 = jSType;
            if (this.resultEqualsValue && (jSType2 = ChainableReverseAbstractInterpreter.this.getNativeTypeForTypeOf(this.value)) != null) {
                jSType3 = jSType2;
            }
            return jSType3;
        }

        @Override
        public JSType caseNoObjectType() {
            return (this.value.equals("object") || this.value.equals("function")) == this.resultEqualsValue ? ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE) : null;
        }

        @Override
        public JSType caseBooleanType() {
            return this.matchesExpectation("boolean") ? ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.BOOLEAN_TYPE) : null;
        }

        @Override
        public JSType caseFunctionType(FunctionType functionType) {
            return this.matchesExpectation("function") ? functionType : null;
        }

        @Override
        public JSType caseNullType() {
            return this.matchesExpectation("object") ? ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NULL_TYPE) : null;
        }

        @Override
        public JSType caseNumberType() {
            return this.matchesExpectation("number") ? ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NUMBER_TYPE) : null;
        }

        @Override
        public JSType caseObjectType(ObjectType objectType) {
            if (this.value.equals("function")) {
                JSType jSType = ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE);
                return this.resultEqualsValue && jSType.isSubtype(objectType) ? jSType : null;
            }
            return this.matchesExpectation("object") ? objectType : null;
        }

        @Override
        public JSType caseStringType() {
            return this.matchesExpectation("string") ? ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.STRING_TYPE) : null;
        }

        @Override
        public JSType caseVoidType() {
            return this.matchesExpectation("undefined") ? ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.VOID_TYPE) : null;
        }
    }

    abstract class RestrictByFalseTypeOfResultVisitor
    extends RestrictByTypeOfResultVisitor {
        RestrictByFalseTypeOfResultVisitor() {
        }

        @Override
        protected JSType caseTopType(JSType jSType) {
            return jSType;
        }

        @Override
        public JSType caseNoObjectType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }

        @Override
        public JSType caseBooleanType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.BOOLEAN_TYPE);
        }

        @Override
        public JSType caseFunctionType(FunctionType functionType) {
            return functionType;
        }

        @Override
        public JSType caseNullType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NULL_TYPE);
        }

        @Override
        public JSType caseNumberType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NUMBER_TYPE);
        }

        @Override
        public JSType caseObjectType(ObjectType objectType) {
            return objectType;
        }

        @Override
        public JSType caseStringType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.STRING_TYPE);
        }

        @Override
        public JSType caseVoidType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.VOID_TYPE);
        }
    }

    abstract class RestrictByTrueTypeOfResultVisitor
    extends RestrictByTypeOfResultVisitor {
        RestrictByTrueTypeOfResultVisitor() {
        }

        @Override
        public JSType caseNoObjectType() {
            return null;
        }

        @Override
        public JSType caseBooleanType() {
            return null;
        }

        @Override
        public JSType caseFunctionType(FunctionType functionType) {
            return null;
        }

        @Override
        public JSType caseNullType() {
            return null;
        }

        @Override
        public JSType caseNumberType() {
            return null;
        }

        @Override
        public JSType caseObjectType(ObjectType objectType) {
            return null;
        }

        @Override
        public JSType caseStringType() {
            return null;
        }

        @Override
        public JSType caseVoidType() {
            return null;
        }
    }

    abstract class RestrictByTypeOfResultVisitor
    implements Visitor<JSType> {
        RestrictByTypeOfResultVisitor() {
        }

        protected abstract JSType caseTopType(JSType var1);

        @Override
        public JSType caseAllType() {
            return this.caseTopType(ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.ALL_TYPE));
        }

        @Override
        public JSType caseUnknownType() {
            return this.caseTopType(ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
        }

        @Override
        public JSType caseUnionType(UnionType unionType) {
            JSType jSType = null;
            for (JSType jSType2 : unionType.getAlternates()) {
                JSType jSType3 = jSType2.visit(this);
                if (jSType3 == null) continue;
                if (jSType == null) {
                    jSType = jSType3;
                    continue;
                }
                jSType = jSType3.getLeastSupertype(jSType);
            }
            return jSType;
        }

        @Override
        public JSType caseNoType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NO_TYPE);
        }

        @Override
        public JSType caseEnumElementType(EnumElementType enumElementType) {
            JSType jSType = enumElementType.getPrimitiveType().visit(this);
            if (jSType != null && enumElementType.getPrimitiveType().equals(jSType)) {
                return enumElementType;
            }
            return jSType;
        }
    }
}

