/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Sets;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.SortedSet;

public abstract class BasicErrorManager
implements ErrorManager {
    private final SortedSet<ErrorWithLevel> messages = Sets.newTreeSet((Comparator)new LeveledJSErrorComparator());
    private int errorCount = 0;
    private int warningCount = 0;
    private double typedPercent = 0.0;

    @Override
    public void report(CheckLevel checkLevel, JSError jSError) {
        if (this.messages.add(new ErrorWithLevel(jSError, checkLevel))) {
            if (checkLevel == CheckLevel.ERROR) {
                ++this.errorCount;
            } else if (checkLevel == CheckLevel.WARNING) {
                ++this.warningCount;
            }
        }
    }

    @Override
    public void generateReport() {
        for (ErrorWithLevel errorWithLevel : this.messages) {
            this.println(errorWithLevel.level, errorWithLevel.error);
        }
        this.printSummary();
    }

    public abstract void println(CheckLevel var1, JSError var2);

    protected abstract void printSummary();

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public int getWarningCount() {
        return this.warningCount;
    }

    @Override
    public JSError[] getErrors() {
        return this.toArray(CheckLevel.ERROR);
    }

    @Override
    public JSError[] getWarnings() {
        return this.toArray(CheckLevel.WARNING);
    }

    @Override
    public void setTypedPercent(double d) {
        this.typedPercent = d;
    }

    @Override
    public double getTypedPercent() {
        return this.typedPercent;
    }

    private JSError[] toArray(CheckLevel checkLevel) {
        ArrayList<JSError> arrayList = new ArrayList<JSError>(this.messages.size());
        for (ErrorWithLevel errorWithLevel : this.messages) {
            if (errorWithLevel.level != checkLevel) continue;
            arrayList.add(errorWithLevel.error);
        }
        return arrayList.toArray(new JSError[arrayList.size()]);
    }

    static class ErrorWithLevel {
        final JSError error;
        final CheckLevel level;

        ErrorWithLevel(JSError jSError, CheckLevel checkLevel) {
            this.error = jSError;
            this.level = checkLevel;
        }
    }

    static final class LeveledJSErrorComparator
    implements Comparator<ErrorWithLevel> {
        private static final int P1_LT_P2 = -1;
        private static final int P1_GT_P2 = 1;

        LeveledJSErrorComparator() {
        }

        @Override
        public int compare(ErrorWithLevel errorWithLevel, ErrorWithLevel errorWithLevel2) {
            int n;
            int n2;
            int n3;
            if (errorWithLevel2 == null) {
                if (errorWithLevel == null) {
                    return 0;
                }
                return 1;
            }
            if (errorWithLevel.level != errorWithLevel2.level) {
                return errorWithLevel2.level.compareTo(errorWithLevel.level);
            }
            String string = errorWithLevel.error.sourceName;
            String string2 = errorWithLevel2.error.sourceName;
            if (string != null && string2 != null) {
                n3 = string.compareTo(string2);
                if (n3 != 0) {
                    return n3;
                }
            } else {
                if (string == null && string2 != null) {
                    return -1;
                }
                if (string != null && string2 == null) {
                    return 1;
                }
            }
            if ((n3 = errorWithLevel.error.lineNumber) != (n2 = errorWithLevel2.error.lineNumber)) {
                return n3 - n2;
            }
            if (n3 < 0 && 0 <= n2) {
                return -1;
            }
            if (0 <= n3 && n2 < 0) {
                return 1;
            }
            int n4 = errorWithLevel.error.getCharno();
            if (n4 != (n = errorWithLevel2.error.getCharno())) {
                return n4 - n;
            }
            if (n4 < 0 && 0 <= n) {
                return -1;
            }
            if (0 <= n4 && n < 0) {
                return 1;
            }
            return errorWithLevel.error.description.compareTo(errorWithLevel2.error.description);
        }
    }
}

