/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.graph.FixedPointGraphTraversal;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

class AnalyzePrototypeProperties
implements CompilerPass {
    private final SymbolType PROPERTY = SymbolType.PROPERTY;
    private final SymbolType VAR = SymbolType.VAR;
    private final AbstractCompiler compiler;
    private final boolean canModifyExterns;
    private final boolean anchorUnusedVars;
    private final JSModuleGraph moduleGraph;
    private final JSModule firstModule;
    private static final Set<String> IMPLICITLY_USED_PROPERTIES = ImmutableSet.of((Object)"length", (Object)"toString", (Object)"valueOf");
    private final LinkedDirectedGraph<NameInfo, JSModule> symbolGraph = LinkedDirectedGraph.createWithoutAnnotations();
    private final NameInfo globalNode = new NameInfo("[global]");
    private final NameInfo externNode = new NameInfo("[extern]");
    private final NameInfo anonymousNode = new NameInfo("[anonymous]");
    private final Map<String, NameInfo> propertyNameInfo = Maps.newHashMap();
    private final Map<String, NameInfo> varNameInfo = Maps.newHashMap();

    AnalyzePrototypeProperties(AbstractCompiler abstractCompiler, JSModuleGraph jSModuleGraph, boolean bl, boolean bl2) {
        this.compiler = abstractCompiler;
        this.moduleGraph = jSModuleGraph;
        this.canModifyExterns = bl;
        this.anchorUnusedVars = bl2;
        this.firstModule = jSModuleGraph != null ? jSModuleGraph.getRootModule() : null;
        this.globalNode.markReference(null);
        this.externNode.markReference(null);
        this.symbolGraph.createNode(this.globalNode);
        this.symbolGraph.createNode(this.externNode);
        for (String string : IMPLICITLY_USED_PROPERTIES) {
            NameInfo nameInfo = this.getNameInfoForName(string, this.PROPERTY);
            if (jSModuleGraph == null) {
                this.symbolGraph.connect(this.externNode, null, nameInfo);
                continue;
            }
            for (JSModule jSModule : jSModuleGraph.getAllModules()) {
                this.symbolGraph.connect(this.externNode, jSModule, nameInfo);
            }
        }
    }

    @Override
    public void process(Node node, Node node2) {
        if (!this.canModifyExterns) {
            NodeTraversal.traverse(this.compiler, node, new ProcessExternProperties());
        }
        NodeTraversal.traverse(this.compiler, node2, new ProcessProperties());
        FixedPointGraphTraversal<NameInfo, JSModule> fixedPointGraphTraversal = FixedPointGraphTraversal.newTraversal(new PropagateReferences());
        fixedPointGraphTraversal.computeFixedPoint(this.symbolGraph, Sets.newHashSet((Object[])new NameInfo[]{this.externNode, this.globalNode}));
    }

    public Collection<NameInfo> getAllNameInfo() {
        ArrayList arrayList = Lists.newArrayList(this.propertyNameInfo.values());
        arrayList.addAll(this.varNameInfo.values());
        return arrayList;
    }

    private NameInfo getNameInfoForName(String string, SymbolType symbolType) {
        Map<String, NameInfo> map;
        Map<String, NameInfo> map2 = map = symbolType == this.PROPERTY ? this.propertyNameInfo : this.varNameInfo;
        if (map.containsKey(string)) {
            return map.get(string);
        }
        NameInfo nameInfo = new NameInfo(string);
        map.put(string, nameInfo);
        this.symbolGraph.createNode(nameInfo);
        return nameInfo;
    }

    class NameInfo {
        final String name;
        private boolean referenced = false;
        private final Deque<Symbol> declarations = new ArrayDeque<Symbol>();
        private JSModule deepestCommonModuleRef = null;
        private boolean readClosureVariables = false;

        NameInfo(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }

        boolean isReferenced() {
            return this.referenced;
        }

        boolean readsClosureVariables() {
            return this.readClosureVariables;
        }

        boolean markReference(JSModule jSModule) {
            boolean bl = false;
            if (!this.referenced) {
                this.referenced = true;
                bl = true;
            }
            if (AnalyzePrototypeProperties.this.moduleGraph != null) {
                JSModule jSModule2 = this.deepestCommonModuleRef;
                this.deepestCommonModuleRef = this.deepestCommonModuleRef == null ? jSModule : AnalyzePrototypeProperties.this.moduleGraph.getDeepestCommonDependencyInclusive(this.deepestCommonModuleRef, jSModule);
                if (jSModule2 != this.deepestCommonModuleRef) {
                    bl = true;
                }
            }
            return bl;
        }

        JSModule getDeepestCommonModuleRef() {
            return this.deepestCommonModuleRef;
        }

        Deque<Symbol> getDeclarations() {
            return this.declarations;
        }
    }

    private class NameContext {
        final NameInfo name;
        Scope scope;

        NameContext(NameInfo nameInfo) {
            this.name = nameInfo;
        }
    }

    static class LiteralProperty
    implements Property {
        private final Node key;
        private final Node value;
        private final Node map;
        private final Node assign;
        private final JSModule module;

        LiteralProperty(Node node, Node node2, Node node3, Node node4, JSModule jSModule) {
            this.key = node;
            this.value = node2;
            this.map = node3;
            this.assign = node4;
            this.module = jSModule;
        }

        @Override
        public void remove() {
            this.map.removeChild(this.key);
        }

        @Override
        public Node getPrototype() {
            return this.assign.getFirstChild();
        }

        @Override
        public Node getValue() {
            return this.value;
        }

        @Override
        public Node getValueParent() {
            return this.map;
        }

        @Override
        public JSModule getModule() {
            return this.module;
        }
    }

    static class AssignmentProperty
    implements Property {
        private final Node node;
        private final JSModule module;

        AssignmentProperty(Node node, Node node2, JSModule jSModule) {
            this.node = node;
            this.module = jSModule;
        }

        @Override
        public void remove() {
            NodeUtil.removeChild(this.node.getParent(), this.node);
        }

        @Override
        public Node getPrototype() {
            return this.getValueParent().getFirstChild().getFirstChild();
        }

        @Override
        public Node getValue() {
            return this.getValueParent().getLastChild();
        }

        @Override
        public Node getValueParent() {
            return this.node.getFirstChild();
        }

        @Override
        public JSModule getModule() {
            return this.module;
        }
    }

    static interface Property
    extends Symbol {
        public Node getPrototype();

        public Node getValue();

        public Node getValueParent();
    }

    class GlobalFunction
    implements Symbol {
        private final Node nameNode;
        private final JSModule module;

        GlobalFunction(Node node, Node node2, Node node3, JSModule jSModule) {
            Preconditions.checkState((node2.getType() == 118 || NodeUtil.isFunctionDeclaration(node2) ? 1 : 0) != 0);
            this.nameNode = node;
            this.module = jSModule;
        }

        @Override
        public void remove() {
            Node node = this.nameNode.getParent();
            if (node.getType() == 105 || node.hasOneChild()) {
                NodeUtil.removeChild(node.getParent(), node);
            } else {
                Preconditions.checkState((node.getType() == 118 ? 1 : 0) != 0);
                node.removeChild(this.nameNode);
            }
        }

        @Override
        public JSModule getModule() {
            return this.module;
        }

        public Node getFunctionNode() {
            Node node = this.nameNode.getParent();
            if (NodeUtil.isFunction(node)) {
                return node;
            }
            return this.nameNode.getChildAtIndex(1);
        }
    }

    private static enum SymbolType {
        PROPERTY,
        VAR;

    }

    static interface Symbol {
        public void remove();

        public JSModule getModule();
    }

    private class PropagateReferences
    implements FixedPointGraphTraversal.EdgeCallback<NameInfo, JSModule> {
        private PropagateReferences() {
        }

        @Override
        public boolean traverseEdge(NameInfo nameInfo, JSModule jSModule, NameInfo nameInfo2) {
            if (nameInfo.isReferenced()) {
                JSModule jSModule2 = nameInfo.getDeepestCommonModuleRef();
                if (jSModule2 != null && AnalyzePrototypeProperties.this.moduleGraph.dependsOn(jSModule2, jSModule)) {
                    return nameInfo2.markReference(jSModule2);
                }
                return nameInfo2.markReference(jSModule);
            }
            return false;
        }
    }

    private class ProcessExternProperties
    extends NodeTraversal.AbstractPostOrderCallback {
        private ProcessExternProperties() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() == 33) {
                AnalyzePrototypeProperties.this.symbolGraph.connect(AnalyzePrototypeProperties.this.externNode, AnalyzePrototypeProperties.this.firstModule, AnalyzePrototypeProperties.this.getNameInfoForName(node.getLastChild().getString(), AnalyzePrototypeProperties.this.PROPERTY));
            }
        }
    }

    private class ProcessProperties
    implements NodeTraversal.ScopedCallback {
        private Stack<NameContext> symbolStack = new Stack();

        private ProcessProperties() {
            this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.globalNode));
        }

        @Override
        public void enterScope(NodeTraversal nodeTraversal) {
            this.symbolStack.peek().scope = nodeTraversal.getScope();
        }

        @Override
        public void exitScope(NodeTraversal nodeTraversal) {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (this.isPrototypePropertyAssign(node)) {
                this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.getNameInfoForName(node.getFirstChild().getLastChild().getString(), AnalyzePrototypeProperties.this.PROPERTY)));
            } else if (this.isGlobalFunctionDeclaration(nodeTraversal, node)) {
                String string = node2.getType() == 38 ? node2.getString() : node.getFirstChild().getString();
                this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.getNameInfoForName(string, AnalyzePrototypeProperties.this.VAR)));
            } else if (NodeUtil.isFunction(node)) {
                this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.anonymousNode));
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() == 33) {
                String string = node.getFirstChild().getNext().getString();
                if (string.equals("prototype")) {
                    this.processPrototypeParent(nodeTraversal, node2);
                } else if (AnalyzePrototypeProperties.this.compiler.getCodingConvention().isExported(string)) {
                    this.addGlobalUseOfSymbol(string, nodeTraversal.getModule(), AnalyzePrototypeProperties.this.PROPERTY);
                } else {
                    this.addSymbolUse(string, nodeTraversal.getModule(), AnalyzePrototypeProperties.this.PROPERTY);
                }
            } else if (!(node.getType() != 64 || node2.getType() == 86 && node2.getFirstChild().getType() == 33 && node2.getFirstChild().getLastChild().getString().equals("prototype"))) {
                for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                    if (node3.getType() != 40 || node3.isQuotedString()) continue;
                    this.addSymbolUse(node3.getString(), nodeTraversal.getModule(), AnalyzePrototypeProperties.this.PROPERTY);
                }
            } else if (node.getType() == 38) {
                String string = node.getString();
                Scope.Var var = nodeTraversal.getScope().getVar(string);
                if (var != null) {
                    if (var.isGlobal()) {
                        if (var.getInitialValue() != null && var.getInitialValue().getType() == 105) {
                            if (nodeTraversal.inGlobalScope()) {
                                if (!this.processGlobalFunctionDeclaration(nodeTraversal, node, node2, node2.getParent())) {
                                    this.addGlobalUseOfSymbol(string, nodeTraversal.getModule(), AnalyzePrototypeProperties.this.VAR);
                                }
                            } else {
                                this.addSymbolUse(string, nodeTraversal.getModule(), AnalyzePrototypeProperties.this.VAR);
                            }
                        }
                    } else if (var.getScope() != nodeTraversal.getScope()) {
                        for (int i = this.symbolStack.size() - 1; i >= 0; --i) {
                            NameContext nameContext = (NameContext)this.symbolStack.get(i);
                            nameContext.name.readClosureVariables = true;
                            if (nameContext.scope != var.getScope()) {
                                continue;
                            }
                            break;
                        }
                    }
                }
            }
            if (this.isPrototypePropertyAssign(node) || this.isGlobalFunctionDeclaration(nodeTraversal, node) || NodeUtil.isFunction(node)) {
                this.symbolStack.pop();
            }
        }

        private void addSymbolUse(String string, JSModule jSModule, SymbolType symbolType) {
            NameInfo nameInfo = AnalyzePrototypeProperties.this.getNameInfoForName(string, symbolType);
            Object object = null;
            for (int i = this.symbolStack.size() - 1; i >= 0 && (object = ((NameContext)this.symbolStack.get((int)i)).name) == AnalyzePrototypeProperties.this.anonymousNode; --i) {
            }
            if (!object.equals(nameInfo)) {
                AnalyzePrototypeProperties.this.symbolGraph.connect(object, jSModule, nameInfo);
            }
        }

        private boolean isGlobalFunctionDeclaration(NodeTraversal nodeTraversal, Node node) {
            return nodeTraversal.inGlobalScope() && (NodeUtil.isFunctionDeclaration(node) || node.getType() == 105 && node.getParent().getType() == 38);
        }

        private boolean isPrototypePropertyAssign(Node node) {
            Node node2 = node.getFirstChild();
            if (node2 != null && NodeUtil.isLhs(node2, node) && node2.getType() == 33) {
                Node node3;
                boolean bl;
                boolean bl2 = bl = node2.getFirstChild().getType() == 33;
                if (bl && (node3 = node2.getFirstChild().getFirstChild().getNext()).getType() == 40 && node3.getString().equals("prototype")) {
                    return true;
                }
            }
            return false;
        }

        private boolean processGlobalFunctionDeclaration(NodeTraversal nodeTraversal, Node node, Node node2, Node node3) {
            Node node4 = node.getFirstChild();
            if (this.isGlobalFunctionDeclaration(nodeTraversal, node2) || node4 != null && this.isGlobalFunctionDeclaration(nodeTraversal, node4)) {
                String string = node.getString();
                AnalyzePrototypeProperties.this.getNameInfoForName(string, AnalyzePrototypeProperties.this.VAR).getDeclarations().add(new GlobalFunction(node, node2, node3, nodeTraversal.getModule()));
                if (AnalyzePrototypeProperties.this.compiler.getCodingConvention().isExported(string) || AnalyzePrototypeProperties.this.anchorUnusedVars) {
                    this.addGlobalUseOfSymbol(string, nodeTraversal.getModule(), AnalyzePrototypeProperties.this.VAR);
                }
                return true;
            }
            return false;
        }

        private void processPrototypeParent(NodeTraversal nodeTraversal, Node node) {
            switch (node.getType()) {
                case 33: {
                    Node node2 = node.getFirstChild().getNext();
                    Node node3 = node.getParent();
                    Node node4 = node3.getParent();
                    if (node2.getType() != 40 || !NodeUtil.isExprAssign(node4) || !NodeUtil.isLhs(node, node3)) break;
                    String string = node2.getString();
                    AssignmentProperty assignmentProperty = new AssignmentProperty(node4, node4.getParent(), nodeTraversal.getModule());
                    AnalyzePrototypeProperties.this.getNameInfoForName(string, AnalyzePrototypeProperties.this.PROPERTY).getDeclarations().add(assignmentProperty);
                    break;
                }
                case 86: {
                    Node node5 = node.getFirstChild().getNext();
                    if (node5.getType() != 64) break;
                    for (Node node6 = node5.getFirstChild(); node6 != null; node6 = node6.getNext()) {
                        if (node6.getType() != 40) continue;
                        String string = node6.getString();
                        LiteralProperty literalProperty = new LiteralProperty(node6, node6.getFirstChild(), node5, node, nodeTraversal.getModule());
                        AnalyzePrototypeProperties.this.getNameInfoForName(string, AnalyzePrototypeProperties.this.PROPERTY).getDeclarations().add(literalProperty);
                    }
                    break;
                }
            }
        }

        private void addGlobalUseOfSymbol(String string, JSModule jSModule, SymbolType symbolType) {
            AnalyzePrototypeProperties.this.symbolGraph.connect(AnalyzePrototypeProperties.this.globalNode, jSModule, AnalyzePrototypeProperties.this.getNameInfoForName(string, symbolType));
        }
    }
}

