/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NameReferenceGraph;
import com.google.javascript.jscomp.NameReferenceGraphConstruction;
import com.google.javascript.jscomp.graph.Annotation;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.FixedPointGraphTraversal;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.rhino.Node;

class AnalyzeNameReferences
implements CompilerPass {
    private NameReferenceGraph graph;
    private final JSModuleGraph moduleGraph;
    private final AbstractCompiler compiler;

    AnalyzeNameReferences(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
        this.moduleGraph = abstractCompiler.getModuleGraph();
    }

    @Override
    public void process(Node node, Node node2) {
        NameReferenceGraphConstruction nameReferenceGraphConstruction = new NameReferenceGraphConstruction(this.compiler);
        nameReferenceGraphConstruction.process(node, node2);
        this.graph = nameReferenceGraphConstruction.getNameReferenceGraph();
        FixedPointGraphTraversal<NameReferenceGraph.Name, NameReferenceGraph.Reference> fixedPointGraphTraversal = FixedPointGraphTraversal.newTraversal(new PropagateReferences());
        this.getInfo(this.graph.MAIN).markReference(null);
        fixedPointGraphTraversal.computeFixedPoint((DiGraph<NameReferenceGraph.Name, NameReferenceGraph.Reference>)this.graph, Sets.newHashSet((Object[])new NameReferenceGraph.Name[]{this.graph.MAIN}));
    }

    public NameReferenceGraph getGraph() {
        return this.graph;
    }

    private NameInfo getInfo(NameReferenceGraph.Name name) {
        GraphNode graphNode = this.graph.getNode(name);
        NameInfo nameInfo = (NameInfo)graphNode.getAnnotation();
        if (nameInfo == null) {
            nameInfo = new NameInfo();
            graphNode.setAnnotation(nameInfo);
        }
        return nameInfo;
    }

    final class NameInfo
    implements Annotation {
        private boolean referenced = false;
        private JSModule deepestCommonModuleRef = null;

        NameInfo() {
        }

        boolean isReferenced() {
            return this.referenced;
        }

        JSModule getDeepestCommonModuleRef() {
            return this.deepestCommonModuleRef;
        }

        boolean markReference(JSModule jSModule) {
            boolean bl = false;
            if (!this.referenced) {
                this.referenced = true;
                bl = true;
            }
            if (AnalyzeNameReferences.this.moduleGraph != null) {
                JSModule jSModule2 = this.deepestCommonModuleRef;
                this.deepestCommonModuleRef = this.deepestCommonModuleRef == null ? jSModule : AnalyzeNameReferences.this.moduleGraph.getDeepestCommonDependencyInclusive(this.deepestCommonModuleRef, jSModule);
                if (jSModule2 != this.deepestCommonModuleRef) {
                    bl = true;
                }
            }
            return bl;
        }
    }

    private class PropagateReferences
    implements FixedPointGraphTraversal.EdgeCallback<NameReferenceGraph.Name, NameReferenceGraph.Reference> {
        private PropagateReferences() {
        }

        @Override
        public boolean traverseEdge(NameReferenceGraph.Name name, NameReferenceGraph.Reference reference, NameReferenceGraph.Name name2) {
            NameInfo nameInfo = AnalyzeNameReferences.this.getInfo(name);
            NameInfo nameInfo2 = AnalyzeNameReferences.this.getInfo(name2);
            if (nameInfo.isReferenced()) {
                JSModule jSModule = nameInfo.getDeepestCommonModuleRef();
                if (jSModule != null && AnalyzeNameReferences.this.moduleGraph.dependsOn(jSModule, reference.getModule())) {
                    return nameInfo2.markReference(jSModule);
                }
                return nameInfo2.markReference(reference.getModule());
            }
            return false;
        }
    }
}

