/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DefaultCodingConvention;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.DotFormatter;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.JSSourceFile;
import com.google.javascript.jscomp.PhaseOptimizer;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.Strings;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TokenStream;
import com.google.protobuf.CodedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

abstract class AbstractCommandLineRunner<A extends Compiler, B extends CompilerOptions> {
    private final CommandLineConfig config;
    private Appendable out;
    private final PrintStream err;
    private A compiler;
    private Charset inputCharset;
    private String outputCharset;
    private boolean testMode = false;
    private Supplier<List<JSSourceFile>> externsSupplierForTesting = null;
    private Supplier<List<JSSourceFile>> inputsSupplierForTesting = null;
    private Supplier<List<JSModule>> modulesSupplierForTesting = null;
    private Function<Integer, Boolean> exitCodeReceiverForTesting = null;
    private static final int NUM_RUNS_TO_DETERMINE_OPTIMAL_ORDER = 100;
    private final RunTimeStats runTimeStats = new RunTimeStats();

    AbstractCommandLineRunner() {
        this(System.out, System.err);
    }

    AbstractCommandLineRunner(PrintStream printStream, PrintStream printStream2) {
        this.config = new CommandLineConfig();
        this.out = printStream;
        this.err = printStream2;
    }

    @VisibleForTesting
    void enableTestMode(Supplier<List<JSSourceFile>> supplier, Supplier<List<JSSourceFile>> supplier2, Supplier<List<JSModule>> supplier3, Function<Integer, Boolean> function) {
        Preconditions.checkArgument((boolean)(supplier2 == null ^ supplier3 == null));
        this.testMode = true;
        this.externsSupplierForTesting = supplier;
        this.inputsSupplierForTesting = supplier2;
        this.modulesSupplierForTesting = supplier3;
        this.exitCodeReceiverForTesting = function;
    }

    protected boolean isInTestMode() {
        return this.testMode;
    }

    protected CommandLineConfig getCommandLineConfig() {
        return this.config;
    }

    protected abstract A createCompiler();

    protected abstract B createOptions();

    protected DiagnosticGroups getDiagnosticGroups() {
        if (this.compiler == null) {
            return new DiagnosticGroups();
        }
        return ((Compiler)this.compiler).getDiagnosticGroups();
    }

    @Deprecated
    protected void initOptionsFromFlags(CompilerOptions compilerOptions) {
    }

    protected final void setRunOptions(CompilerOptions compilerOptions) throws FlagUsageException, IOException {
        DiagnosticGroups diagnosticGroups = this.getDiagnosticGroups();
        diagnosticGroups.setWarningLevels(compilerOptions, this.config.jscompError, CheckLevel.ERROR);
        diagnosticGroups.setWarningLevels(compilerOptions, this.config.jscompWarning, CheckLevel.WARNING);
        diagnosticGroups.setWarningLevels(compilerOptions, this.config.jscompOff, CheckLevel.OFF);
        AbstractCommandLineRunner.createDefineReplacements(this.config.define, compilerOptions);
        compilerOptions.manageClosureDependencies = this.config.manageClosureDependencies;
        if (this.config.closureEntryPoints.size() > 0) {
            compilerOptions.setManageClosureDependencies(this.config.closureEntryPoints);
        }
        compilerOptions.devMode = this.config.jscompDevMode;
        compilerOptions.setCodingConvention(this.config.codingConvention);
        compilerOptions.setSummaryDetailLevel(this.config.summaryDetailLevel);
        this.outputCharset = compilerOptions.outputCharset = this.getOutputCharset();
        this.inputCharset = this.getInputCharset();
        if (this.config.jsOutputFile.length() > 0) {
            compilerOptions.jsOutputFile = this.config.jsOutputFile;
        }
        if (this.config.createSourceMap.length() > 0) {
            compilerOptions.sourceMapOutputPath = this.config.createSourceMap;
        }
        compilerOptions.sourceMapDetailLevel = this.config.sourceMapDetailLevel;
        compilerOptions.sourceMapFormat = this.config.sourceMapFormat;
        if (!this.config.variableMapInputFile.equals("")) {
            compilerOptions.inputVariableMapSerialized = VariableMap.load(this.config.variableMapInputFile).toBytes();
        }
        if (!this.config.propertyMapInputFile.equals("")) {
            compilerOptions.inputPropertyMapSerialized = VariableMap.load(this.config.propertyMapInputFile).toBytes();
        }
    }

    protected final A getCompiler() {
        return this.compiler;
    }

    public final void run() {
        int n = 0;
        int n2 = 1;
        if (this.config.computePhaseOrdering) {
            n2 = 100;
            PhaseOptimizer.randomizeLoops();
        }
        try {
            for (int i = 0; i < n2 && n == 0; ++i) {
                this.runTimeStats.recordStartRun();
                n = this.doRun();
                this.runTimeStats.recordEndRun();
            }
        }
        catch (FlagUsageException flagUsageException) {
            System.err.println(flagUsageException.getMessage());
            n = -1;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            n = -2;
        }
        if (this.config.computePhaseOrdering) {
            this.runTimeStats.outputBestPhaseOrdering();
        }
        if (this.testMode) {
            this.exitCodeReceiverForTesting.apply((Object)n);
        } else {
            System.exit(n);
        }
    }

    protected PrintStream getErrorPrintStream() {
        return this.err;
    }

    private List<JSSourceFile> createInputs(List<String> list, boolean bl) throws FlagUsageException, IOException {
        ArrayList<JSSourceFile> arrayList = new ArrayList<JSSourceFile>(list.size());
        boolean bl2 = false;
        for (String string : list) {
            if (!"-".equals(string)) {
                JSSourceFile jSSourceFile = JSSourceFile.fromFile(string, this.inputCharset);
                arrayList.add(jSSourceFile);
                continue;
            }
            if (!bl) {
                throw new FlagUsageException("Can't specify stdin.");
            }
            if (bl2) {
                throw new FlagUsageException("Can't specify stdin twice.");
            }
            arrayList.add(JSSourceFile.fromInputStream("stdin", System.in));
            bl2 = true;
        }
        return arrayList;
    }

    private List<JSSourceFile> createSourceInputs(List<String> list) throws FlagUsageException, IOException {
        if (this.isInTestMode()) {
            return (List)this.inputsSupplierForTesting.get();
        }
        if (list.isEmpty()) {
            list = Collections.singletonList("-");
        }
        try {
            return this.createInputs(list, true);
        }
        catch (FlagUsageException flagUsageException) {
            throw new FlagUsageException("Bad --js flag. " + flagUsageException.getMessage());
        }
    }

    private List<JSSourceFile> createExternInputs(List<String> list) throws FlagUsageException, IOException {
        if (list.isEmpty()) {
            return ImmutableList.of((Object)JSSourceFile.fromCode("/dev/null", ""));
        }
        try {
            return this.createInputs(list, false);
        }
        catch (FlagUsageException flagUsageException) {
            throw new FlagUsageException("Bad --externs flag. " + flagUsageException.getMessage());
        }
    }

    List<JSModule> createJsModules(List<String> list, List<String> list2) throws FlagUsageException, IOException {
        if (this.isInTestMode()) {
            return (List)this.modulesSupplierForTesting.get();
        }
        Preconditions.checkState((list != null ? 1 : 0) != 0);
        Preconditions.checkState((!list.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((list2 != null ? 1 : 0) != 0);
        int n = list2.size();
        int n2 = 0;
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        for (String string : list) {
            String[] stringArray;
            String[] stringArray2 = string.split(":");
            if (stringArray2.length < 2 || stringArray2.length > 4) {
                throw new FlagUsageException("Expected 2-4 colon-delimited parts in module spec: " + string);
            }
            String string2 = stringArray2[0];
            if (!TokenStream.isJSIdentifier(string2)) {
                throw new FlagUsageException("Invalid module name: '" + string2 + "'");
            }
            if (linkedHashMap.containsKey(string2)) {
                throw new FlagUsageException("Duplicate module name: " + string2);
            }
            JSModule jSModule = new JSModule(string2);
            int n3 = -1;
            try {
                n3 = Integer.parseInt(stringArray2[1]);
            }
            catch (NumberFormatException numberFormatException) {
                n3 = -1;
            }
            if (n3 < 0) {
                throw new FlagUsageException("Invalid js file count '" + stringArray2[1] + "' for module: " + string2);
            }
            if (n2 + n3 > n) {
                throw new FlagUsageException("Not enough js files specified. Expected " + (n2 + n3 - n) + " more in module:" + string2);
            }
            List<String> list3 = list2.subList(n2, n2 + n3);
            Object object = this.createInputs(list3, false).iterator();
            while (object.hasNext()) {
                stringArray = object.next();
                jSModule.add((JSSourceFile)stringArray);
            }
            n2 += n3;
            if (stringArray2.length > 2 && ((String)(object = stringArray2[2])).length() > 0) {
                for (String string3 : stringArray = ((String)object).split(",")) {
                    JSModule jSModule2 = (JSModule)linkedHashMap.get(string3);
                    if (jSModule2 == null) {
                        throw new FlagUsageException("Module '" + string2 + "' depends on unknown module '" + string3 + "'. Be sure to list modules in dependency order.");
                    }
                    jSModule.addDependency(jSModule2);
                }
            }
            linkedHashMap.put(string2, jSModule);
        }
        if (n2 < n) {
            throw new FlagUsageException("Too many js files specified. Expected " + n2 + " but found " + n);
        }
        return Lists.newArrayList(linkedHashMap.values());
    }

    static Map<String, String> parseModuleWrappers(List<String> list, List<JSModule> list2) throws FlagUsageException {
        Preconditions.checkState((list != null ? 1 : 0) != 0);
        HashMap hashMap = Maps.newHashMapWithExpectedSize((int)list2.size());
        for (JSModule object : list2) {
            hashMap.put(object.getName(), "");
        }
        for (String string : list) {
            int n = string.indexOf(58);
            if (n == -1) {
                throw new FlagUsageException("Expected module wrapper to have <name>:<wrapper> format: " + string);
            }
            String string2 = string.substring(0, n);
            if (!hashMap.containsKey(string2)) {
                throw new FlagUsageException("Unknown module: '" + string2 + "'");
            }
            String string3 = string.substring(n + 1);
            if (!string3.contains("%s")) {
                throw new FlagUsageException("No %s placeholder in module wrapper: '" + string3 + "'");
            }
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    static void writeOutput(Appendable appendable, Compiler compiler, String string, String string2, String string3) throws IOException {
        int n = string2.indexOf(string3);
        if (n != -1) {
            String string4 = "";
            if (n > 0) {
                string4 = string2.substring(0, n);
                appendable.append(string4);
            }
            appendable.append(string);
            int n2 = n + string3.length();
            if (n2 != string2.length()) {
                appendable.append(string2.substring(n2));
            }
            appendable.append('\n');
            if (compiler != null && compiler.getSourceMap() != null) {
                compiler.getSourceMap().setWrapperPrefix(string4);
            }
        } else {
            appendable.append(string);
            appendable.append('\n');
        }
    }

    private static void maybeCreateDirsForPath(String string) {
        if (string.length() > 0) {
            String string2;
            String string3 = string2 = string.charAt(string.length() - 1) == File.separatorChar ? string.substring(0, string.length() - 1) : new File(string).getParent();
            if (string2 != null) {
                new File(string2).mkdirs();
            }
        }
    }

    protected int doRun() throws FlagUsageException, IOException {
        Result result;
        boolean bl;
        Compiler.setLoggingLevel(Level.parse(this.config.loggingLevel));
        List<JSSourceFile> list = this.createExterns();
        this.compiler = this.createCompiler();
        B b = this.createOptions();
        List<JSModule> list2 = null;
        this.setRunOptions((CompilerOptions)b);
        boolean bl2 = bl = !((CompilerOptions)b).jsOutputFile.isEmpty();
        if (bl) {
            this.out = this.fileNameToOutputWriter(((CompilerOptions)b).jsOutputFile);
        } else if (this.out instanceof OutputStream) {
            this.out = this.streamToOutputWriter((OutputStream)((Object)this.out));
        }
        List list3 = this.config.js;
        List list4 = this.config.module;
        if (!list4.isEmpty()) {
            list2 = this.createJsModules(list4, list3);
            result = ((Compiler)this.compiler).compileModules(list, list2, (CompilerOptions)b);
        } else {
            List<JSSourceFile> list5 = this.createSourceInputs(list3);
            result = ((Compiler)this.compiler).compile(list, list5, (CompilerOptions)b);
        }
        int n = this.processResults(result, list2, b);
        if (this.out instanceof Closeable) {
            ((Closeable)((Object)this.out)).close();
        }
        return n;
    }

    int processResults(Result result, List<JSModule> list, B b) throws FlagUsageException, IOException {
        if (this.config.computePhaseOrdering) {
            return 0;
        }
        if (this.config.printPassGraph) {
            if (((Compiler)this.compiler).getRoot() == null) {
                return 1;
            }
            this.out.append(DotFormatter.toDot(((Compiler)this.compiler).getPassConfig().getPassGraph()));
            this.out.append('\n');
            return 0;
        }
        if (this.config.printAst) {
            if (((Compiler)this.compiler).getRoot() == null) {
                return 1;
            }
            ControlFlowGraph<Node> controlFlowGraph = ((Compiler)this.compiler).computeCFG();
            DotFormatter.appendDot(((Compiler)this.compiler).getRoot().getLastChild(), controlFlowGraph, this.out);
            this.out.append('\n');
            return 0;
        }
        if (this.config.printTree) {
            if (((Compiler)this.compiler).getRoot() == null) {
                this.out.append("Code contains errors; no tree was generated.\n");
                return 1;
            }
            ((Compiler)this.compiler).getRoot().appendStringTree(this.out);
            this.out.append("\n");
            return 0;
        }
        if (result.success) {
            Object object;
            if (list == null) {
                AbstractCommandLineRunner.writeOutput(this.out, this.compiler, ((Compiler)this.compiler).toSource(), this.config.outputWrapper, this.config.outputWrapperMarker);
                this.outputSourceMap(b);
            } else {
                object = this.config.moduleOutputPathPrefix;
                AbstractCommandLineRunner.maybeCreateDirsForPath((String)object);
                Map<String, String> map = AbstractCommandLineRunner.parseModuleWrappers(this.config.moduleWrapper, list);
                Writer writer = null;
                if (!this.shouldGenerateMapPerModule(b)) {
                    writer = this.fileNameToOutputWriter(this.expandSourceMapPath(b, null));
                }
                for (JSModule jSModule : list) {
                    if (this.shouldGenerateMapPerModule(b)) {
                        writer = this.fileNameToOutputWriter(this.expandSourceMapPath(b, jSModule));
                    }
                    Writer writer2 = this.fileNameToOutputWriter((String)object + jSModule.getName() + ".js");
                    if (((CompilerOptions)b).sourceMapOutputPath != null) {
                        ((Compiler)this.compiler).getSourceMap().reset();
                    }
                    AbstractCommandLineRunner.writeOutput(writer2, this.compiler, ((Compiler)this.compiler).toSource(jSModule), map.get(jSModule.getName()), "%s");
                    if (((CompilerOptions)b).sourceMapOutputPath != null) {
                        ((Compiler)this.compiler).getSourceMap().appendTo(writer, jSModule.getName());
                    }
                    writer2.close();
                    if (!this.shouldGenerateMapPerModule(b) || writer == null) continue;
                    writer.close();
                    writer = null;
                }
                if (writer != null) {
                    writer.close();
                }
            }
            if (((CompilerOptions)b).externExportsPath != null) {
                object = this.openExternExportsStream(b, ((CompilerOptions)b).jsOutputFile);
                ((Writer)object).append(result.externExport);
                ((Writer)object).close();
            }
            this.outputNameMaps(b);
            this.outputManifest();
        }
        return Math.min(result.errors.length, 127);
    }

    private Charset getInputCharset() throws FlagUsageException {
        if (!this.config.charset.isEmpty()) {
            if (!Charset.isSupported(this.config.charset)) {
                throw new FlagUsageException(this.config.charset + " is not a valid charset name.");
            }
            return Charset.forName(this.config.charset);
        }
        return Charsets.UTF_8;
    }

    private String getOutputCharset() throws FlagUsageException {
        if (!this.config.charset.isEmpty()) {
            if (!Charset.isSupported(this.config.charset)) {
                throw new FlagUsageException(this.config.charset + " is not a valid charset name.");
            }
            return this.config.charset;
        }
        return "US-ASCII";
    }

    protected List<JSSourceFile> createExterns() throws FlagUsageException, IOException {
        return this.isInTestMode() ? (List<JSSourceFile>)this.externsSupplierForTesting.get() : this.createExternInputs(this.config.externs);
    }

    private boolean shouldGenerateMapPerModule(B b) {
        return ((CompilerOptions)b).sourceMapOutputPath != null && ((CompilerOptions)b).sourceMapOutputPath.contains("%outname%");
    }

    private Writer openExternExportsStream(B b, String string) throws IOException {
        if (((CompilerOptions)b).externExportsPath == null) {
            return null;
        }
        String string2 = ((CompilerOptions)b).externExportsPath;
        if (!string2.contains(File.separator)) {
            File file = new File(string);
            string2 = file.getParent() + File.separatorChar + string2;
        }
        return this.fileNameToOutputWriter(string2);
    }

    private String expandCommandLinePath(String string, JSModule jSModule) {
        String string2 = jSModule != null ? this.config.moduleOutputPathPrefix + jSModule.getName() + ".js" : (!this.config.module.isEmpty() ? this.config.moduleOutputPathPrefix : this.config.jsOutputFile);
        return string.replace("%outname%", string2);
    }

    @VisibleForTesting
    String expandSourceMapPath(B b, JSModule jSModule) {
        if (Strings.isEmpty(((CompilerOptions)b).sourceMapOutputPath)) {
            return null;
        }
        return this.expandCommandLinePath(((CompilerOptions)b).sourceMapOutputPath, jSModule);
    }

    @VisibleForTesting
    String expandManifest(JSModule jSModule) {
        if (Strings.isEmpty(this.config.outputManifest)) {
            return null;
        }
        return this.expandCommandLinePath(this.config.outputManifest, jSModule);
    }

    private Writer fileNameToOutputWriter(String string) throws IOException {
        if (string == null) {
            return null;
        }
        if (this.testMode) {
            return new StringWriter();
        }
        return this.streamToOutputWriter(new FileOutputStream(string));
    }

    private Writer streamToOutputWriter(OutputStream outputStream) throws IOException {
        if (this.outputCharset == null) {
            return new BufferedWriter(new OutputStreamWriter(outputStream));
        }
        return new BufferedWriter(new OutputStreamWriter(outputStream, this.outputCharset));
    }

    private void outputSourceMap(B b) throws IOException {
        if (Strings.isEmpty(((CompilerOptions)b).sourceMapOutputPath)) {
            return;
        }
        String string = this.expandSourceMapPath(b, null);
        Writer writer = this.fileNameToOutputWriter(string);
        ((Compiler)this.compiler).getSourceMap().appendTo(writer, string);
        writer.close();
    }

    private String getMapPath(String string) {
        String string2 = "";
        if (string.equals("")) {
            string2 = !this.config.moduleOutputPathPrefix.equals("") ? this.config.moduleOutputPathPrefix : "jscompiler";
        } else {
            File file = new File(string);
            String string3 = file.getName();
            if (string3.endsWith(".js")) {
                string3 = string3.substring(0, string3.length() - 3);
            }
            string2 = file.getParent() + File.separatorChar + string3;
        }
        return string2;
    }

    private void outputNameMaps(B b) throws FlagUsageException, IOException {
        Object object;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (this.config.createNameMapFiles) {
            object = this.getMapPath(((CompilerOptions)b).jsOutputFile);
            string = (String)object + "_props_map.out";
            string2 = (String)object + "_vars_map.out";
            string3 = (String)object + "_functions_map.out";
        }
        if (!this.config.variableMapOutputFile.equals("")) {
            if (string2 != null) {
                throw new FlagUsageException("The flags variable_map_output_file and create_name_map_files cannot both be used simultaniously.");
            }
            string2 = this.config.variableMapOutputFile;
        }
        if (!this.config.propertyMapOutputFile.equals("")) {
            if (string != null) {
                throw new FlagUsageException("The flags property_map_output_file and create_name_map_files cannot both be used simultaniously.");
            }
            string = this.config.propertyMapOutputFile;
        }
        if (string2 != null && ((Compiler)this.compiler).getVariableMap() != null) {
            ((Compiler)this.compiler).getVariableMap().save(string2);
        }
        if (string != null && ((Compiler)this.compiler).getPropertyMap() != null) {
            ((Compiler)this.compiler).getPropertyMap().save(string);
        }
        if (string3 != null && ((Compiler)this.compiler).getFunctionalInformationMap() != null) {
            object = new FileOutputStream(string3);
            CodedOutputStream codedOutputStream = CodedOutputStream.newInstance((OutputStream)object);
            ((Compiler)this.compiler).getFunctionalInformationMap().writeTo(codedOutputStream);
            codedOutputStream.flush();
            ((OutputStream)object).flush();
            ((FileOutputStream)object).close();
        }
    }

    @VisibleForTesting
    static void createDefineReplacements(List<String> list, CompilerOptions compilerOptions) {
        for (String string : list) {
            String[] stringArray = string.split("=", 2);
            String string2 = stringArray[0];
            if (string2.length() > 0) {
                if (stringArray.length == 1) {
                    compilerOptions.setDefineToBooleanLiteral(string2, true);
                    continue;
                }
                String string3 = stringArray[1];
                if (string3.equals("true")) {
                    compilerOptions.setDefineToBooleanLiteral(string2, true);
                    continue;
                }
                if (string3.equals("false")) {
                    compilerOptions.setDefineToBooleanLiteral(string2, false);
                    continue;
                }
                if (string3.length() > 1 && (string3.charAt(0) == '\'' && string3.charAt(string3.length() - 1) == '\'' || string3.charAt(0) == '\"' && string3.charAt(string3.length() - 1) == '\"')) {
                    String string4 = string3.substring(1, string3.length() - 1);
                    if (string4.indexOf(string3.charAt(0)) == -1) {
                        compilerOptions.setDefineToStringLiteral(string2, string4);
                        continue;
                    }
                } else {
                    try {
                        compilerOptions.setDefineToDoubleLiteral(string2, Double.parseDouble(string3));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            throw new RuntimeException("--define flag syntax invalid: " + string);
        }
    }

    private boolean shouldGenerateManifestPerModule() {
        return !this.config.module.isEmpty() && this.config.outputManifest != null && this.config.outputManifest.contains("%outname%");
    }

    private void outputManifest() throws IOException {
        String string = this.config.outputManifest;
        if (Strings.isEmpty(string)) {
            return;
        }
        JSModuleGraph jSModuleGraph = ((Compiler)this.compiler).getModuleGraph();
        if (this.shouldGenerateManifestPerModule()) {
            Iterable<JSModule> iterable = jSModuleGraph.getAllModules();
            for (JSModule jSModule : iterable) {
                Writer writer = this.fileNameToOutputWriter(this.expandManifest(jSModule));
                this.printManifestTo(jSModule.getInputs(), writer);
                writer.close();
            }
        } else {
            Writer writer = this.fileNameToOutputWriter(this.expandManifest(null));
            if (jSModuleGraph == null) {
                this.printManifestTo(((Compiler)this.compiler).getInputsInOrder(), writer);
            } else {
                this.printModuleGraphManifestTo(jSModuleGraph, writer);
            }
            writer.close();
        }
    }

    @VisibleForTesting
    void printModuleGraphManifestTo(JSModuleGraph jSModuleGraph, Appendable appendable) throws IOException {
        Joiner joiner = Joiner.on((String)",");
        boolean bl = false;
        for (JSModule jSModule : jSModuleGraph.getAllModulesInDependencyOrder()) {
            if (bl) {
                appendable.append("\n");
            }
            String string = joiner.join(jSModule.getSortedDependencyNames());
            appendable.append(String.format("{%s%s}\n", jSModule.getName(), string.isEmpty() ? "" : ":" + string));
            this.printManifestTo(jSModule.getInputs(), appendable);
            bl = true;
        }
    }

    private void printManifestTo(Iterable<CompilerInput> iterable, Appendable appendable) throws IOException {
        ArrayList arrayList = Lists.newArrayList();
        for (CompilerInput compilerInput : iterable) {
            arrayList.add(compilerInput.getName());
        }
        String string = Joiner.on((String)"\n").join((Iterable)arrayList);
        appendable.append(string);
        appendable.append("\n");
    }

    static class CommandLineConfig {
        private boolean printTree = false;
        private boolean computePhaseOrdering = false;
        private boolean printAst = false;
        private boolean printPassGraph = false;
        private CompilerOptions.DevMode jscompDevMode = CompilerOptions.DevMode.OFF;
        private String loggingLevel = Level.WARNING.getName();
        private final List<String> externs = Lists.newArrayList();
        private final List<String> js = Lists.newArrayList();
        private String jsOutputFile = "";
        private final List<String> module = Lists.newArrayList();
        private String variableMapInputFile = "";
        private String propertyMapInputFile = "";
        private String variableMapOutputFile = "";
        private boolean createNameMapFiles = false;
        private String propertyMapOutputFile = "";
        private CodingConvention codingConvention = new DefaultCodingConvention();
        private int summaryDetailLevel = 1;
        private String outputWrapper = "";
        private String outputWrapperMarker = "";
        private final List<String> moduleWrapper = Lists.newArrayList();
        private String moduleOutputPathPrefix = "";
        private String createSourceMap = "";
        private SourceMap.DetailLevel sourceMapDetailLevel = SourceMap.DetailLevel.ALL;
        private SourceMap.Format sourceMapFormat = SourceMap.Format.LEGACY;
        private final List<String> jscompError = Lists.newArrayList();
        private final List<String> jscompWarning = Lists.newArrayList();
        private final List<String> jscompOff = Lists.newArrayList();
        private final List<String> define = Lists.newArrayList();
        private String charset = "";
        private boolean manageClosureDependencies = false;
        private List<String> closureEntryPoints = ImmutableList.of();
        private String outputManifest = "";

        CommandLineConfig() {
        }

        CommandLineConfig setPrintTree(boolean bl) {
            this.printTree = bl;
            return this;
        }

        CommandLineConfig setComputePhaseOrdering(boolean bl) {
            this.computePhaseOrdering = bl;
            return this;
        }

        CommandLineConfig setPrintAst(boolean bl) {
            this.printAst = bl;
            return this;
        }

        CommandLineConfig setPrintPassGraph(boolean bl) {
            this.printPassGraph = bl;
            return this;
        }

        CommandLineConfig setJscompDevMode(CompilerOptions.DevMode devMode) {
            this.jscompDevMode = devMode;
            return this;
        }

        CommandLineConfig setLoggingLevel(String string) {
            this.loggingLevel = string;
            return this;
        }

        CommandLineConfig setExterns(List<String> list) {
            this.externs.clear();
            this.externs.addAll(list);
            return this;
        }

        CommandLineConfig setJs(List<String> list) {
            this.js.clear();
            this.js.addAll(list);
            return this;
        }

        CommandLineConfig setJsOutputFile(String string) {
            this.jsOutputFile = string;
            return this;
        }

        CommandLineConfig setModule(List<String> list) {
            this.module.clear();
            this.module.addAll(list);
            return this;
        }

        CommandLineConfig setVariableMapInputFile(String string) {
            this.variableMapInputFile = string;
            return this;
        }

        CommandLineConfig setPropertyMapInputFile(String string) {
            this.propertyMapInputFile = string;
            return this;
        }

        CommandLineConfig setVariableMapOutputFile(String string) {
            this.variableMapOutputFile = string;
            return this;
        }

        CommandLineConfig setCreateNameMapFiles(boolean bl) {
            this.createNameMapFiles = bl;
            return this;
        }

        CommandLineConfig setPropertyMapOutputFile(String string) {
            this.propertyMapOutputFile = string;
            return this;
        }

        CommandLineConfig setCodingConvention(CodingConvention codingConvention) {
            this.codingConvention = codingConvention;
            return this;
        }

        CommandLineConfig setSummaryDetailLevel(int n) {
            this.summaryDetailLevel = n;
            return this;
        }

        CommandLineConfig setOutputWrapper(String string) {
            this.outputWrapper = string;
            return this;
        }

        CommandLineConfig setOutputWrapperMarker(String string) {
            this.outputWrapperMarker = string;
            return this;
        }

        CommandLineConfig setModuleWrapper(List<String> list) {
            this.moduleWrapper.clear();
            this.moduleWrapper.addAll(list);
            return this;
        }

        CommandLineConfig setModuleOutputPathPrefix(String string) {
            this.moduleOutputPathPrefix = string;
            return this;
        }

        CommandLineConfig setCreateSourceMap(String string) {
            this.createSourceMap = string;
            return this;
        }

        CommandLineConfig setSourceMapDetailLevel(SourceMap.DetailLevel detailLevel) {
            this.sourceMapDetailLevel = detailLevel;
            return this;
        }

        CommandLineConfig setSourceMapFormat(SourceMap.Format format) {
            this.sourceMapFormat = format;
            return this;
        }

        CommandLineConfig setJscompError(List<String> list) {
            this.jscompError.clear();
            this.jscompError.addAll(list);
            return this;
        }

        CommandLineConfig setJscompWarning(List<String> list) {
            this.jscompWarning.clear();
            this.jscompWarning.addAll(list);
            return this;
        }

        CommandLineConfig setJscompOff(List<String> list) {
            this.jscompOff.clear();
            this.jscompOff.addAll(list);
            return this;
        }

        CommandLineConfig setDefine(List<String> list) {
            this.define.clear();
            this.define.addAll(list);
            return this;
        }

        CommandLineConfig setCharset(String string) {
            this.charset = string;
            return this;
        }

        CommandLineConfig setManageClosureDependencies(boolean bl) {
            this.manageClosureDependencies = bl;
            return this;
        }

        CommandLineConfig setClosureEntryPoints(List<String> list) {
            Preconditions.checkNotNull(list);
            this.closureEntryPoints = list;
            return this;
        }

        CommandLineConfig setOutputManifest(String string) {
            this.outputManifest = string;
            return this;
        }
    }

    private class RunTimeStats {
        private long bestRunTime = Long.MAX_VALUE;
        private long worstRunTime = Long.MIN_VALUE;
        private long lastStartTime = 0L;
        private List<List<String>> loopedPassesInBestRun = null;

        private RunTimeStats() {
        }

        private void recordStartRun() {
            this.lastStartTime = System.currentTimeMillis();
            PhaseOptimizer.clearLoopsRun();
        }

        private void recordEndRun() {
            long l = System.currentTimeMillis();
            long l2 = l - this.lastStartTime;
            this.worstRunTime = Math.max(l2, this.worstRunTime);
            if (l2 < this.bestRunTime) {
                this.loopedPassesInBestRun = PhaseOptimizer.getLoopsRun();
                this.bestRunTime = l2;
            }
        }

        private void outputBestPhaseOrdering() {
            try {
                AbstractCommandLineRunner.this.out.append("Best time: " + this.bestRunTime + "\n");
                AbstractCommandLineRunner.this.out.append("Worst time: " + this.worstRunTime + "\n");
                int n = 1;
                for (List<String> list : this.loopedPassesInBestRun) {
                    AbstractCommandLineRunner.this.out.append("\nLoop " + n + ":\n" + Joiner.on((String)"\n").join(list) + "\n");
                    ++n;
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("unexpected exception", iOException);
            }
        }
    }

    protected static class FlagUsageException
    extends Exception {
        private static final long serialVersionUID = 1L;

        FlagUsageException(String string) {
            super(string);
        }
    }
}

