/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.Property;
import com.google.javascript.rhino.jstype.PropertyMap;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.Set;
import java.util.TreeSet;

public abstract class ObjectType
extends JSType
implements StaticScope<JSType> {
    private boolean visited;
    private JSDocInfo docInfo = null;
    private boolean unknown = true;

    ObjectType(JSTypeRegistry registry) {
        super(registry);
    }

    ObjectType(JSTypeRegistry registry, ImmutableList<String> templateKeys, ImmutableList<JSType> templatizedTypes) {
        super(registry, templateKeys, templatizedTypes);
    }

    @Override
    public Node getRootNode() {
        return null;
    }

    public ObjectType getParentScope() {
        return this.getImplicitPrototype();
    }

    PropertyMap getPropertyMap() {
        return PropertyMap.immutableEmptyMap();
    }

    public Property getSlot(String name) {
        return this.getPropertyMap().getSlot(name);
    }

    public Property getOwnSlot(String name) {
        return this.getPropertyMap().getOwnProperty(name);
    }

    @Override
    public JSType getTypeOfThis() {
        return null;
    }

    public JSType getParameterType() {
        return null;
    }

    public JSType getIndexType() {
        return null;
    }

    @Override
    public JSDocInfo getJSDocInfo() {
        if (this.docInfo != null) {
            return this.docInfo;
        }
        if (this.getImplicitPrototype() != null) {
            return this.getImplicitPrototype().getJSDocInfo();
        }
        return super.getJSDocInfo();
    }

    public void setJSDocInfo(JSDocInfo info) {
        this.docInfo = info;
    }

    final boolean detectImplicitPrototypeCycle() {
        ObjectType p;
        this.visited = true;
        for (p = this.getImplicitPrototype(); p != null; p = p.getImplicitPrototype()) {
            if (p.visited) {
                return true;
            }
            p.visited = true;
        }
        p = this;
        do {
            p.visited = false;
        } while ((p = p.getImplicitPrototype()) != null);
        return false;
    }

    public abstract String getReferenceName();

    public String getNormalizedReferenceName() {
        int pos;
        String name = this.getReferenceName();
        if (name != null && (pos = name.indexOf("(")) != -1) {
            return name.substring(0, pos);
        }
        return name;
    }

    @Override
    public String getDisplayName() {
        return this.getNormalizedReferenceName();
    }

    public static String createDelegateSuffix(String suffix) {
        return "(" + suffix + ")";
    }

    public boolean hasReferenceName() {
        return false;
    }

    @Override
    public TernaryValue testForEquality(JSType that) {
        TernaryValue result = super.testForEquality(that);
        if (result != null) {
            return result;
        }
        if (that.isSubtype(this.getNativeType(JSTypeNative.OBJECT_NUMBER_STRING_BOOLEAN))) {
            return TernaryValue.UNKNOWN;
        }
        return TernaryValue.FALSE;
    }

    public abstract FunctionType getConstructor();

    public abstract ObjectType getImplicitPrototype();

    public final boolean defineDeclaredProperty(String propertyName, JSType type, Node propertyNode) {
        boolean result = this.defineProperty(propertyName, type, false, propertyNode);
        this.registry.registerPropertyOnType(propertyName, this);
        return result;
    }

    public final boolean defineSynthesizedProperty(String propertyName, JSType type, Node propertyNode) {
        return this.defineProperty(propertyName, type, false, propertyNode);
    }

    public final boolean defineInferredProperty(String propertyName, JSType type, Node propertyNode) {
        Property originalSlot = this.getSlot(propertyName);
        if (this.hasProperty(propertyName)) {
            if (this.isPropertyTypeDeclared(propertyName)) {
                return true;
            }
            JSType originalType = this.getPropertyType(propertyName);
            type = originalType == null ? type : originalType.getLeastSupertype(type);
        }
        boolean result = this.defineProperty(propertyName, type, true, propertyNode);
        this.registry.registerPropertyOnType(propertyName, this);
        return result;
    }

    abstract boolean defineProperty(String var1, JSType var2, boolean var3, Node var4);

    public boolean removeProperty(String propertyName) {
        return false;
    }

    public Node getPropertyNode(String propertyName) {
        Property p = this.getSlot(propertyName);
        return p == null ? null : p.getNode();
    }

    public JSDocInfo getOwnPropertyJSDocInfo(String propertyName) {
        Property p = this.getOwnSlot(propertyName);
        return p == null ? null : p.getJSDocInfo();
    }

    public void setPropertyJSDocInfo(String propertyName, JSDocInfo info) {
    }

    @Override
    public JSType findPropertyType(String propertyName) {
        return this.hasProperty(propertyName) ? this.getPropertyType(propertyName) : null;
    }

    public JSType getPropertyType(String propertyName) {
        Property slot = this.getSlot(propertyName);
        if (slot == null) {
            if (this.isNoResolvedType() || this.isCheckedUnknownType()) {
                return this.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE);
            }
            if (this.isEmptyType()) {
                return this.getNativeType(JSTypeNative.NO_TYPE);
            }
            return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return (JSType)slot.getType();
    }

    @Override
    public boolean hasProperty(String propertyName) {
        return this.isEmptyType() || this.isUnknownType() || this.getSlot(propertyName) != null;
    }

    public boolean hasOwnProperty(String propertyName) {
        return this.getOwnSlot(propertyName) != null;
    }

    public Set<String> getOwnPropertyNames() {
        return this.getPropertyMap().getOwnPropertyNames();
    }

    public boolean isPropertyTypeInferred(String propertyName) {
        Property slot = this.getSlot(propertyName);
        return slot == null ? false : slot.isTypeInferred();
    }

    public boolean isPropertyTypeDeclared(String propertyName) {
        Property slot = this.getSlot(propertyName);
        return slot == null ? false : !slot.isTypeInferred();
    }

    final boolean hasOwnDeclaredProperty(String name) {
        return this.hasOwnProperty(name) && this.isPropertyTypeDeclared(name);
    }

    public boolean isPropertyInExterns(String propertyName) {
        Property p = this.getSlot(propertyName);
        return p == null ? false : p.isFromExterns();
    }

    public int getPropertiesCount() {
        return this.getPropertyMap().getPropertiesCount();
    }

    public Set<String> getPropertyNames() {
        TreeSet props = Sets.newTreeSet();
        this.collectPropertyNames(props);
        return props;
    }

    final void collectPropertyNames(Set<String> props) {
        this.getPropertyMap().collectPropertyNames(props);
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseObjectType(this);
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return visitor.caseObjectType(this, that);
    }

    final boolean isImplicitPrototype(ObjectType prototype) {
        for (ObjectType current = this; current != null; current = current.getImplicitPrototype()) {
            if (!current.isEquivalentTo(prototype)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        return BooleanLiteralSet.TRUE;
    }

    @Override
    public boolean isUnknownType() {
        if (this.unknown) {
            ObjectType implicitProto = this.getImplicitPrototype();
            if (implicitProto == null || implicitProto.isNativeObjectType()) {
                this.unknown = false;
                for (ObjectType interfaceType : this.getCtorExtendedInterfaces()) {
                    if (!interfaceType.isUnknownType()) continue;
                    this.unknown = true;
                    break;
                }
            } else {
                this.unknown = implicitProto.isUnknownType();
            }
        }
        return this.unknown;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    public boolean hasCachedValues() {
        return !this.unknown;
    }

    public void clearCachedValues() {
        this.unknown = true;
    }

    public boolean isNativeObjectType() {
        return false;
    }

    public static ObjectType cast(JSType type) {
        return type == null ? null : type.toObjectType();
    }

    @Override
    public final boolean isFunctionPrototypeType() {
        return this.getOwnerFunction() != null;
    }

    public FunctionType getOwnerFunction() {
        return null;
    }

    void setOwnerFunction(FunctionType type) {
    }

    public Iterable<ObjectType> getCtorImplementedInterfaces() {
        return ImmutableSet.of();
    }

    public Iterable<ObjectType> getCtorExtendedInterfaces() {
        return ImmutableSet.of();
    }
}

