/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.persist.jpa;

import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import com.google.inject.persist.UnitOfWork;
import com.google.inject.persist.jpa.JpaPersistService;
import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

class JpaLocalTxnInterceptor
implements MethodInterceptor {
    @Inject
    private JpaPersistService emProvider = null;
    @Inject
    private UnitOfWork unitOfWork = null;
    private final ThreadLocal<Boolean> didWeStartWork = new ThreadLocal();

    JpaLocalTxnInterceptor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object result;
        if (!this.emProvider.isWorking()) {
            this.emProvider.begin();
            this.didWeStartWork.set(true);
        }
        Transactional transactional = this.readTransactionMetadata(methodInvocation);
        EntityManager em = this.emProvider.get();
        if (em.getTransaction().isActive()) {
            return methodInvocation.proceed();
        }
        EntityTransaction txn = em.getTransaction();
        txn.begin();
        try {
            result = methodInvocation.proceed();
        }
        catch (Exception e) {
            if (this.rollbackIfNecessary(transactional, e, txn)) {
                txn.commit();
            }
            throw e;
        }
        finally {
            if (null != this.didWeStartWork.get() && !txn.isActive()) {
                this.didWeStartWork.remove();
                this.unitOfWork.end();
            }
        }
        try {
            txn.commit();
        }
        finally {
            if (null != this.didWeStartWork.get()) {
                this.didWeStartWork.remove();
                this.unitOfWork.end();
            }
        }
        return result;
    }

    private Transactional readTransactionMetadata(MethodInvocation methodInvocation) {
        Method method = methodInvocation.getMethod();
        Class<?> targetClass = methodInvocation.getThis().getClass();
        Transactional transactional = method.getAnnotation(Transactional.class);
        if (null == transactional) {
            transactional = targetClass.getAnnotation(Transactional.class);
        }
        if (null == transactional) {
            transactional = Internal.class.getAnnotation(Transactional.class);
        }
        return transactional;
    }

    private boolean rollbackIfNecessary(Transactional transactional, Exception e, EntityTransaction txn) {
        boolean commit = true;
        for (Class<? extends Exception> rollBackOn : transactional.rollbackOn()) {
            if (!rollBackOn.isInstance(e)) continue;
            commit = false;
            for (Class<? extends Exception> exceptOn : transactional.ignore()) {
                if (!exceptOn.isInstance(e)) continue;
                commit = true;
                break;
            }
            if (commit) break;
            txn.rollback();
            break;
        }
        return commit;
    }

    @Transactional
    private static class Internal {
        private Internal() {
        }
    }
}

