/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javah;

import com.sun.tools.javah.Mangle;
import com.sun.tools.javah.Util;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public abstract class Gen {
    protected String lineSep = System.getProperty("line.separator");
    protected ProcessingEnvironment processingEnvironment;
    protected Types types;
    protected Elements elems;
    protected Mangle mangler;
    protected Util util;
    protected Set<TypeElement> classes;
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    protected JavaFileManager fileManager;
    protected JavaFileObject outFile;
    protected boolean force = false;

    protected Gen(Util util) {
        this.util = util;
    }

    protected abstract void write(OutputStream var1, TypeElement var2) throws Util.Exit;

    protected abstract String getIncludes();

    public void setFileManager(JavaFileManager fm) {
        this.fileManager = fm;
    }

    public void setOutFile(JavaFileObject outFile) {
        this.outFile = outFile;
    }

    public void setClasses(Set<TypeElement> classes) {
        this.classes = classes;
    }

    void setProcessingEnvironment(ProcessingEnvironment pEnv) {
        this.processingEnvironment = pEnv;
        this.elems = pEnv.getElementUtils();
        this.types = pEnv.getTypeUtils();
        this.mangler = new Mangle(this.elems, this.types);
    }

    public void setForce(boolean state) {
        this.force = state;
    }

    protected PrintWriter wrapWriter(OutputStream o) throws Util.Exit {
        try {
            return new PrintWriter((Writer)new OutputStreamWriter(o, "ISO8859_1"), true);
        }
        catch (UnsupportedEncodingException use) {
            this.util.bug("encoding.iso8859_1.not.found");
            return null;
        }
    }

    public void run() throws IOException, ClassNotFoundException, Util.Exit {
        boolean i = false;
        if (this.outFile != null) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(8192);
            this.writeFileTop(bout);
            for (TypeElement t : this.classes) {
                this.write(bout, t);
            }
            this.writeIfChanged(bout.toByteArray(), this.outFile);
        } else {
            for (TypeElement t : this.classes) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream(8192);
                this.writeFileTop(bout);
                this.write(bout, t);
                this.writeIfChanged(bout.toByteArray(), this.getFileObject(t.getQualifiedName()));
            }
        }
    }

    private void writeIfChanged(byte[] b, FileObject file) throws IOException {
        boolean mustWrite = false;
        String event = "[No need to update file ";
        if (this.force) {
            mustWrite = true;
            event = "[Forcefully writing file ";
        } else {
            try {
                InputStream in = file.openInputStream();
                byte[] a = this.readBytes(in);
                if (!Arrays.equals(a, b)) {
                    mustWrite = true;
                    event = "[Overwriting file ";
                }
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                mustWrite = true;
                event = "[Creating file ";
            }
        }
        if (this.util.verbose) {
            this.util.log(event + file + "]");
        }
        if (mustWrite) {
            OutputStream out = file.openOutputStream();
            out.write(b);
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readBytes(InputStream in) throws IOException {
        try {
            int n;
            byte[] array = new byte[in.available() + 1];
            int offset = 0;
            while ((n = in.read(array, offset, array.length - offset)) != -1) {
                if ((offset += n) != array.length) continue;
                array = Arrays.copyOf(array, array.length * 2);
            }
            byte[] byArray = Arrays.copyOf(array, offset);
            return byArray;
        }
        finally {
            in.close();
        }
    }

    protected String defineForStatic(TypeElement c, VariableElement f) throws Util.Exit {
        Name cnamedoc = c.getQualifiedName();
        Name fnamedoc = f.getSimpleName();
        String cname = this.mangler.mangle(cnamedoc, 1);
        String fname = this.mangler.mangle(fnamedoc, 2);
        if (!f.getModifiers().contains((Object)Modifier.STATIC)) {
            this.util.bug("tried.to.define.non.static");
        }
        if (f.getModifiers().contains((Object)Modifier.FINAL)) {
            Object value = null;
            value = f.getConstantValue();
            if (value != null) {
                String constString = null;
                if (value instanceof Integer || value instanceof Byte || value instanceof Short) {
                    constString = value.toString() + "L";
                } else if (value instanceof Boolean) {
                    constString = (Boolean)value != false ? "1L" : "0L";
                } else if (value instanceof Character) {
                    Character ch = (Character)value;
                    constString = String.valueOf(ch.charValue() & 0xFFFF) + "L";
                } else if (value instanceof Long) {
                    constString = isWindows ? value.toString() + "i64" : value.toString() + "LL";
                } else if (value instanceof Float) {
                    float fv = ((Float)value).floatValue();
                    constString = Float.isInfinite(fv) ? (fv < 0.0f ? "-" : "") + "Inff" : value.toString() + "f";
                } else if (value instanceof Double) {
                    double d = (Double)value;
                    constString = Double.isInfinite(d) ? (d < 0.0 ? "-" : "") + "InfD" : value.toString();
                }
                if (constString != null) {
                    StringBuilder s = new StringBuilder("#undef ");
                    s.append(cname);
                    s.append("_");
                    s.append(fname);
                    s.append(this.lineSep);
                    s.append("#define ");
                    s.append(cname);
                    s.append("_");
                    s.append(fname);
                    s.append(" ");
                    s.append(constString);
                    return s.toString();
                }
            }
        }
        return null;
    }

    protected String cppGuardBegin() {
        return "#ifdef __cplusplus" + this.lineSep + "extern \"C\" {" + this.lineSep + "#endif";
    }

    protected String cppGuardEnd() {
        return "#ifdef __cplusplus" + this.lineSep + "}" + this.lineSep + "#endif";
    }

    protected String guardBegin(String cname) {
        return "/* Header for class " + cname + " */" + this.lineSep + this.lineSep + "#ifndef _Included_" + cname + this.lineSep + "#define _Included_" + cname;
    }

    protected String guardEnd(String cname) {
        return "#endif";
    }

    protected void writeFileTop(OutputStream o) throws Util.Exit {
        PrintWriter pw = this.wrapWriter(o);
        pw.println("/* DO NOT EDIT THIS FILE - it is machine generated */" + this.lineSep + this.getIncludes());
    }

    protected String baseFileName(CharSequence className) {
        return this.mangler.mangle(className, 1);
    }

    protected FileObject getFileObject(CharSequence className) throws IOException {
        String name = this.baseFileName(className) + this.getFileSuffix();
        return this.fileManager.getFileForOutput(StandardLocation.SOURCE_OUTPUT, "", name, null);
    }

    protected String getFileSuffix() {
        return ".h";
    }

    List<VariableElement> getAllFields(TypeElement subclazz) {
        ArrayList<VariableElement> fields = new ArrayList<VariableElement>();
        TypeElement cd = null;
        Stack<TypeElement> s = new Stack<TypeElement>();
        cd = subclazz;
        while (true) {
            s.push(cd);
            TypeElement c = (TypeElement)this.types.asElement(cd.getSuperclass());
            if (c == null) break;
            cd = c;
        }
        while (!s.empty()) {
            cd = (TypeElement)s.pop();
            fields.addAll(ElementFilter.fieldsIn(cd.getEnclosedElements()));
        }
        return fields;
    }

    String signature(ExecutableElement e) {
        StringBuilder sb = new StringBuilder("(");
        String sep = "";
        for (VariableElement variableElement : e.getParameters()) {
            sb.append(sep);
            sb.append(this.types.erasure(variableElement.asType()).toString());
            sep = ",";
        }
        sb.append(")");
        return sb.toString();
    }
}

