/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry.credentials;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.credentials.CredentialHelperNotFoundException;
import com.google.cloud.tools.jib.registry.credentials.CredentialHelperUnhandledServerUrlException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import javax.annotation.Nullable;

public class DockerCredentialHelper {
    private final String serverUrl;
    private final Path credentialHelper;
    private final Properties systemProperties;
    private final Function<List<String>, ProcessBuilder> processBuilderFactory;
    private final Map<String, String> environment;

    public DockerCredentialHelper(String serverUrl, Path credentialHelper) {
        this(serverUrl, credentialHelper, System.getProperties(), ProcessBuilder::new, Collections.emptyMap());
    }

    public DockerCredentialHelper(String serverUrl, Path credentialHelper, Map<String, String> environment) {
        this(serverUrl, credentialHelper, System.getProperties(), ProcessBuilder::new, environment);
    }

    @VisibleForTesting
    DockerCredentialHelper(String serverUrl, Path credentialHelper, Properties systemProperties, Function<List<String>, ProcessBuilder> processBuilderFactory, Map<String, String> environment) {
        this.serverUrl = serverUrl;
        this.credentialHelper = credentialHelper;
        this.systemProperties = systemProperties;
        this.processBuilderFactory = processBuilderFactory;
        this.environment = environment;
    }

    public Credential retrieve() throws IOException, CredentialHelperUnhandledServerUrlException, CredentialHelperNotFoundException {
        boolean isWindows = this.systemProperties.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
        String lowerCaseHelper = this.credentialHelper.toString().toLowerCase(Locale.ENGLISH);
        if (!isWindows || lowerCaseHelper.endsWith(".cmd") || lowerCaseHelper.endsWith(".exe")) {
            return this.retrieve(Arrays.asList(this.credentialHelper.toString(), "get"));
        }
        for (String suffix : Arrays.asList(".cmd", ".exe")) {
            try {
                return this.retrieve(Arrays.asList(this.credentialHelper.toString() + suffix, "get"));
            }
            catch (CredentialHelperNotFoundException credentialHelperNotFoundException) {
            }
        }
        return this.retrieve(Arrays.asList(this.credentialHelper.toString(), "get"));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Credential retrieve(List<String> credentialHelperCommand) throws IOException, CredentialHelperUnhandledServerUrlException, CredentialHelperNotFoundException {
        try {
            ProcessBuilder processBuilder = this.processBuilderFactory.apply(credentialHelperCommand);
            processBuilder.environment().putAll(this.environment);
            Process process = processBuilder.start();
            try (OutputStream processStdin = process.getOutputStream();){
                processStdin.write(this.serverUrl.getBytes(StandardCharsets.UTF_8));
            }
            var5_6 = null;
            try (InputStreamReader processStdoutReader = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);){
                String output = CharStreams.toString((Readable)processStdoutReader);
                if (output.contains("credentials not found in native keychain")) {
                    throw new CredentialHelperUnhandledServerUrlException(this.credentialHelper, this.serverUrl, output);
                }
                if (output.isEmpty()) {
                    InputStreamReader processStderrReader = new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8);
                    Throwable throwable = null;
                    try {
                        try {
                            String errorOutput = CharStreams.toString((Readable)processStderrReader);
                            throw new CredentialHelperUnhandledServerUrlException(this.credentialHelper, this.serverUrl, errorOutput);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable3) {
                        DockerCredentialHelper.$closeResource(throwable, processStderrReader);
                        throw throwable3;
                    }
                }
                try {
                    DockerCredentialsTemplate dockerCredentials = JsonTemplateMapper.readJson(output, DockerCredentialsTemplate.class);
                    if (Strings.isNullOrEmpty((String)dockerCredentials.username) || Strings.isNullOrEmpty((String)dockerCredentials.secret)) {
                        throw new CredentialHelperUnhandledServerUrlException(this.credentialHelper, this.serverUrl, output);
                    }
                    Credential credential = Credential.from(dockerCredentials.username, dockerCredentials.secret);
                    return credential;
                }
                catch (JsonProcessingException ex) {
                    try {
                        throw new CredentialHelperUnhandledServerUrlException(this.credentialHelper, this.serverUrl, output);
                    }
                    catch (Throwable throwable) {
                        var5_6 = throwable;
                        throw throwable;
                    }
                }
            }
        }
        catch (IOException ex) {
            if (ex.getMessage() == null) {
                throw ex;
            }
            if (ex.getMessage().contains("No such file or directory") || ex.getMessage().contains("cannot find the file") || ex.getMessage().contains("error=2")) {
                throw new CredentialHelperNotFoundException(this.credentialHelper, (Throwable)ex);
            }
            throw ex;
        }
    }

    Path getCredentialHelper() {
        return this.credentialHelper;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @VisibleForTesting
    static class DockerCredentialsTemplate
    implements JsonTemplate {
        @Nullable
        @JsonProperty(value="Username")
        @VisibleForTesting
        String username;
        @Nullable
        @JsonProperty(value="Secret")
        @VisibleForTesting
        String secret;

        DockerCredentialsTemplate() {
        }
    }
}

