/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.datastoreservice.app.DatastoreClient;
import com.google.apphosting.client.datastoreservice.app.DatastoreRpcHandler;
import com.google.apphosting.client.datastoreservice.app.EntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.proto.DatastoreService;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.apphosting.datastore.DatastoreV4;

class RunQueryHandler
extends DatastoreRpcHandler<DatastoreService.RunQueryRequest, DatastoreService.RunQueryResponse, DatastoreClient> {
    private final EntityV4Normalizer entityNormalizer;
    private final Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> resultTransform;

    public RunQueryHandler(DatastoreClient datastoreClient, EntityV4Normalizer entityNormalizer, Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> resultTransform) {
        super(datastoreClient);
        this.entityNormalizer = entityNormalizer;
        this.resultTransform = resultTransform;
    }

    @Override
    public DatastoreService.RunQueryResponse call(RpcHandler.CallOptions options, DatastoreService.RunQueryRequest req) throws RpcException {
        return ((DatastoreClient)this.datastoreClient).runQuery(options, this.resultTransform, this.toV4RunQueryRequest(req));
    }

    @Override
    public Parser<DatastoreService.RunQueryRequest> getParser() {
        return DatastoreService.RunQueryRequest.PARSER;
    }

    @Override
    public Class<DatastoreService.RunQueryRequest> getRequestClass() {
        return DatastoreService.RunQueryRequest.class;
    }

    @Override
    public DatastoreService.RunQueryResponse makeError(Codes.Code errorCode, String message) {
        return DatastoreService.RunQueryResponse.newBuilder().setHeader(RunQueryHandler.makeErrorHeader(errorCode, message)).build();
    }

    private void normalizeQueryFilter(EntityV4Normalizer entityNormalizer, DatastoreV4.Filter.Builder filter) {
        if (filter.hasCompositeFilter()) {
            for (DatastoreV4.Filter.Builder subFilter : filter.getCompositeFilterBuilder().getFilterBuilderList()) {
                this.normalizeQueryFilter(entityNormalizer, subFilter);
            }
        }
        if (filter.hasPropertyFilter()) {
            DatastoreV4.PropertyFilter.Builder propertyFilter = filter.getPropertyFilterBuilder();
            propertyFilter.setValue(entityNormalizer.normalizeValue(propertyFilter.getValue()));
        }
    }

    private DatastoreV4.Query normalizeQuery(EntityV4Normalizer entityNormalizer, DatastoreV4.Query query) {
        if (!query.hasFilter()) {
            return query;
        }
        DatastoreV4.Query.Builder normQuery = query.toBuilder();
        this.normalizeQueryFilter(entityNormalizer, normQuery.getFilterBuilder());
        return normQuery.build();
    }

    private void normalizeGqlQueryArg(EntityV4Normalizer entityNormalizer, DatastoreV4.GqlQueryArg.Builder gqlQueryArg) {
        if (gqlQueryArg.hasValue()) {
            gqlQueryArg.setValue(entityNormalizer.normalizeValue(gqlQueryArg.getValue()));
        }
    }

    private DatastoreV4.GqlQuery normalizeGqlQuery(EntityV4Normalizer entityNormalizer, DatastoreV4.GqlQuery gqlQuery) {
        if (gqlQuery.getNameArgCount() == 0 && gqlQuery.getNumberArgCount() == 0) {
            return gqlQuery;
        }
        DatastoreV4.GqlQuery.Builder normGqlQuery = gqlQuery.toBuilder();
        for (DatastoreV4.GqlQueryArg.Builder nameArg : normGqlQuery.getNameArgBuilderList()) {
            this.normalizeGqlQueryArg(entityNormalizer, nameArg);
        }
        for (DatastoreV4.GqlQueryArg.Builder numberArg : normGqlQuery.getNumberArgBuilderList()) {
            this.normalizeGqlQueryArg(entityNormalizer, numberArg);
        }
        return normGqlQuery.build();
    }

    DatastoreV4.RunQueryRequest toV4RunQueryRequest(DatastoreService.RunQueryRequest req) {
        DatastoreV4.RunQueryRequest.Builder reqV4 = DatastoreV4.RunQueryRequest.newBuilder();
        reqV4.setPartitionId(this.entityNormalizer.normalizePartitionId(req.getPartitionId()));
        EntityV4Normalizer contextNormalizer = this.entityNormalizer.overrideDefaultPartitionId(reqV4.getPartitionId());
        if (req.hasQuery()) {
            reqV4.setQuery(this.normalizeQuery(contextNormalizer, req.getQuery()));
        }
        if (req.hasGqlQuery()) {
            reqV4.setGqlQuery(this.normalizeGqlQuery(contextNormalizer, req.getGqlQuery()));
        }
        reqV4.setSuggestedBatchSize(Integer.MAX_VALUE);
        if (req.hasReadOptions()) {
            reqV4.setReadOptions(req.getReadOptions());
        }
        return reqV4.build();
    }
}

