/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.primitives;

import com.google.appengine.repackaged.com.google.common.annotations.Beta;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.primitives.Longs;
import java.math.BigInteger;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
@GwtCompatible
public final class UnsignedLongs {
    public static final long MAX_VALUE = -1L;
    private static final long[] maxValueDivs = new long[37];
    private static final int[] maxValueMods = new int[37];
    private static final int[] maxSafeDigits = new int[37];

    private UnsignedLongs() {
    }

    public static BigInteger toBigInteger(long unsigned) {
        BigInteger result = BigInteger.valueOf(unsigned & Long.MAX_VALUE);
        if (unsigned < 0L) {
            result = result.setBit(63);
        }
        return result;
    }

    public static long checkedCast(BigInteger value) {
        Preconditions.checkNotNull(value);
        Preconditions.checkArgument(value.signum() >= 0 && value.bitLength() <= 64, "out of range: %s", value);
        return value.longValue();
    }

    public static long saturatedCast(BigInteger value) {
        Preconditions.checkNotNull(value);
        if (value.signum() < 0) {
            return 0L;
        }
        if (value.bitLength() > 64) {
            return -1L;
        }
        return value.longValue();
    }

    public static int compare(long a, long b) {
        return Longs.compare(a + Long.MIN_VALUE, b + Long.MIN_VALUE);
    }

    public static long min(long ... array) {
        Preconditions.checkArgument(array.length > 0);
        long min = array[0] + Long.MIN_VALUE;
        for (int i = 1; i < array.length; ++i) {
            long next = array[i] + Long.MIN_VALUE;
            if (next >= min) continue;
            min = next;
        }
        return min - Long.MIN_VALUE;
    }

    public static long max(long ... array) {
        Preconditions.checkArgument(array.length > 0);
        long max = array[0] + Long.MIN_VALUE;
        for (int i = 1; i < array.length; ++i) {
            long next = array[i] + Long.MIN_VALUE;
            if (next <= max) continue;
            max = next;
        }
        return max - Long.MIN_VALUE;
    }

    public static String join(String separator, long ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 5);
        builder.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            builder.append(separator).append(UnsignedLongs.toString(array[i]));
        }
        return builder.toString();
    }

    public static Comparator<long[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static long divide(long dividend, long divisor) {
        long quotient;
        if (divisor < 0L) {
            if (dividend + Long.MIN_VALUE < divisor + Long.MIN_VALUE) {
                return 0L;
            }
            return 1L;
        }
        if (dividend >= 0L) {
            return dividend / divisor;
        }
        long rem = dividend - (quotient = (dividend >>> 1) / divisor << 1) * divisor;
        return quotient + (long)(rem + Long.MIN_VALUE >= divisor + Long.MIN_VALUE ? 1 : 0);
    }

    public static long remainder(long dividend, long divisor) {
        long rem;
        if (divisor < 0L) {
            if (dividend + Long.MIN_VALUE < divisor + Long.MIN_VALUE) {
                return dividend;
            }
            return dividend - divisor;
        }
        if (dividend >= 0L) {
            return dividend % divisor;
        }
        long quotient = (dividend >>> 1) / divisor << 1;
        return rem - ((rem = dividend - quotient * divisor) + Long.MIN_VALUE >= divisor + Long.MIN_VALUE ? divisor : 0L);
    }

    public static long parseUnsignedLong(String s) {
        return UnsignedLongs.parseUnsignedLong(s, 10);
    }

    public static long parseUnsignedLong(String s, int radix) {
        Preconditions.checkNotNull(s);
        if (s.length() == 0) {
            throw new NumberFormatException("empty string");
        }
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("illegal radix:" + radix);
        }
        int max_safe_pos = maxSafeDigits[radix] - 1;
        long value = 0L;
        for (int pos = 0; pos < s.length(); ++pos) {
            int digit = Character.digit(s.charAt(pos), radix);
            if (digit == -1) {
                throw new NumberFormatException(s);
            }
            if (pos > max_safe_pos && UnsignedLongs.overflowInParse(value, digit, radix)) {
                throw new NumberFormatException("Too large for unsigned long: " + s);
            }
            value = value * (long)radix + (long)digit;
        }
        return value;
    }

    private static boolean overflowInParse(long current, int digit, int radix) {
        if (current >= 0L) {
            if (current < maxValueDivs[radix]) {
                return false;
            }
            if (current > maxValueDivs[radix]) {
                return true;
            }
            return digit > maxValueMods[radix];
        }
        return true;
    }

    public static String toString(long x) {
        return UnsignedLongs.toString(x, 10);
    }

    public static String toString(long x, int radix) {
        if (x == 0L) {
            return "0";
        }
        char[] buf = new char[64];
        int i = buf.length;
        if (x < 0L) {
            long top = x >>> 32;
            long bot = (x & 0xFFFFFFFFL) + (top % (long)radix << 32);
            top /= (long)radix;
            while (bot > 0L || top > 0L) {
                buf[--i] = Character.forDigit((int)(bot % (long)radix), radix);
                bot = bot / (long)radix + (top % (long)radix << 32);
                top /= (long)radix;
            }
        } else {
            while (x > 0L) {
                buf[--i] = Character.forDigit((int)(x % (long)radix), radix);
                x /= (long)radix;
            }
        }
        return new String(buf, i, buf.length - i);
    }

    static {
        BigInteger overflow = new BigInteger("10000000000000000", 16);
        for (int i = 2; i <= 36; ++i) {
            UnsignedLongs.maxValueDivs[i] = UnsignedLongs.divide(-1L, i);
            UnsignedLongs.maxValueMods[i] = (int)UnsignedLongs.remainder(-1L, i);
            UnsignedLongs.maxSafeDigits[i] = overflow.toString(i).length() - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LexicographicalComparator implements Comparator<long[]>
    {
        INSTANCE;


        @Override
        public int compare(long[] left, long[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                if (left[i] == right[i]) continue;
                return UnsignedLongs.compare(left[i], right[i]);
            }
            return left.length - right.length;
        }
    }
}

