package com.cybelia.sandra.entities.trace;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class SuiviUsineImpl extends SuiviUsineAbstract {

    private static final long serialVersionUID = 1L;

    @Override
    public CRUsine getCRUsine() {
        return super.getcRUsine();
    }

    @Override
    public void setCRUsine(CRUsine crUsine) {
        super.setcRUsine(crUsine);
    }

    @Override
    public boolean isActif() {
        List<SuiviLigneProduit> suiviLigneProduits = getSuiviLigneProduit();
        return suiviLigneProduits != null && !suiviLigneProduits.isEmpty();
    }

    @Override
    public List<SuiviLigneProduit> getSuiviLigneProduit() {

        Collection<SuiviLigneProduit> suiviLigneProduits = super.getSuiviLigneProduit();
        if (suiviLigneProduits == null) {
            return null;
        }

        List<SuiviLigneProduit> actifSuiviLigneProduit = Lists.newArrayList();
        for (SuiviLigneProduit suiviLigneProduit : suiviLigneProduits) {
            if (suiviLigneProduit.isActif()) {
                actifSuiviLigneProduit.add(suiviLigneProduit);
            }
        }
        return actifSuiviLigneProduit;
    }

    @Override
    public int sizeSuiviLigneProduit() {
        List<SuiviLigneProduit> suiviProduitList = getSuiviLigneProduit();
        if (suiviProduitList == null) {
            return 0;
        }
        return suiviProduitList.size();
    }
}
