package com.cybelia.sandra.entities.trace;

import com.cybelia.sandra.entities.Usine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class SuiviUsineAbstract extends TopiaEntityAbstract implements SuiviUsine {

    /**
     * Nom de l'attribut en BD : creationOrdre
     */
    protected int creationOrdre;

    /**
     * Nom de l'attribut en BD : nouvelleOrdre
     */
    protected int nouvelleOrdre;

    /**
     * Nom de l'attribut en BD : dateEntree
     */
    protected Date dateEntree;

    /**
     * Nom de l'attribut en BD : dateSortie
     */
    protected Date dateSortie;

    /**
     * Nom de l'attribut en BD : tempsChargement
     */
    protected Date tempsChargement;

    /**
     * Nom de l'attribut en BD : heureChargement
     */
    protected Date heureChargement;

    /**
     * Nom de l'attribut en BD : chargePar
     */
    protected int chargePar;

    /**
     * Nom de l'attribut en BD : dateChargementPrevue
     */
    protected Date dateChargementPrevue;

    /**
     * Nom de l'attribut en BD : suiviLigneProduit
     */
    protected Collection<SuiviLigneProduit> suiviLigneProduit;

    /**
     * Nom de l'attribut en BD : cRUsine
     */
    protected CRUsine cRUsine;

    /**
     * Nom de l'attribut en BD : usine
     */
    protected Usine usine;

    private static final long serialVersionUID = 3631653063128004705L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_CREATION_ORDRE, int.class, creationOrdre);
        visitor.visit(this, PROPERTY_NOUVELLE_ORDRE, int.class, nouvelleOrdre);
        visitor.visit(this, PROPERTY_DATE_ENTREE, Date.class, dateEntree);
        visitor.visit(this, PROPERTY_DATE_SORTIE, Date.class, dateSortie);
        visitor.visit(this, PROPERTY_TEMPS_CHARGEMENT, Date.class, tempsChargement);
        visitor.visit(this, PROPERTY_HEURE_CHARGEMENT, Date.class, heureChargement);
        visitor.visit(this, PROPERTY_CHARGE_PAR, int.class, chargePar);
        visitor.visit(this, PROPERTY_DATE_CHARGEMENT_PREVUE, Date.class, dateChargementPrevue);
        visitor.visit(this, PROPERTY_SUIVI_LIGNE_PRODUIT, Collection.class, SuiviLigneProduit.class, suiviLigneProduit);
        visitor.visit(this, PROPERTY_C_RUSINE, CRUsine.class, cRUsine);
        visitor.visit(this, PROPERTY_USINE, Usine.class, usine);
        visitor.end(this);
    }

    @Override
    public void setCreationOrdre(int creationOrdre) {
        int oldValue = this.creationOrdre;
        fireOnPreWrite(PROPERTY_CREATION_ORDRE, oldValue, creationOrdre);
        this.creationOrdre = creationOrdre;
        fireOnPostWrite(PROPERTY_CREATION_ORDRE, oldValue, creationOrdre);
    }

    @Override
    public int getCreationOrdre() {
        fireOnPreRead(PROPERTY_CREATION_ORDRE, creationOrdre);
        int result = this.creationOrdre;
        fireOnPostRead(PROPERTY_CREATION_ORDRE, creationOrdre);
        return result;
    }

    @Override
    public void setNouvelleOrdre(int nouvelleOrdre) {
        int oldValue = this.nouvelleOrdre;
        fireOnPreWrite(PROPERTY_NOUVELLE_ORDRE, oldValue, nouvelleOrdre);
        this.nouvelleOrdre = nouvelleOrdre;
        fireOnPostWrite(PROPERTY_NOUVELLE_ORDRE, oldValue, nouvelleOrdre);
    }

    @Override
    public int getNouvelleOrdre() {
        fireOnPreRead(PROPERTY_NOUVELLE_ORDRE, nouvelleOrdre);
        int result = this.nouvelleOrdre;
        fireOnPostRead(PROPERTY_NOUVELLE_ORDRE, nouvelleOrdre);
        return result;
    }

    @Override
    public void setDateEntree(Date dateEntree) {
        Date oldValue = this.dateEntree;
        fireOnPreWrite(PROPERTY_DATE_ENTREE, oldValue, dateEntree);
        this.dateEntree = dateEntree;
        fireOnPostWrite(PROPERTY_DATE_ENTREE, oldValue, dateEntree);
    }

    @Override
    public Date getDateEntree() {
        fireOnPreRead(PROPERTY_DATE_ENTREE, dateEntree);
        Date result = this.dateEntree;
        fireOnPostRead(PROPERTY_DATE_ENTREE, dateEntree);
        return result;
    }

    @Override
    public void setDateSortie(Date dateSortie) {
        Date oldValue = this.dateSortie;
        fireOnPreWrite(PROPERTY_DATE_SORTIE, oldValue, dateSortie);
        this.dateSortie = dateSortie;
        fireOnPostWrite(PROPERTY_DATE_SORTIE, oldValue, dateSortie);
    }

    @Override
    public Date getDateSortie() {
        fireOnPreRead(PROPERTY_DATE_SORTIE, dateSortie);
        Date result = this.dateSortie;
        fireOnPostRead(PROPERTY_DATE_SORTIE, dateSortie);
        return result;
    }

    @Override
    public void setTempsChargement(Date tempsChargement) {
        Date oldValue = this.tempsChargement;
        fireOnPreWrite(PROPERTY_TEMPS_CHARGEMENT, oldValue, tempsChargement);
        this.tempsChargement = tempsChargement;
        fireOnPostWrite(PROPERTY_TEMPS_CHARGEMENT, oldValue, tempsChargement);
    }

    @Override
    public Date getTempsChargement() {
        fireOnPreRead(PROPERTY_TEMPS_CHARGEMENT, tempsChargement);
        Date result = this.tempsChargement;
        fireOnPostRead(PROPERTY_TEMPS_CHARGEMENT, tempsChargement);
        return result;
    }

    @Override
    public void setHeureChargement(Date heureChargement) {
        Date oldValue = this.heureChargement;
        fireOnPreWrite(PROPERTY_HEURE_CHARGEMENT, oldValue, heureChargement);
        this.heureChargement = heureChargement;
        fireOnPostWrite(PROPERTY_HEURE_CHARGEMENT, oldValue, heureChargement);
    }

    @Override
    public Date getHeureChargement() {
        fireOnPreRead(PROPERTY_HEURE_CHARGEMENT, heureChargement);
        Date result = this.heureChargement;
        fireOnPostRead(PROPERTY_HEURE_CHARGEMENT, heureChargement);
        return result;
    }

    @Override
    public void setChargePar(int chargePar) {
        int oldValue = this.chargePar;
        fireOnPreWrite(PROPERTY_CHARGE_PAR, oldValue, chargePar);
        this.chargePar = chargePar;
        fireOnPostWrite(PROPERTY_CHARGE_PAR, oldValue, chargePar);
    }

    @Override
    public int getChargePar() {
        fireOnPreRead(PROPERTY_CHARGE_PAR, chargePar);
        int result = this.chargePar;
        fireOnPostRead(PROPERTY_CHARGE_PAR, chargePar);
        return result;
    }

    @Override
    public void setDateChargementPrevue(Date dateChargementPrevue) {
        Date oldValue = this.dateChargementPrevue;
        fireOnPreWrite(PROPERTY_DATE_CHARGEMENT_PREVUE, oldValue, dateChargementPrevue);
        this.dateChargementPrevue = dateChargementPrevue;
        fireOnPostWrite(PROPERTY_DATE_CHARGEMENT_PREVUE, oldValue, dateChargementPrevue);
    }

    @Override
    public Date getDateChargementPrevue() {
        fireOnPreRead(PROPERTY_DATE_CHARGEMENT_PREVUE, dateChargementPrevue);
        Date result = this.dateChargementPrevue;
        fireOnPostRead(PROPERTY_DATE_CHARGEMENT_PREVUE, dateChargementPrevue);
        return result;
    }

    @Override
    public void addSuiviLigneProduit(SuiviLigneProduit suiviLigneProduit) {
        fireOnPreWrite(PROPERTY_SUIVI_LIGNE_PRODUIT, null, suiviLigneProduit);
        if (this.suiviLigneProduit == null) {
            this.suiviLigneProduit = new ArrayList<SuiviLigneProduit>();
        }

        this.suiviLigneProduit.add(suiviLigneProduit);
        fireOnPostWrite(PROPERTY_SUIVI_LIGNE_PRODUIT, this.suiviLigneProduit.size(), null, suiviLigneProduit);
    }

    @Override
    public void addAllSuiviLigneProduit(Collection<SuiviLigneProduit> suiviLigneProduit) {
        if (suiviLigneProduit == null) {
            return;
        }
        for (SuiviLigneProduit item : suiviLigneProduit) {
            addSuiviLigneProduit(item);
        }
    }

    @Override
    public void setSuiviLigneProduit(Collection<SuiviLigneProduit> suiviLigneProduit) {
        // Copy elements to keep data for fire with new reference
        Collection<SuiviLigneProduit> oldValue = this.suiviLigneProduit != null ? new ArrayList<SuiviLigneProduit>(this.suiviLigneProduit) : null;
        fireOnPreWrite(PROPERTY_SUIVI_LIGNE_PRODUIT, oldValue, suiviLigneProduit);
        this.suiviLigneProduit = suiviLigneProduit;
        fireOnPostWrite(PROPERTY_SUIVI_LIGNE_PRODUIT, oldValue, suiviLigneProduit);
    }

    @Override
    public void removeSuiviLigneProduit(SuiviLigneProduit suiviLigneProduit) {
        fireOnPreWrite(PROPERTY_SUIVI_LIGNE_PRODUIT, suiviLigneProduit, null);
        if (this.suiviLigneProduit == null || !this.suiviLigneProduit.remove(suiviLigneProduit)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_SUIVI_LIGNE_PRODUIT, this.suiviLigneProduit.size() + 1, suiviLigneProduit, null);
    }

    @Override
    public void clearSuiviLigneProduit() {
        if (this.suiviLigneProduit == null) {
            return;
        }
        Collection<SuiviLigneProduit> oldValue = new ArrayList<SuiviLigneProduit>(this.suiviLigneProduit);
        fireOnPreWrite(PROPERTY_SUIVI_LIGNE_PRODUIT, oldValue, this.suiviLigneProduit);
        this.suiviLigneProduit.clear();
        fireOnPostWrite(PROPERTY_SUIVI_LIGNE_PRODUIT, oldValue, this.suiviLigneProduit);
    }

    @Override
    public Collection<SuiviLigneProduit> getSuiviLigneProduit() {
        return suiviLigneProduit;
    }

    @Override
    public SuiviLigneProduit getSuiviLigneProduitByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(suiviLigneProduit, topiaId);
    }

    @Override
    public int sizeSuiviLigneProduit() {
        if (suiviLigneProduit == null) {
            return 0;
        }
        return suiviLigneProduit.size();
    }

    @Override
    public boolean isSuiviLigneProduitEmpty() {
        int size = sizeSuiviLigneProduit();
        return size == 0;
    }

    @Override
    public void setcRUsine(CRUsine cRUsine) {
        CRUsine oldValue = this.cRUsine;
        fireOnPreWrite(PROPERTY_C_RUSINE, oldValue, cRUsine);
        this.cRUsine = cRUsine;
        fireOnPostWrite(PROPERTY_C_RUSINE, oldValue, cRUsine);
    }

    @Override
    public CRUsine getcRUsine() {
        fireOnPreRead(PROPERTY_C_RUSINE, cRUsine);
        CRUsine result = this.cRUsine;
        fireOnPostRead(PROPERTY_C_RUSINE, cRUsine);
        return result;
    }

    @Override
    public void setUsine(Usine usine) {
        Usine oldValue = this.usine;
        fireOnPreWrite(PROPERTY_USINE, oldValue, usine);
        this.usine = usine;
        fireOnPostWrite(PROPERTY_USINE, oldValue, usine);
    }

    @Override
    public Usine getUsine() {
        fireOnPreRead(PROPERTY_USINE, usine);
        Usine result = this.usine;
        fireOnPostRead(PROPERTY_USINE, usine);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        if (getSuiviLigneProduit() != null) {
              tmp.addAll(getSuiviLigneProduit());
           }
        tmp.add(getcRUsine());

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_CREATION_ORDRE, this.creationOrdre).
            append(PROPERTY_NOUVELLE_ORDRE, this.nouvelleOrdre).
            append(PROPERTY_DATE_ENTREE, this.dateEntree).
            append(PROPERTY_DATE_SORTIE, this.dateSortie).
            append(PROPERTY_TEMPS_CHARGEMENT, this.tempsChargement).
            append(PROPERTY_HEURE_CHARGEMENT, this.heureChargement).
            append(PROPERTY_CHARGE_PAR, this.chargePar).
            append(PROPERTY_DATE_CHARGEMENT_PREVUE, this.dateChargementPrevue).
            append(PROPERTY_SUIVI_LIGNE_PRODUIT, this.suiviLigneProduit).
            append(PROPERTY_C_RUSINE, this.cRUsine).
            append(PROPERTY_USINE, this.usine).
         toString();
        return result;
    }

} //SuiviUsineAbstract
