package com.cybelia.sandra.entities.trace;

import com.cybelia.sandra.SandraEntityEnum;
import com.cybelia.sandra.entities.LigneProduit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class SuiviLigneProduitDAOAbstract<E extends SuiviLigneProduit> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)SuiviLigneProduit.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.SuiviLigneProduit;
    }

    public E findByQuantite(int v) throws TopiaException {
        E result = findByProperty(SuiviLigneProduit.PROPERTY_QUANTITE, v);
        return result;
    }

    public List<E> findAllByQuantite(int v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviLigneProduit.PROPERTY_QUANTITE, v);
        return result;
    }

    public E findByCompartiments(String v) throws TopiaException {
        E result = findByProperty(SuiviLigneProduit.PROPERTY_COMPARTIMENTS, v);
        return result;
    }

    public List<E> findAllByCompartiments(String v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviLigneProduit.PROPERTY_COMPARTIMENTS, v);
        return result;
    }

    public E findByLigneProduit(LigneProduit v) throws TopiaException {
        E result = findByProperty(SuiviLigneProduit.PROPERTY_LIGNE_PRODUIT, v);
        return result;
    }

    public List<E> findAllByLigneProduit(LigneProduit v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviLigneProduit.PROPERTY_LIGNE_PRODUIT, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == SuiviUsine.class) {
            SuiviUsineDAO dao = (SuiviUsineDAO)
                getContext().getDAO(SuiviUsine.class);
            tmp = dao.findAllContainsSuiviLigneProduit(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(SuiviUsine.class, entity);
        if (!list.isEmpty()) {
            result.put(SuiviUsine.class, list);
        }

        return result;
    }

} //SuiviLigneProduitDAOAbstract<E extends SuiviLigneProduit>
