package com.cybelia.sandra.entities.trace;

import com.cybelia.sandra.entities.LigneProduit;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class SuiviLigneProduitAbstract extends TopiaEntityAbstract implements SuiviLigneProduit {

    /**
     * Nom de l'attribut en BD : quantite
     */
    protected int quantite;

    /**
     * Nom de l'attribut en BD : compartiments
     */
    protected String compartiments;

    /**
     * Nom de l'attribut en BD : ligneProduit
     */
    protected LigneProduit ligneProduit;

    private static final long serialVersionUID = 3545793475703223905L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_QUANTITE, int.class, quantite);
        visitor.visit(this, PROPERTY_COMPARTIMENTS, String.class, compartiments);
        visitor.visit(this, PROPERTY_LIGNE_PRODUIT, LigneProduit.class, ligneProduit);
        visitor.end(this);
    }

    @Override
    public void setQuantite(int quantite) {
        int oldValue = this.quantite;
        fireOnPreWrite(PROPERTY_QUANTITE, oldValue, quantite);
        this.quantite = quantite;
        fireOnPostWrite(PROPERTY_QUANTITE, oldValue, quantite);
    }

    @Override
    public int getQuantite() {
        fireOnPreRead(PROPERTY_QUANTITE, quantite);
        int result = this.quantite;
        fireOnPostRead(PROPERTY_QUANTITE, quantite);
        return result;
    }

    @Override
    public void setCompartiments(String compartiments) {
        String oldValue = this.compartiments;
        fireOnPreWrite(PROPERTY_COMPARTIMENTS, oldValue, compartiments);
        this.compartiments = compartiments;
        fireOnPostWrite(PROPERTY_COMPARTIMENTS, oldValue, compartiments);
    }

    @Override
    public String getCompartiments() {
        fireOnPreRead(PROPERTY_COMPARTIMENTS, compartiments);
        String result = this.compartiments;
        fireOnPostRead(PROPERTY_COMPARTIMENTS, compartiments);
        return result;
    }

    @Override
    public void setLigneProduit(LigneProduit ligneProduit) {
        LigneProduit oldValue = this.ligneProduit;
        fireOnPreWrite(PROPERTY_LIGNE_PRODUIT, oldValue, ligneProduit);
        this.ligneProduit = ligneProduit;
        fireOnPostWrite(PROPERTY_LIGNE_PRODUIT, oldValue, ligneProduit);
    }

    @Override
    public LigneProduit getLigneProduit() {
        fireOnPreRead(PROPERTY_LIGNE_PRODUIT, ligneProduit);
        LigneProduit result = this.ligneProduit;
        fireOnPostRead(PROPERTY_LIGNE_PRODUIT, ligneProduit);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_QUANTITE, this.quantite).
            append(PROPERTY_COMPARTIMENTS, this.compartiments).
            append(PROPERTY_LIGNE_PRODUIT, this.ligneProduit).
         toString();
        return result;
    }

} //SuiviLigneProduitAbstract
