package com.cybelia.sandra.entities.trace;

import com.cybelia.sandra.SandraEntityEnum;
import com.cybelia.sandra.entities.Etape;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class SuiviEtapeDAOAbstract<E extends SuiviEtape> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)SuiviEtape.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.SuiviEtape;
    }

    public E findByNouvelleOrdre(int v) throws TopiaException {
        E result = findByProperty(SuiviEtape.PROPERTY_NOUVELLE_ORDRE, v);
        return result;
    }

    public List<E> findAllByNouvelleOrdre(int v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviEtape.PROPERTY_NOUVELLE_ORDRE, v);
        return result;
    }

    public E findByStatus(int v) throws TopiaException {
        E result = findByProperty(SuiviEtape.PROPERTY_STATUS, v);
        return result;
    }

    public List<E> findAllByStatus(int v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviEtape.PROPERTY_STATUS, v);
        return result;
    }

    public E findByDateEntree(Date v) throws TopiaException {
        E result = findByProperty(SuiviEtape.PROPERTY_DATE_ENTREE, v);
        return result;
    }

    public List<E> findAllByDateEntree(Date v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviEtape.PROPERTY_DATE_ENTREE, v);
        return result;
    }

    public E findByDateSortie(Date v) throws TopiaException {
        E result = findByProperty(SuiviEtape.PROPERTY_DATE_SORTIE, v);
        return result;
    }

    public List<E> findAllByDateSortie(Date v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviEtape.PROPERTY_DATE_SORTIE, v);
        return result;
    }

    public E findBycREtape(CREtape v) throws TopiaException {
        E result = findByProperty(SuiviEtape.PROPERTY_C_RETAPE, v);
        return result;
    }

    public List<E> findAllBycREtape(CREtape v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviEtape.PROPERTY_C_RETAPE, v);
        return result;
    }

    public E findByEtape(Etape v) throws TopiaException {
        E result = findByProperty(SuiviEtape.PROPERTY_ETAPE, v);
        return result;
    }

    public List<E> findAllByEtape(Etape v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviEtape.PROPERTY_ETAPE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == SuiviTour.class) {
            SuiviTourDAO dao = (SuiviTourDAO)
                getContext().getDAO(SuiviTour.class);
            tmp = dao.findAllContainsSuiviEtapes(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(SuiviTour.class, entity);
        if (!list.isEmpty()) {
            result.put(SuiviTour.class, list);
        }

        return result;
    }

} //SuiviEtapeDAOAbstract<E extends SuiviEtape>
