package com.cybelia.sandra.entities.synchro;

import com.cybelia.sandra.SandraEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class SynchroDAOAbstract<E extends Synchro> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Synchro.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.Synchro;
    }

    public E findByValue(int v) throws TopiaException {
        E result = findByProperty(Synchro.PROPERTY_VALUE, v);
        return result;
    }

    public List<E> findAllByValue(int v) throws TopiaException {
        List<E> result = findAllByProperty(Synchro.PROPERTY_VALUE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //SynchroDAOAbstract<E extends Synchro>
