package com.cybelia.sandra.entities.notifier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class EventAbstract extends TopiaEntityAbstract implements Event {

    /**
     * Nom de l'attribut en BD : type
     */
    protected String type;

    /**
     * Nom de l'attribut en BD : variables
     */
    protected Collection<String> variables;

    private static final long serialVersionUID = 3978422524905272121L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_TYPE, String.class, type);
        visitor.visit(this, PROPERTY_VARIABLES, Collection.class, String.class, variables);
        visitor.end(this);
    }

    @Override
    public void setType(String type) {
        String oldValue = this.type;
        fireOnPreWrite(PROPERTY_TYPE, oldValue, type);
        this.type = type;
        fireOnPostWrite(PROPERTY_TYPE, oldValue, type);
    }

    @Override
    public String getType() {
        fireOnPreRead(PROPERTY_TYPE, type);
        String result = this.type;
        fireOnPostRead(PROPERTY_TYPE, type);
        return result;
    }

    @Override
    public void addVariables(String variables) {
        fireOnPreWrite(PROPERTY_VARIABLES, null, variables);
        if (this.variables == null) {
            this.variables = new ArrayList<String>();
        }

        this.variables.add(variables);
        fireOnPostWrite(PROPERTY_VARIABLES, this.variables.size(), null, variables);
    }

    @Override
    public void addAllVariables(Collection<String> variables) {
        if (variables == null) {
            return;
        }
        for (String item : variables) {
            addVariables(item);
        }
    }

    @Override
    public void setVariables(Collection<String> variables) {
        // Copy elements to keep data for fire with new reference
        Collection<String> oldValue = this.variables != null ? new ArrayList<String>(this.variables) : null;
        fireOnPreWrite(PROPERTY_VARIABLES, oldValue, variables);
        this.variables = variables;
        fireOnPostWrite(PROPERTY_VARIABLES, oldValue, variables);
    }

    @Override
    public void removeVariables(String variables) {
        fireOnPreWrite(PROPERTY_VARIABLES, variables, null);
        if (this.variables == null || !this.variables.remove(variables)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_VARIABLES, this.variables.size() + 1, variables, null);
    }

    @Override
    public void clearVariables() {
        if (this.variables == null) {
            return;
        }
        Collection<String> oldValue = new ArrayList<String>(this.variables);
        fireOnPreWrite(PROPERTY_VARIABLES, oldValue, this.variables);
        this.variables.clear();
        fireOnPostWrite(PROPERTY_VARIABLES, oldValue, this.variables);
    }

    @Override
    public Collection<String> getVariables() {
        return variables;
    }

    @Override
    public int sizeVariables() {
        if (variables == null) {
            return 0;
        }
        return variables.size();
    }

    @Override
    public boolean isVariablesEmpty() {
        int size = sizeVariables();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_TYPE, this.type).
            append(PROPERTY_VARIABLES, this.variables).
         toString();
        return result;
    }

} //EventAbstract
