package com.cybelia.sandra.entities;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.taas.entities.TaasUser;

public abstract class UserIndicateursAbstract extends TopiaEntityAbstract implements UserIndicateurs {

    /**
     * Nom de l'attribut en BD : nbGpsMaj
     */
    protected int nbGpsMaj;

    /**
     * Nom de l'attribut en BD : nbSecuMaj
     */
    protected int nbSecuMaj;

    /**
     * Nom de l'attribut en BD : nbMaj
     */
    protected int nbMaj;

    /**
     * Nom de l'attribut en BD : nbSynchWifi
     */
    protected int nbSynchWifi;

    /**
     * Nom de l'attribut en BD : nbSynchAuto
     */
    protected int nbSynchAuto;

    /**
     * Nom de l'attribut en BD : nbSynchGPRS
     */
    protected int nbSynchGPRS;

    /**
     * Nom de l'attribut en BD : nbSynchKo
     */
    protected int nbSynchKo;

    /**
     * Nom de l'attribut en BD : nbOctetsReceivedGPRS
     */
    protected int nbOctetsReceivedGPRS;

    /**
     * Nom de l'attribut en BD : nbOctetsSendGPRS
     */
    protected int nbOctetsSendGPRS;

    /**
     * Nom de l'attribut en BD : nbOctetsReceivedWifi
     */
    protected int nbOctetsReceivedWifi;

    /**
     * Nom de l'attribut en BD : nbOctetsSendWifi
     */
    protected int nbOctetsSendWifi;

    /**
     * Nom de l'attribut en BD : nbNotifs
     */
    protected int nbNotifs;

    /**
     * Nom de l'attribut en BD : lastSynch
     */
    protected Date lastSynch;

    /**
     * Nom de l'attribut en BD : lastModif
     */
    protected Date lastModif;

    /**
     * Nom de l'attribut en BD : taasUser
     */
    protected TaasUser taasUser;

    private static final long serialVersionUID = 3690812286998688308L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NB_GPS_MAJ, int.class, nbGpsMaj);
        visitor.visit(this, PROPERTY_NB_SECU_MAJ, int.class, nbSecuMaj);
        visitor.visit(this, PROPERTY_NB_MAJ, int.class, nbMaj);
        visitor.visit(this, PROPERTY_NB_SYNCH_WIFI, int.class, nbSynchWifi);
        visitor.visit(this, PROPERTY_NB_SYNCH_AUTO, int.class, nbSynchAuto);
        visitor.visit(this, PROPERTY_NB_SYNCH_GPRS, int.class, nbSynchGPRS);
        visitor.visit(this, PROPERTY_NB_SYNCH_KO, int.class, nbSynchKo);
        visitor.visit(this, PROPERTY_NB_OCTETS_RECEIVED_GPRS, int.class, nbOctetsReceivedGPRS);
        visitor.visit(this, PROPERTY_NB_OCTETS_SEND_GPRS, int.class, nbOctetsSendGPRS);
        visitor.visit(this, PROPERTY_NB_OCTETS_RECEIVED_WIFI, int.class, nbOctetsReceivedWifi);
        visitor.visit(this, PROPERTY_NB_OCTETS_SEND_WIFI, int.class, nbOctetsSendWifi);
        visitor.visit(this, PROPERTY_NB_NOTIFS, int.class, nbNotifs);
        visitor.visit(this, PROPERTY_LAST_SYNCH, Date.class, lastSynch);
        visitor.visit(this, PROPERTY_LAST_MODIF, Date.class, lastModif);
        visitor.visit(this, PROPERTY_TAAS_USER, TaasUser.class, taasUser);
        visitor.end(this);
    }

    @Override
    public void setNbGpsMaj(int nbGpsMaj) {
        int oldValue = this.nbGpsMaj;
        fireOnPreWrite(PROPERTY_NB_GPS_MAJ, oldValue, nbGpsMaj);
        this.nbGpsMaj = nbGpsMaj;
        fireOnPostWrite(PROPERTY_NB_GPS_MAJ, oldValue, nbGpsMaj);
    }

    @Override
    public int getNbGpsMaj() {
        fireOnPreRead(PROPERTY_NB_GPS_MAJ, nbGpsMaj);
        int result = this.nbGpsMaj;
        fireOnPostRead(PROPERTY_NB_GPS_MAJ, nbGpsMaj);
        return result;
    }

    @Override
    public void setNbSecuMaj(int nbSecuMaj) {
        int oldValue = this.nbSecuMaj;
        fireOnPreWrite(PROPERTY_NB_SECU_MAJ, oldValue, nbSecuMaj);
        this.nbSecuMaj = nbSecuMaj;
        fireOnPostWrite(PROPERTY_NB_SECU_MAJ, oldValue, nbSecuMaj);
    }

    @Override
    public int getNbSecuMaj() {
        fireOnPreRead(PROPERTY_NB_SECU_MAJ, nbSecuMaj);
        int result = this.nbSecuMaj;
        fireOnPostRead(PROPERTY_NB_SECU_MAJ, nbSecuMaj);
        return result;
    }

    @Override
    public void setNbMaj(int nbMaj) {
        int oldValue = this.nbMaj;
        fireOnPreWrite(PROPERTY_NB_MAJ, oldValue, nbMaj);
        this.nbMaj = nbMaj;
        fireOnPostWrite(PROPERTY_NB_MAJ, oldValue, nbMaj);
    }

    @Override
    public int getNbMaj() {
        fireOnPreRead(PROPERTY_NB_MAJ, nbMaj);
        int result = this.nbMaj;
        fireOnPostRead(PROPERTY_NB_MAJ, nbMaj);
        return result;
    }

    @Override
    public void setNbSynchWifi(int nbSynchWifi) {
        int oldValue = this.nbSynchWifi;
        fireOnPreWrite(PROPERTY_NB_SYNCH_WIFI, oldValue, nbSynchWifi);
        this.nbSynchWifi = nbSynchWifi;
        fireOnPostWrite(PROPERTY_NB_SYNCH_WIFI, oldValue, nbSynchWifi);
    }

    @Override
    public int getNbSynchWifi() {
        fireOnPreRead(PROPERTY_NB_SYNCH_WIFI, nbSynchWifi);
        int result = this.nbSynchWifi;
        fireOnPostRead(PROPERTY_NB_SYNCH_WIFI, nbSynchWifi);
        return result;
    }

    @Override
    public void setNbSynchAuto(int nbSynchAuto) {
        int oldValue = this.nbSynchAuto;
        fireOnPreWrite(PROPERTY_NB_SYNCH_AUTO, oldValue, nbSynchAuto);
        this.nbSynchAuto = nbSynchAuto;
        fireOnPostWrite(PROPERTY_NB_SYNCH_AUTO, oldValue, nbSynchAuto);
    }

    @Override
    public int getNbSynchAuto() {
        fireOnPreRead(PROPERTY_NB_SYNCH_AUTO, nbSynchAuto);
        int result = this.nbSynchAuto;
        fireOnPostRead(PROPERTY_NB_SYNCH_AUTO, nbSynchAuto);
        return result;
    }

    @Override
    public void setNbSynchGPRS(int nbSynchGPRS) {
        int oldValue = this.nbSynchGPRS;
        fireOnPreWrite(PROPERTY_NB_SYNCH_GPRS, oldValue, nbSynchGPRS);
        this.nbSynchGPRS = nbSynchGPRS;
        fireOnPostWrite(PROPERTY_NB_SYNCH_GPRS, oldValue, nbSynchGPRS);
    }

    @Override
    public int getNbSynchGPRS() {
        fireOnPreRead(PROPERTY_NB_SYNCH_GPRS, nbSynchGPRS);
        int result = this.nbSynchGPRS;
        fireOnPostRead(PROPERTY_NB_SYNCH_GPRS, nbSynchGPRS);
        return result;
    }

    @Override
    public void setNbSynchKo(int nbSynchKo) {
        int oldValue = this.nbSynchKo;
        fireOnPreWrite(PROPERTY_NB_SYNCH_KO, oldValue, nbSynchKo);
        this.nbSynchKo = nbSynchKo;
        fireOnPostWrite(PROPERTY_NB_SYNCH_KO, oldValue, nbSynchKo);
    }

    @Override
    public int getNbSynchKo() {
        fireOnPreRead(PROPERTY_NB_SYNCH_KO, nbSynchKo);
        int result = this.nbSynchKo;
        fireOnPostRead(PROPERTY_NB_SYNCH_KO, nbSynchKo);
        return result;
    }

    @Override
    public void setNbOctetsReceivedGPRS(int nbOctetsReceivedGPRS) {
        int oldValue = this.nbOctetsReceivedGPRS;
        fireOnPreWrite(PROPERTY_NB_OCTETS_RECEIVED_GPRS, oldValue, nbOctetsReceivedGPRS);
        this.nbOctetsReceivedGPRS = nbOctetsReceivedGPRS;
        fireOnPostWrite(PROPERTY_NB_OCTETS_RECEIVED_GPRS, oldValue, nbOctetsReceivedGPRS);
    }

    @Override
    public int getNbOctetsReceivedGPRS() {
        fireOnPreRead(PROPERTY_NB_OCTETS_RECEIVED_GPRS, nbOctetsReceivedGPRS);
        int result = this.nbOctetsReceivedGPRS;
        fireOnPostRead(PROPERTY_NB_OCTETS_RECEIVED_GPRS, nbOctetsReceivedGPRS);
        return result;
    }

    @Override
    public void setNbOctetsSendGPRS(int nbOctetsSendGPRS) {
        int oldValue = this.nbOctetsSendGPRS;
        fireOnPreWrite(PROPERTY_NB_OCTETS_SEND_GPRS, oldValue, nbOctetsSendGPRS);
        this.nbOctetsSendGPRS = nbOctetsSendGPRS;
        fireOnPostWrite(PROPERTY_NB_OCTETS_SEND_GPRS, oldValue, nbOctetsSendGPRS);
    }

    @Override
    public int getNbOctetsSendGPRS() {
        fireOnPreRead(PROPERTY_NB_OCTETS_SEND_GPRS, nbOctetsSendGPRS);
        int result = this.nbOctetsSendGPRS;
        fireOnPostRead(PROPERTY_NB_OCTETS_SEND_GPRS, nbOctetsSendGPRS);
        return result;
    }

    @Override
    public void setNbOctetsReceivedWifi(int nbOctetsReceivedWifi) {
        int oldValue = this.nbOctetsReceivedWifi;
        fireOnPreWrite(PROPERTY_NB_OCTETS_RECEIVED_WIFI, oldValue, nbOctetsReceivedWifi);
        this.nbOctetsReceivedWifi = nbOctetsReceivedWifi;
        fireOnPostWrite(PROPERTY_NB_OCTETS_RECEIVED_WIFI, oldValue, nbOctetsReceivedWifi);
    }

    @Override
    public int getNbOctetsReceivedWifi() {
        fireOnPreRead(PROPERTY_NB_OCTETS_RECEIVED_WIFI, nbOctetsReceivedWifi);
        int result = this.nbOctetsReceivedWifi;
        fireOnPostRead(PROPERTY_NB_OCTETS_RECEIVED_WIFI, nbOctetsReceivedWifi);
        return result;
    }

    @Override
    public void setNbOctetsSendWifi(int nbOctetsSendWifi) {
        int oldValue = this.nbOctetsSendWifi;
        fireOnPreWrite(PROPERTY_NB_OCTETS_SEND_WIFI, oldValue, nbOctetsSendWifi);
        this.nbOctetsSendWifi = nbOctetsSendWifi;
        fireOnPostWrite(PROPERTY_NB_OCTETS_SEND_WIFI, oldValue, nbOctetsSendWifi);
    }

    @Override
    public int getNbOctetsSendWifi() {
        fireOnPreRead(PROPERTY_NB_OCTETS_SEND_WIFI, nbOctetsSendWifi);
        int result = this.nbOctetsSendWifi;
        fireOnPostRead(PROPERTY_NB_OCTETS_SEND_WIFI, nbOctetsSendWifi);
        return result;
    }

    @Override
    public void setNbNotifs(int nbNotifs) {
        int oldValue = this.nbNotifs;
        fireOnPreWrite(PROPERTY_NB_NOTIFS, oldValue, nbNotifs);
        this.nbNotifs = nbNotifs;
        fireOnPostWrite(PROPERTY_NB_NOTIFS, oldValue, nbNotifs);
    }

    @Override
    public int getNbNotifs() {
        fireOnPreRead(PROPERTY_NB_NOTIFS, nbNotifs);
        int result = this.nbNotifs;
        fireOnPostRead(PROPERTY_NB_NOTIFS, nbNotifs);
        return result;
    }

    @Override
    public void setLastSynch(Date lastSynch) {
        Date oldValue = this.lastSynch;
        fireOnPreWrite(PROPERTY_LAST_SYNCH, oldValue, lastSynch);
        this.lastSynch = lastSynch;
        fireOnPostWrite(PROPERTY_LAST_SYNCH, oldValue, lastSynch);
    }

    @Override
    public Date getLastSynch() {
        fireOnPreRead(PROPERTY_LAST_SYNCH, lastSynch);
        Date result = this.lastSynch;
        fireOnPostRead(PROPERTY_LAST_SYNCH, lastSynch);
        return result;
    }

    @Override
    public void setLastModif(Date lastModif) {
        Date oldValue = this.lastModif;
        fireOnPreWrite(PROPERTY_LAST_MODIF, oldValue, lastModif);
        this.lastModif = lastModif;
        fireOnPostWrite(PROPERTY_LAST_MODIF, oldValue, lastModif);
    }

    @Override
    public Date getLastModif() {
        fireOnPreRead(PROPERTY_LAST_MODIF, lastModif);
        Date result = this.lastModif;
        fireOnPostRead(PROPERTY_LAST_MODIF, lastModif);
        return result;
    }

    @Override
    public void setTaasUser(TaasUser taasUser) {
        TaasUser oldValue = this.taasUser;
        fireOnPreWrite(PROPERTY_TAAS_USER, oldValue, taasUser);
        this.taasUser = taasUser;
        fireOnPostWrite(PROPERTY_TAAS_USER, oldValue, taasUser);
    }

    @Override
    public TaasUser getTaasUser() {
        fireOnPreRead(PROPERTY_TAAS_USER, taasUser);
        TaasUser result = this.taasUser;
        fireOnPostRead(PROPERTY_TAAS_USER, taasUser);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NB_GPS_MAJ, this.nbGpsMaj).
            append(PROPERTY_NB_SECU_MAJ, this.nbSecuMaj).
            append(PROPERTY_NB_MAJ, this.nbMaj).
            append(PROPERTY_NB_SYNCH_WIFI, this.nbSynchWifi).
            append(PROPERTY_NB_SYNCH_AUTO, this.nbSynchAuto).
            append(PROPERTY_NB_SYNCH_GPRS, this.nbSynchGPRS).
            append(PROPERTY_NB_SYNCH_KO, this.nbSynchKo).
            append(PROPERTY_NB_OCTETS_RECEIVED_GPRS, this.nbOctetsReceivedGPRS).
            append(PROPERTY_NB_OCTETS_SEND_GPRS, this.nbOctetsSendGPRS).
            append(PROPERTY_NB_OCTETS_RECEIVED_WIFI, this.nbOctetsReceivedWifi).
            append(PROPERTY_NB_OCTETS_SEND_WIFI, this.nbOctetsSendWifi).
            append(PROPERTY_NB_NOTIFS, this.nbNotifs).
            append(PROPERTY_LAST_SYNCH, this.lastSynch).
            append(PROPERTY_LAST_MODIF, this.lastModif).
            append(PROPERTY_TAAS_USER, this.taasUser).
         toString();
        return result;
    }

} //UserIndicateursAbstract
