package com.cybelia.sandra.entities;

import com.cybelia.sandra.SandraEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class SocieteDAOAbstract<E extends Societe> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Societe.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.Societe;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Eleveur> list = getContext()
                                                    .getDAO(Eleveur.class)
                                                    .findAllByProperties(Eleveur.PROPERTY_SOCIETE, entity);
                                            for (Eleveur item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getSociete())) {
                                                    item.setSociete(null);
                                                }
                        
                    }
                }

                                        {
                                        List<Transporteur> list = getContext()
                                                    .getDAO(Transporteur.class)
                                                    .findAllByProperties(Transporteur.PROPERTY_SOCIETE, entity);
                                            for (Transporteur item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getSociete())) {
                                                    item.setSociete(null);
                                                }
                        
                    }
                }

                                        {
                                        List<Camion> list = getContext()
                                                    .getDAO(Camion.class)
                                                    .findAllByProperties(Camion.PROPERTY_SOCIETE, entity);
                                            for (Camion item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getSociete())) {
                                                    item.setSociete(null);
                                                }
                        
                    }
                }

                                        {
                                        List<Chauffeur> list = getContext()
                                                    .getDAO(Chauffeur.class)
                                                    .findAllByProperties(Chauffeur.PROPERTY_SOCIETE, entity);
                                            for (Chauffeur item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getSociete())) {
                                                    item.setSociete(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByNaturalId(String code) throws TopiaException {
        return findByProperties(Societe.PROPERTY_CODE, code);
    }

    public boolean existByNaturalId(String code) throws TopiaException {
        return existByProperties(Societe.PROPERTY_CODE, code);
    }

    /**
     * @deprecated since 2.6.10, prefer use {@link #createByNaturalId}
     * @param code 
     * @return 
     * @throws TopiaException
     */
    @Deprecated
    public E create(String code) throws TopiaException {
        return create(Societe.PROPERTY_CODE, code);
    }

    public E createByNaturalId(String code) throws TopiaException {
        return create(Societe.PROPERTY_CODE, code);
    }

    public E createByNotNull(String code) throws TopiaException {
        return create(Societe.PROPERTY_CODE, code);
    }

    public E findByCode(String v) throws TopiaException {
        E result = findByProperty(Societe.PROPERTY_CODE, v);
        return result;
    }

    public List<E> findAllByCode(String v) throws TopiaException {
        List<E> result = findAllByProperty(Societe.PROPERTY_CODE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Chauffeur.class) {
            ChauffeurDAO dao = (ChauffeurDAO)
                getContext().getDAO(Chauffeur.class);
            tmp = dao.findAllBySociete(entity);
            result.addAll(tmp);
        }

        if (type == Transporteur.class) {
            TransporteurDAO dao = (TransporteurDAO)
                getContext().getDAO(Transporteur.class);
            tmp = dao.findAllBySociete(entity);
            result.addAll(tmp);
        }

        if (type == Eleveur.class) {
            EleveurDAO dao = (EleveurDAO)
                getContext().getDAO(Eleveur.class);
            tmp = dao.findAllBySociete(entity);
            result.addAll(tmp);
        }

        if (type == Camion.class) {
            CamionDAO dao = (CamionDAO)
                getContext().getDAO(Camion.class);
            tmp = dao.findAllBySociete(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(4);

        List<? extends TopiaEntity> list;

        list = findUsages(Chauffeur.class, entity);
        if (!list.isEmpty()) {
            result.put(Chauffeur.class, list);
        }

        list = findUsages(Transporteur.class, entity);
        if (!list.isEmpty()) {
            result.put(Transporteur.class, list);
        }

        list = findUsages(Eleveur.class, entity);
        if (!list.isEmpty()) {
            result.put(Eleveur.class, list);
        }

        list = findUsages(Camion.class, entity);
        if (!list.isEmpty()) {
            result.put(Camion.class, list);
        }

        return result;
    }

} //SocieteDAOAbstract<E extends Societe>
