package com.cybelia.sandra.entities;

import com.cybelia.sandra.SandraEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class LabelDAOAbstract<E extends Label> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Label.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.Label;
    }

    public E findByNaturalId(String id, String categorie) throws TopiaException {
        return findByProperties(Label.PROPERTY_ID, id, Label.PROPERTY_CATEGORIE, categorie);
    }

    public boolean existByNaturalId(String id, String categorie) throws TopiaException {
        return existByProperties(Label.PROPERTY_ID, id, Label.PROPERTY_CATEGORIE, categorie);
    }

    /**
     * @deprecated since 2.6.10, prefer use {@link #createByNaturalId}
     * @param id 
     * @param categorie 
     * @return 
     * @throws TopiaException
     */
    @Deprecated
    public E create(String id, String categorie) throws TopiaException {
        return create(Label.PROPERTY_ID, id, Label.PROPERTY_CATEGORIE, categorie);
    }

    public E createByNaturalId(String id, String categorie) throws TopiaException {
        return create(Label.PROPERTY_ID, id, Label.PROPERTY_CATEGORIE, categorie);
    }

    public E createByNotNull(String id, String categorie) throws TopiaException {
        return create(Label.PROPERTY_ID, id, Label.PROPERTY_CATEGORIE, categorie);
    }

    public E findById(String v) throws TopiaException {
        E result = findByProperty(Label.PROPERTY_ID, v);
        return result;
    }

    public List<E> findAllById(String v) throws TopiaException {
        List<E> result = findAllByProperty(Label.PROPERTY_ID, v);
        return result;
    }

    public E findByValeur(String v) throws TopiaException {
        E result = findByProperty(Label.PROPERTY_VALEUR, v);
        return result;
    }

    public List<E> findAllByValeur(String v) throws TopiaException {
        List<E> result = findAllByProperty(Label.PROPERTY_VALEUR, v);
        return result;
    }

    public E findByCategorie(String v) throws TopiaException {
        E result = findByProperty(Label.PROPERTY_CATEGORIE, v);
        return result;
    }

    public List<E> findAllByCategorie(String v) throws TopiaException {
        List<E> result = findAllByProperty(Label.PROPERTY_CATEGORIE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //LabelDAOAbstract<E extends Label>
