package com.cybelia.sandra.entities;

import com.google.common.collect.Lists;
import java.util.List;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class EtapeImpl extends EtapeAbstract {

    private static final long serialVersionUID = 1L;

    @Override
    public boolean isActif() {
        List<LigneProduit> produits = getProduits();
        return produits != null && !produits.isEmpty();
    }

    @Override
    public List<LigneProduit> getProduits() {

        List<LigneProduit> produits = super.getProduits();
        if (produits == null) {
            return null;
        }
        
        List<LigneProduit> actifProduits = Lists.newArrayList();
        for (LigneProduit produit : produits) {
            if (produit.isActif()) {
                actifProduits.add(produit);
            }
        }
        return actifProduits;
    }

    @Override
    public int sizeProduits() {
        List<LigneProduit> produitList = getProduits();
        if (produitList == null) {
            return 0;
        }
        return produitList.size();
    }
}
