package com.cybelia.sandra.entities;

import com.cybelia.sandra.SandraEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class CamionDAOAbstract<E extends Camion> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Camion.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.Camion;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Tour> list = getContext()
                                                    .getDAO(Tour.class)
                                                    .findAllByProperties(Tour.PROPERTY_CAMION, entity);
                                            for (Tour item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getCamion())) {
                                                    item.setCamion(null);
                                                }
                        
                    }
                }

        {
            List<Chauffeur> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from chauffeur main, camions_defautchauffeurs secondary " +
                    "where main.topiaid=secondary.defautChauffeurs" +
                    " and secondary.camions='" + entity.getTopiaId() + "'")
                    .addEntity("main", com.cybelia.sandra.SandraDAOHelper.getImplementationClass(Chauffeur.class)).list();

            for (Chauffeur item : list) {
                item.removeCamions(entity);
            }
        }

        super.delete(entity);
    }

    public E findByNaturalId(String code, Societe societe) throws TopiaException {
        return findByProperties(Camion.PROPERTY_CODE, code, Camion.PROPERTY_SOCIETE, societe);
    }

    public boolean existByNaturalId(String code, Societe societe) throws TopiaException {
        return existByProperties(Camion.PROPERTY_CODE, code, Camion.PROPERTY_SOCIETE, societe);
    }

    /**
     * @deprecated since 2.6.10, prefer use {@link #createByNaturalId}
     * @param code 
     * @param societe 
     * @return 
     * @throws TopiaException
     */
    @Deprecated
    public E create(String code, Societe societe) throws TopiaException {
        return create(Camion.PROPERTY_CODE, code, Camion.PROPERTY_SOCIETE, societe);
    }

    public E createByNaturalId(String code, Societe societe) throws TopiaException {
        return create(Camion.PROPERTY_CODE, code, Camion.PROPERTY_SOCIETE, societe);
    }

    public E createByNotNull(String code, Societe societe) throws TopiaException {
        return create(Camion.PROPERTY_CODE, code, Camion.PROPERTY_SOCIETE, societe);
    }

    public E findByCode(String v) throws TopiaException {
        E result = findByProperty(Camion.PROPERTY_CODE, v);
        return result;
    }

    public List<E> findAllByCode(String v) throws TopiaException {
        List<E> result = findAllByProperty(Camion.PROPERTY_CODE, v);
        return result;
    }

    public E findByNombreCompartiments(int v) throws TopiaException {
        E result = findByProperty(Camion.PROPERTY_NOMBRE_COMPARTIMENTS, v);
        return result;
    }

    public List<E> findAllByNombreCompartiments(int v) throws TopiaException {
        List<E> result = findAllByProperty(Camion.PROPERTY_NOMBRE_COMPARTIMENTS, v);
        return result;
    }

    public E findByActif(boolean v) throws TopiaException {
        E result = findByProperty(Camion.PROPERTY_ACTIF, v);
        return result;
    }

    public List<E> findAllByActif(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Camion.PROPERTY_ACTIF, v);
        return result;
    }

    public E findContainsCamionsAssocies(Camion v) throws TopiaException {
        E result = findContains(Camion.PROPERTY_CAMIONS_ASSOCIES, v);
        return result;
    }

    public List<E> findAllContainsCamionsAssocies(Camion v) throws TopiaException {
        List<E> result = findAllContains(Camion.PROPERTY_CAMIONS_ASSOCIES, v);
        return result;
    }

    public E findContainsDefautChauffeurs(Chauffeur v) throws TopiaException {
        E result = findContains(Camion.PROPERTY_DEFAUT_CHAUFFEURS, v);
        return result;
    }

    public List<E> findAllContainsDefautChauffeurs(Chauffeur v) throws TopiaException {
        List<E> result = findAllContains(Camion.PROPERTY_DEFAUT_CHAUFFEURS, v);
        return result;
    }

    public E findByTransporteur(Transporteur v) throws TopiaException {
        E result = findByProperty(Camion.PROPERTY_TRANSPORTEUR, v);
        return result;
    }

    public List<E> findAllByTransporteur(Transporteur v) throws TopiaException {
        List<E> result = findAllByProperty(Camion.PROPERTY_TRANSPORTEUR, v);
        return result;
    }

    public E findBySociete(Societe v) throws TopiaException {
        E result = findByProperty(Camion.PROPERTY_SOCIETE, v);
        return result;
    }

    public List<E> findAllBySociete(Societe v) throws TopiaException {
        List<E> result = findAllByProperty(Camion.PROPERTY_SOCIETE, v);
        return result;
    }

    public E findByUserIndicateurs(UserIndicateurs v) throws TopiaException {
        E result = findByProperty(Camion.PROPERTY_USER_INDICATEURS, v);
        return result;
    }

    public List<E> findAllByUserIndicateurs(UserIndicateurs v) throws TopiaException {
        List<E> result = findAllByProperty(Camion.PROPERTY_USER_INDICATEURS, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Tour.class) {
            TourDAO dao = (TourDAO)
                getContext().getDAO(Tour.class);
            tmp = dao.findAllByCamion(entity);
            result.addAll(tmp);
        }

        if (type == Chauffeur.class) {
            ChauffeurDAO dao = (ChauffeurDAO)
                getContext().getDAO(Chauffeur.class);
            tmp = dao.findAllContainsCamions(entity);
            result.addAll(tmp);
        }

        if (type == Camion.class) {
            CamionDAO dao = (CamionDAO)
                getContext().getDAO(Camion.class);
            tmp = dao.findAllContainsCamionsAssocies(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(3);

        List<? extends TopiaEntity> list;

        list = findUsages(Tour.class, entity);
        if (!list.isEmpty()) {
            result.put(Tour.class, list);
        }

        list = findUsages(Chauffeur.class, entity);
        if (!list.isEmpty()) {
            result.put(Chauffeur.class, list);
        }

        list = findUsages(Camion.class, entity);
        if (!list.isEmpty()) {
            result.put(Camion.class, list);
        }

        return result;
    }

} //CamionDAOAbstract<E extends Camion>
