/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;

public class Declaration
extends ASTCssNode {
    private String name;
    private Expression expression;
    private boolean important;

    public Declaration(HiddenTokenAwareTree token, String name) {
        this(token, name, null, false);
    }

    public Declaration(HiddenTokenAwareTree token, String name, Expression expression) {
        this(token, name, expression, false);
    }

    public Declaration(HiddenTokenAwareTree token, String name, Expression expression, boolean important) {
        super(token);
        this.name = name;
        this.expression = expression;
        this.important = important;
    }

    public String getName() {
        return this.name;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public boolean isImportant() {
        return this.important;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public void setImportant(boolean important) {
        this.important = important;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.DECLARATION;
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.expression);
    }

    public boolean isFontDeclaration() {
        return this.getName() != null ? this.getName().toLowerCase().equals("font") : false;
    }

    public String toString() {
        return "" + this.name + ":" + this.expression;
    }

    @Override
    public Declaration clone() {
        Declaration result = (Declaration)super.clone();
        result.expression = this.expression == null ? null : this.expression.clone();
        result.configureParentToAllChilds();
        return result;
    }
}

