/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j;

import com.github.sommeri.less4j.utils.URLUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.IOUtils;

public abstract class LessSource {
    public abstract LessSource relativeSource(String var1) throws FileNotFound, CannotReadFile, StringSourceException;

    public abstract String getContent() throws FileNotFound, CannotReadFile;

    public static class CannotReadFile
    extends Exception {
    }

    public static class FileNotFound
    extends Exception {
    }

    public static class StringSourceException
    extends Exception {
    }

    public static class StringSource
    extends LessSource {
        private String content;

        public StringSource(String content) {
            this.content = content;
        }

        @Override
        public String getContent() {
            return this.content;
        }

        @Override
        public LessSource relativeSource(String filename) throws StringSourceException {
            throw new StringSourceException();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StringSource other = (StringSource)obj;
            return !(this.content == null ? other.content != null : !this.content.equals(other.content));
        }
    }

    public static class FileSource
    extends AbstractHierarchicalSource {
        private File inputFile;

        public FileSource(File inputFile) {
            this.inputFile = inputFile;
        }

        public FileSource(FileSource parent, String filename) {
            super(parent);
            this.inputFile = new File(parent.inputFile.getParentFile(), filename);
            parent.addImportedSource(this);
        }

        @Override
        public String getContent() throws FileNotFound, CannotReadFile {
            try {
                FileReader input = new FileReader(this.inputFile);
                String content = IOUtils.toString((Reader)input).replace("\r\n", "\n");
                this.setLastModified(this.inputFile.lastModified());
                input.close();
                return content;
            }
            catch (FileNotFoundException ex) {
                throw new FileNotFound();
            }
            catch (IOException ex) {
                throw new CannotReadFile();
            }
        }

        @Override
        public LessSource relativeSource(String filename) {
            return new FileSource(this, filename);
        }

        public File getInputFile() {
            return this.inputFile;
        }

        public String toString() {
            return this.inputFile.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            File canonicalInputFile = this.getCanonicalFile();
            result = 31 * result + (canonicalInputFile == null ? 0 : canonicalInputFile.hashCode());
            return result;
        }

        private File getCanonicalFile() {
            try {
                return this.inputFile.getCanonicalFile();
            }
            catch (IOException e) {
                return this.inputFile.getAbsoluteFile();
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileSource other = (FileSource)obj;
            File absoluteInputFile = this.getCanonicalFile();
            return !(absoluteInputFile == null ? other.inputFile != null : !absoluteInputFile.equals(other.inputFile.getAbsoluteFile()));
        }
    }

    public static class URLSource
    extends AbstractHierarchicalSource {
        private URL inputURL;

        public URLSource(URL inputURL) {
            this.inputURL = inputURL;
        }

        public URLSource(URLSource parent, String filename) throws FileNotFound, CannotReadFile {
            super(parent);
            try {
                this.inputURL = new URL(URLUtils.toParentURL(parent.inputURL), filename);
            }
            catch (MalformedURLException e) {
                throw new FileNotFound();
            }
            parent.addImportedSource(this);
        }

        @Override
        public String getContent() throws FileNotFound, CannotReadFile {
            try {
                URLConnection connection = this.getInputURL().openConnection();
                InputStreamReader input = new InputStreamReader(connection.getInputStream());
                String content = IOUtils.toString((Reader)input).replace("\r\n", "\n");
                this.setLastModified(connection.getLastModified());
                ((Reader)input).close();
                return content;
            }
            catch (FileNotFoundException ex) {
                throw new FileNotFound();
            }
            catch (IOException ex) {
                throw new CannotReadFile();
            }
        }

        @Override
        public LessSource relativeSource(String filename) throws FileNotFound, CannotReadFile {
            return new URLSource(this, filename);
        }

        public URL getInputURL() {
            return this.inputURL;
        }

        public String toString() {
            return this.inputURL.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.inputURL == null ? 0 : this.inputURL.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            URLSource other = (URLSource)obj;
            return !(this.inputURL == null ? other.inputURL != null : !this.inputURL.equals(other.inputURL));
        }
    }

    public static abstract class AbstractHierarchicalSource
    extends LessSource {
        protected AbstractHierarchicalSource parent;
        protected long lastModified;
        protected long latestModified;
        protected Collection<LessSource> importedSources;

        public AbstractHierarchicalSource() {
            this.importedSources = new ArrayList<LessSource>();
        }

        public AbstractHierarchicalSource(AbstractHierarchicalSource parent) {
            this.parent = parent;
        }

        protected void setLastModified(long lastModified) {
            this.lastModified = lastModified;
            this.latestModified = lastModified;
            if (this.parent != null && lastModified > this.parent.latestModified) {
                this.parent.latestModified = lastModified;
            }
        }

        protected void addImportedSource(LessSource source) {
            if (this.parent != null) {
                this.parent.addImportedSource(source);
            } else {
                this.importedSources.add(source);
            }
        }

        public Collection<LessSource> getImportedSources() {
            return this.importedSources;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public long getLatestModified() {
            return this.latestModified;
        }
    }
}

