/*
 * Decompiled with CFR 0.152.
 */
package com.github.oowekyala.ooxml.messages;

import com.github.oowekyala.ooxml.messages.TextDoc;
import com.github.oowekyala.ooxml.messages.XmlPosition;
import java.util.function.ToIntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

class NewOffsetScanner {
    private static final String PREFIX = "ooxml:";
    private static final String START_OFFSET = "ooxml:startOffset";
    private static final String END_OFFSET = "ooxml:endOffset";
    private static final String CONTENT_START_OFFSET = "ooxml:contentStartOffset";
    private static final Pattern QUOTES = Pattern.compile("[\"']");
    private static final UserDataHandler NO_DATA_HANDLER = (operation, key, data1, src, dst) -> {};
    private final String systemId;
    private final TextDoc textDoc;
    private final String fullText;

    NewOffsetScanner(String systemId, TextDoc textDoc) {
        this.systemId = systemId;
        this.textDoc = textDoc;
        this.fullText = textDoc.getTextString();
    }

    private int indexOf(String s, int start) {
        if (start < 0 || start >= this.fullText.length()) {
            return -1;
        }
        return this.fullText.indexOf(s, start);
    }

    private int indexOf(char c, int start) {
        if (start < 0 || start >= this.fullText.length()) {
            return -1;
        }
        return this.fullText.indexOf(c, start);
    }

    private int indexOf(Pattern c, int start) {
        if (start < 0 || start >= this.fullText.length()) {
            return -1;
        }
        Matcher matcher = c.matcher(this.fullText).region(start, this.fullText.length());
        if (matcher.find()) {
            return matcher.start();
        }
        return -1;
    }

    private int endIdxOf(String target, int start) {
        int targetStart = target.length() == 1 ? this.indexOf(target.charAt(0), start) : this.indexOf(target, start);
        return this.addOffset(targetStart, target.length());
    }

    private int addOffset(int base, int diff) {
        if (base < 0) {
            return -1;
        }
        return base + diff;
    }

    private int startOffset(Node n) {
        return this.getOrCompute(n, START_OFFSET, this::startOffsetImpl);
    }

    private int endOffset(Node n) {
        return this.getOrCompute(n, END_OFFSET, this::endOffsetImpl);
    }

    private int contentStartOffset(Node n) {
        return this.getOrCompute(n, CONTENT_START_OFFSET, this::contentStartOffsetImpl);
    }

    private int getOrCompute(Node n, String key, ToIntFunction<Node> compute) {
        Object data = n.getUserData(key);
        if (data instanceof Integer) {
            return (Integer)data;
        }
        int i = compute.applyAsInt(n);
        n.setUserData(key, i, NO_DATA_HANDLER);
        return i;
    }

    private int startOffsetImpl(Node n) {
        if (n.getNodeType() == 9) {
            return this.fullText.isEmpty() ? -1 : 0;
        }
        Node prev = n.getPreviousSibling();
        int start = prev != null ? this.endOffset(prev) : (n.getParentNode() != null ? this.contentStartOffset(n.getParentNode()) : (n instanceof Attr ? this.startOffset(((Attr)n).getOwnerElement()) : -1));
        if (start < 0) {
            return -1;
        }
        switch (n.getNodeType()) {
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 10: {
                return this.indexOf('<', start);
            }
            case 2: {
                return this.attributeOffset((Attr)n, start);
            }
            case 5: {
                return this.indexOf('&', start);
            }
            case 3: {
                return start;
            }
        }
        throw new IllegalStateException("Unhandled node type " + n.getNodeType() + " (" + n + ")");
    }

    private int attributeOffset(Attr attr, int startOffset) {
        assert (startOffset >= 0);
        String textString = this.fullText;
        int searchEnd = textString.indexOf(62, startOffset);
        Matcher matcher = Pattern.compile(attr.getName() + "\\s*=").matcher(textString).region(startOffset, searchEnd);
        if (matcher.find()) {
            return matcher.start();
        }
        return startOffset;
    }

    private int endOffsetImpl(Node n) {
        switch (n.getNodeType()) {
            case 8: {
                return this.endIdxOf("-->", this.startOffset(n));
            }
            case 4: {
                return this.endIdxOf("]]>", this.startOffset(n));
            }
            case 3: {
                return this.textEnd((Text)n);
            }
            case 9: {
                return this.fullText.length();
            }
            case 5: {
                return this.endIdxOf(";", this.startOffset(n));
            }
            case 10: {
                return this.endIdxOf("]>", this.startOffset(n));
            }
            case 1: {
                Node last = n.getLastChild();
                if (last != null) {
                    return this.endIdxOf(">", this.endOffset(last));
                }
                int content = this.contentStartOffset(n);
                if (content < 0) {
                    return content;
                }
                if (content >= 2 && this.fullText.charAt(content - 2) == '/') {
                    return content;
                }
                return this.endIdxOf(">", content);
            }
        }
        throw new IllegalStateException("Unhandled node type " + n.getNodeType() + " (" + n + ")");
    }

    private int textEnd(Text n) {
        int start = this.startOffset(n);
        String text = n.getNodeValue();
        boolean inCdata = false;
        int realLength = text.length();
        int i = start;
        while (i < this.fullText.length() && i < realLength) {
            if (!inCdata && this.fullText.charAt(i) == '&') {
                int refEnd = this.fullText.indexOf(59, i);
                assert (refEnd > 0) : "Unclosed entity reference! This shouldn't have parsed!";
                realLength += refEnd - i - 1;
                i = refEnd + 1;
                continue;
            }
            if (!inCdata && this.fullText.startsWith("<![CDATA[", i)) {
                inCdata = true;
                i += "<![CDATA[".length();
                realLength += "<![CDATA[".length();
                continue;
            }
            if (inCdata && this.fullText.startsWith("]]>", i)) {
                inCdata = false;
                i += "]]>".length();
                realLength += "]]>".length();
                continue;
            }
            ++i;
        }
        return start + realLength;
    }

    private int contentStartOffsetImpl(Node n) {
        switch (n.getNodeType()) {
            case 9: {
                int firstLt = this.fullText.indexOf(60);
                if (firstLt < 0) {
                    return firstLt;
                }
                if (this.fullText.startsWith("<?xml", firstLt)) {
                    return this.endIdxOf(">", firstLt);
                }
                return this.fullText.isEmpty() ? -1 : 0;
            }
            case 1: {
                int lt = this.indexOf('>', this.startOffset(n));
                return this.addOffset(lt, 1);
            }
            case 10: {
                return this.addOffset(this.startOffset(n), "<!DOCTYPE".length());
            }
            case 8: {
                return this.addOffset(this.startOffset(n), "<!--".length());
            }
            case 7: {
                int start = this.startOffset(n);
                if (start < 0) {
                    return start;
                }
                return start + "<?".length() + ((ProcessingInstruction)n).getTarget().length() + 1;
            }
            case 2: {
                int quoteIdx = this.indexOf(QUOTES, this.startOffset(n));
                return this.addOffset(quoteIdx, 1);
            }
        }
        throw new IllegalStateException("Leaf node cannot have content");
    }

    public XmlPosition beginPos(Node node) {
        int offset = this.startOffset(node);
        if (offset < 0) {
            return XmlPosition.undefinedIn(this.systemId);
        }
        int line = this.textDoc.lineNumberFromOffset(offset);
        int column = this.textDoc.columnFromOffset(line, offset);
        return new XmlPosition(this.systemId, line, column, this.length(node));
    }

    private int length(Node node) {
        if (node instanceof Attr) {
            return ((Attr)node).getName().length();
        }
        if (node instanceof Element) {
            return ((Element)node).getTagName().length() + 1;
        }
        return 0;
    }
}

