/*
 * Decompiled with CFR 0.152.
 */
package com.github.mxab.thymeleaf.extras.dataattribute.dialect;

import com.github.mxab.thymeleaf.extras.dataattribute.dialect.DataAttributeMatcher;
import java.util.Map;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Attribute;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.AbstractProcessor;
import org.thymeleaf.processor.IProcessorMatcher;
import org.thymeleaf.processor.ProcessorMatchingContext;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.standard.expression.StandardExpressionProcessor;

public class DataProcessor
extends AbstractProcessor {
    public int getPrecedence() {
        return 1100;
    }

    public IProcessorMatcher<? extends Node> getMatcher() {
        return new DataAttributeMatcher();
    }

    protected ProcessorResult doProcess(Arguments arguments, ProcessorMatchingContext processorMatchingContext, Node node) {
        Element element = (Element)node;
        Map attributeMap = element.getAttributeMap();
        String dialectPrefix = processorMatchingContext.getDialectPrefix();
        for (Attribute attribute : attributeMap.values()) {
            String dataAttrName = attribute.getUnprefixedNormalizedName();
            String attributeName = attribute.getNormalizedName();
            if (!dialectPrefix.equals(attribute.getNormalizedPrefix())) continue;
            String attributeValue = element.getAttributeValue(attributeName);
            Object result = StandardExpressionProcessor.processExpression((Arguments)arguments, (String)attributeValue);
            element.setAttribute(String.format("data-%s", dataAttrName), result.toString());
            element.removeAttribute(attributeName);
        }
        return ProcessorResult.ok();
    }
}

