/*
 * Decompiled with CFR 0.152.
 */
package smile.base.mlp;

import smile.base.mlp.Cost;
import smile.math.MathEx;
import smile.tensor.Vector;

public enum OutputFunction {
    LINEAR{

        @Override
        public void f(Vector x) {
        }

        @Override
        public void g(Cost cost, Vector g, Vector y) {
            switch (cost) {
                case MEAN_SQUARED_ERROR: {
                    break;
                }
                case LIKELIHOOD: {
                    throw new IllegalStateException("SOFTMAX must work with LIKELIHOOD cost function");
                }
            }
        }
    }
    ,
    SIGMOID{

        @Override
        public void f(Vector x) {
            for (int i = 0; i < x.size(); ++i) {
                x.set(i, MathEx.sigmoid((double)x.get(i)));
            }
        }

        @Override
        public void g(Cost cost, Vector g, Vector y) {
            switch (cost) {
                case MEAN_SQUARED_ERROR: {
                    for (int i = 0; i < g.size(); ++i) {
                        double yi = y.get(i);
                        g.mul(i, yi * (1.0 - yi));
                    }
                    break;
                }
            }
        }
    }
    ,
    SOFTMAX{

        @Override
        public void f(Vector x) {
            x.softmax();
        }

        @Override
        public void g(Cost cost, Vector g, Vector y) {
            switch (cost) {
                case MEAN_SQUARED_ERROR: {
                    throw new IllegalStateException("SOFTMAX must work with LIKELIHOOD cost function");
                }
            }
        }
    };


    public abstract void f(Vector var1);

    public abstract void g(Cost var1, Vector var2, Vector var3);
}

