/*
 * Decompiled with CFR 0.152.
 */
package smile.anomaly;

import java.util.Properties;
import smile.base.svm.KernelMachine;
import smile.base.svm.OCSVM;
import smile.math.kernel.MercerKernel;

public class SVM<T>
extends KernelMachine<T> {
    public SVM(MercerKernel<T> kernel, T[] vectors, double[] weight, double b) {
        super(kernel, vectors, weight, b);
    }

    public static <T> SVM<T> fit(T[] x, MercerKernel<T> kernel) {
        return SVM.fit(x, kernel, new Options());
    }

    public static <T> SVM<T> fit(T[] x, MercerKernel<T> kernel, Options options) {
        OCSVM<T> svm = new OCSVM<T>(kernel, options.nu, options.tol);
        KernelMachine<T> model = svm.fit(x);
        return new SVM<T>(model.kernel(), model.vectors(), model.weights(), model.intercept());
    }

    public record Options(double nu, double tol) {
        public Options {
            if (nu <= 0.0 || nu > 1.0) {
                throw new IllegalArgumentException("Invalid nu: " + nu);
            }
            if (tol <= 0.0) {
                throw new IllegalArgumentException("Invalid tolerance: " + tol);
            }
        }

        public Options() {
            this(0.5, 0.001);
        }

        public Properties toProperties() {
            Properties props = new Properties();
            props.setProperty("smile.svm.nu", Double.toString(this.nu));
            props.setProperty("smile.svm.tolerance", Double.toString(this.tol));
            return props;
        }

        public static Options of(Properties props) {
            double nu = Double.parseDouble(props.getProperty("smile.svm.nu", "0.5"));
            double tol = Double.parseDouble(props.getProperty("smile.svm.tolerance", "1E-3"));
            return new Options(nu, tol);
        }
    }
}

