/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.hypothesis;

import java.util.Arrays;
import smile.math.MathEx;
import smile.stat.distribution.Distribution;

public record KSTest(String method, double d, double pvalue) {
    @Override
    public String toString() {
        return String.format("%s Kolmogorov-Smirnov Test(d = %.4f, p-value = %G)", this.method, this.d, this.pvalue);
    }

    private static double pks(double z) {
        if (z < 0.0) {
            throw new IllegalArgumentException("Invalid z: " + z);
        }
        if (z == 0.0) {
            return 0.0;
        }
        if (z < 1.18) {
            double y = Math.exp(-1.2337005501361697 / (z * z));
            return 2.256758334191025 * Math.sqrt(-Math.log(y)) * (y + Math.pow(y, 9.0) + Math.pow(y, 25.0) + Math.pow(y, 49.0));
        }
        double x = Math.exp(-2.0 * (z * z));
        return 1.0 - 2.0 * (x - Math.pow(x, 4.0) + Math.pow(x, 9.0));
    }

    private static double qks(double z) {
        if (z < 0.0) {
            throw new IllegalArgumentException("Invalid z: " + z);
        }
        if (z == 0.0) {
            return 1.0;
        }
        if (z < 1.18) {
            return 1.0 - KSTest.pks(z);
        }
        double x = Math.exp(-2.0 * (z * z));
        return 2.0 * (x - Math.pow(x, 4.0) + Math.pow(x, 9.0));
    }

    private static double invqks(double q) {
        double xp;
        if (q <= 0.0 || q > 1.0) {
            throw new IllegalArgumentException("Invalid q: " + q);
        }
        if (q == 1.0) {
            return 0.0;
        }
        if (q > 0.3) {
            double ff;
            double logy;
            double u;
            double t2;
            double f = -0.39269908169872414 * MathEx.pow2(1.0 - q);
            double y = KSTest.invxlogx(f);
            while (Math.abs((t2 = (u = (y * (logy = Math.log(y)) - (ff = f / MathEx.pow2(1.0 + Math.pow(y, 4.0) + Math.pow(y, 12.0)))) / (1.0 + logy)) / Math.max(0.5, 1.0 - 0.5 * u / (y * (1.0 + logy)))) / (y -= t2)) > 1.0E-15) {
            }
            return 1.5707963267948966 / Math.sqrt(-Math.log(y));
        }
        double x = 0.03;
        do {
            xp = x;
            if (!((x = 0.5 * q + Math.pow(x, 4.0) - Math.pow(x, 9.0)) > 0.06)) continue;
            x += Math.pow(x, 16.0) - Math.pow(x, 25.0);
        } while (Math.abs((xp - x) / x) > 1.0E-15);
        return Math.sqrt(-0.5 * Math.log(x));
    }

    private static double invpks(double p) {
        return KSTest.invqks(1.0 - p);
    }

    private static double invxlogx(double y) {
        double t2;
        double ooe = 0.36787944117144233;
        double to = 0.0;
        if (y >= 0.0 || y <= -0.36787944117144233) {
            throw new IllegalArgumentException("Invalid y: " + y);
        }
        double u = y < -0.2 ? Math.log(0.36787944117144233 - Math.sqrt(0.7357588823428847 * (y + 0.36787944117144233))) : -10.0;
        do {
            t2 = (Math.log(y / u) - u) * (u / (1.0 + u));
            u += t2;
            if (t2 < 1.0E-8 && Math.abs(t2 + to) < 0.01 * Math.abs(t2)) break;
            to = t2;
        } while (Math.abs(t2 / u) > 1.0E-15);
        return Math.exp(u);
    }

    public static KSTest test(double[] x, Distribution dist) {
        Arrays.sort(x);
        int n = x.length;
        double en = n;
        double d = 0.0;
        double fo = 0.0;
        for (int j = 0; j < n; ++j) {
            double fn = (double)(j + 1) / en;
            double ff = dist.cdf(x[j]);
            double dt = Math.max(Math.abs(fo - ff), Math.abs(fn - ff));
            if (dt > d) {
                d = dt;
            }
            fo = fn;
        }
        en = Math.sqrt(en);
        double p = KSTest.qks((en + 0.12 + 0.11 / en) * d);
        return new KSTest(dist.toString(), d, p);
    }

    public static KSTest test(double[] x, double[] y) {
        Arrays.sort(x);
        Arrays.sort(y);
        int j1 = 0;
        int j2 = 0;
        int n1 = x.length;
        int n2 = y.length;
        double en1 = n1;
        double en2 = n2;
        double d = 0.0;
        double fn1 = 0.0;
        double fn2 = 0.0;
        while (j1 < n1 && j2 < n2) {
            double d2;
            double d3;
            double d4;
            double d1 = x[j1];
            double d22 = y[j2];
            if (d4 <= d3) {
                do {
                    fn1 = (double)(++j1) / en1;
                } while (j1 < n1 && d1 == x[j1]);
            }
            if (d22 <= d1) {
                do {
                    fn2 = (double)(++j2) / en2;
                } while (j2 < n2 && d22 == y[j2]);
            }
            double dt = Math.abs(fn2 - fn1);
            if (!(d2 > d)) continue;
            d = dt;
        }
        double en = Math.sqrt(en1 * en2 / (en1 + en2));
        double p = KSTest.qks((en + 0.12 + 0.11 / en) * d);
        return new KSTest("Two Sample", d, p);
    }
}

